/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.openslx.bwlp.sat.thrift.ServerHandler;
import org.openslx.bwlp.thrift.iface.SatelliteServer;
import org.openslx.util.Util;

public class JsonHttpListener
extends NanoHTTPD {
    private static final Logger LOGGER = LogManager.getLogger(JsonHttpListener.class);
    private final SatelliteServer.Processor<ServerHandler> processor = new SatelliteServer.Processor<ServerHandler>(new ServerHandler());

    public JsonHttpListener(int port, ExecutorService es) throws IOException {
        super("127.0.0.1", port, es);
        this.maxRequestSize = 1000000;
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Response res = this.serveInternal(session);
        if (res != null) {
            JsonHttpListener.addCorsHeaders(res);
        }
        return res;
    }

    private NanoHTTPD.Response serveInternal(NanoHTTPD.IHTTPSession session) {
        NanoHTTPD.Method method = session.getMethod();
        if (NanoHTTPD.Method.OPTIONS.equals((Object)method)) {
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NO_CONTENT, "application/json", "");
        }
        if (!NanoHTTPD.Method.PUT.equals((Object)method) && !NanoHTTPD.Method.POST.equals((Object)method)) {
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain; charset=UTF-8", "Method not supported");
        }
        try {
            int ret;
            String str = session.getHeaders().get("content-length");
            int len = 0;
            if (str != null) {
                len = Util.parseInt(str, 0);
            }
            if (len <= 0) {
                len = session.getInputStream().available();
            }
            if (len <= 0) {
                return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain; charset=UTF-8", "No Content-Length provided");
            }
            byte[] buffer = new byte[len];
            for (int pos = 0; pos < len; pos += ret) {
                ret = session.getInputStream().read(buffer, pos, len - pos);
                if (ret > 0) continue;
                return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain; charset=UTF-8", "Request content truncated (" + pos + "/" + len + ")");
            }
            TMemoryBuffer inbuffer = new TMemoryBuffer(buffer.length);
            inbuffer.write(buffer);
            TJSONProtocol inprotocol = new TJSONProtocol(inbuffer);
            TMemoryBuffer outbuffer = new TMemoryBuffer(900);
            TJSONProtocol outprotocol = new TJSONProtocol(outbuffer);
            this.processor.process(inprotocol, outprotocol);
            buffer = Arrays.copyOf(outbuffer.getArray(), outbuffer.length());
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json", buffer);
        }
        catch (Throwable t) {
            if (!t.getMessage().contains("Remote side has closed")) {
                LOGGER.warn("Error handling HTTP thrift", t);
            }
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain; charset=UTF-8", t.getMessage());
        }
    }

    @Override
    public void serverStopped() {
        System.exit(1);
    }

    private static void addCorsHeaders(NanoHTTPD.Response response) {
        response.addHeader("Allow", "OPTIONS, GET, HEAD, POST, PUT");
        response.addHeader("Access-Control-Allow-Methods", "*");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Headers", "*, Content-Type");
        response.addHeader("Access-Control-Max-Age", "86400");
    }
}

