/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.permissions.User;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.AuthorizationError;
import org.openslx.bwlp.thrift.iface.Role;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class SessionManager {
    private static final Logger LOGGER = LogManager.getLogger(SessionManager.class);
    private static final Map<String, Entry> tokenManager = new ConcurrentHashMap<String, Entry>();

    public static UserInfo getOrFail(String token) throws TAuthorizationException, TInvocationException {
        UserInfo ui = SessionManager.getInternal(token);
        if (ui != null) {
            return ui;
        }
        throw new TAuthorizationException(AuthorizationError.NOT_AUTHENTICATED, "Your session token is not known to the server");
    }

    public static void ensureAuthenticated(String token) throws TAuthorizationException, TInvocationException {
        SessionManager.getInternal(token);
    }

    public static UserInfo get(String token) {
        try {
            return SessionManager.getInternal(token);
        }
        catch (TAuthorizationException | TInvocationException e) {
            return null;
        }
    }

    private static UserInfo getInternal(String token) throws TAuthorizationException, TInvocationException {
        Entry e = tokenManager.get(token);
        if (e == null) {
            LOGGER.info("Cache miss for token " + token + ", asking master");
            return SessionManager.getRemote(token);
        }
        long now = System.currentTimeMillis();
        if (e.isTooOld(now)) {
            tokenManager.remove(token);
            return SessionManager.getRemote(token);
        }
        e.touch(now);
        return e.user;
    }

    public static void remove(String token) {
        tokenManager.remove(token);
    }

    private static UserInfo getRemote(String token) throws TAuthorizationException, TInvocationException {
        UserInfo ui = null;
        try {
            ui = ThriftManager.getMasterClient().getUserFromToken(token);
        }
        catch (TInvalidTokenException ite) {
            LOGGER.warn("Master says: Invalid token: " + token);
            throw new TAuthorizationException(AuthorizationError.INVALID_TOKEN, "Your token is not known to the master server");
        }
        catch (Exception e) {
            LOGGER.warn("Could not reach master server to query for user token (" + token + ") of a client!", (Throwable)e);
            throw new TInvocationException();
        }
        LOGGER.info("Got '" + Formatter.userFullName(ui) + "' (" + ui.userId + "/" + ui.role + ") for token " + token);
        if (ui.role == null) {
            ui.role = Role.STUDENT;
        }
        AuthorizationError authError = User.canLogin(ui);
        SessionManager.handleAuthorizationError(ui, authError);
        if (ui.role != Role.STUDENT) {
            try {
                DbUser.writeUserOnLogin(ui);
            }
            catch (SQLException e) {
                LOGGER.info("User " + ui.userId + " cannot be written to DB - rejecting.");
                throw new TInvocationException();
            }
            authError = User.canLogin(ui);
            SessionManager.handleAuthorizationError(ui, authError);
        }
        tokenManager.put(token, new Entry(ui));
        return ui;
    }

    private static void handleAuthorizationError(UserInfo ui, AuthorizationError authError) throws TAuthorizationException {
        if (authError == null) {
            return;
        }
        LOGGER.info("User " + ui.userId + " cannot login: " + authError.toString());
        switch (authError) {
            case ACCOUNT_SUSPENDED: {
                throw new TAuthorizationException(authError, "Your account is not allowed to log in to this satellite");
            }
            case BANNED_NETWORK: {
                throw new TAuthorizationException(authError, "Your IP address is banned from this satellite");
            }
            case INVALID_CREDENTIALS: 
            case INVALID_KEY: 
            case CHALLENGE_FAILED: {
                throw new TAuthorizationException(authError, "Authentication error");
            }
            case INVALID_ORGANIZATION: {
                throw new TAuthorizationException(authError, "Your organization is not known to this satellite");
            }
            case ORGANIZATION_SUSPENDED: {
                throw new TAuthorizationException(authError, "Your organization is not allowed to log in to this satellite");
            }
            case NOT_AUTHENTICATED: 
            case NO_PERMISSION: {
                throw new TAuthorizationException(authError, "No permission");
            }
        }
        throw new TAuthorizationException(authError, "Internal server error");
    }

    static {
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){

            @Override
            public void fire() {
                long now = System.currentTimeMillis();
                Iterator it = tokenManager.values().iterator();
                while (it.hasNext()) {
                    Entry e = (Entry)it.next();
                    if (e != null && !e.isTooOld(now)) continue;
                    it.remove();
                }
            }
        }, 60000L, 1200600L);
    }

    private static class Entry {
        private static final long SESSION_TIMEOUT = TimeUnit.DAYS.toMillis(1L);
        private final UserInfo user;
        private long validUntil;

        private Entry(UserInfo user) {
            this.user = user;
            this.validUntil = System.currentTimeMillis() + SESSION_TIMEOUT;
        }

        public void touch(long now) {
            this.validUntil = now + SESSION_TIMEOUT;
        }

        public boolean isTooOld(long now) {
            return this.validUntil < now;
        }
    }
}

