/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift.cache;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public abstract class CacheBase<T> {
    private static final Logger LOGGER = LogManager.getLogger(CacheBase.class);
    private static final int TIMEOUT = 600000;
    private T cachedInstance = null;
    private long cacheTimeout = 0L;
    private CountDownLatch latch = null;

    protected abstract T getCallback() throws TException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getInternal() {
        CountDownLatch localLatch;
        boolean doFetch = false;
        CacheBase cacheBase = this;
        synchronized (cacheBase) {
            if (this.cachedInstance != null && System.currentTimeMillis() < this.cacheTimeout) {
                return this.cachedInstance;
            }
            if (this.latch == null) {
                this.latch = new CountDownLatch(1);
                doFetch = true;
            }
            localLatch = this.latch;
        }
        if (doFetch) {
            new Thread(this.getClass().getSimpleName() + "-Update"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object freshInstance = null;
                    try {
                        freshInstance = CacheBase.this.getCallback();
                    }
                    catch (TException e) {
                        LOGGER.warn("Could not retrieve fresh instance of " + this.getClass().getSimpleName(), (Throwable)e);
                    }
                    finally {
                        CacheBase cacheBase = CacheBase.this;
                        synchronized (cacheBase) {
                            if (freshInstance != null) {
                                CacheBase.this.cachedInstance = freshInstance;
                                CacheBase.this.cacheTimeout = System.currentTimeMillis() + 600000L;
                            }
                            CacheBase.this.latch = null;
                        }
                        localLatch.countDown();
                    }
                }
            }.start();
        }
        boolean ok = false;
        try {
            int waitTime = this.cachedInstance == null ? 600 : 1;
            ok = localLatch.await(waitTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!ok && System.currentTimeMillis() - this.cacheTimeout > 86400000L) {
            LOGGER.warn("CacheUpdate for " + this.getClass().getSimpleName() + " timed out, using old data from >= 1 day ago.");
        }
        CacheBase cacheBase2 = this;
        synchronized (cacheBase2) {
            return this.cachedInstance;
        }
    }
}

