/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift.cache;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.sat.database.mappers.DbOrganization;
import org.openslx.bwlp.sat.thrift.cache.CacheBase;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class OrganizationList
extends CacheBase<List<Organization>> {
    private static final Logger LOGGER = LogManager.getLogger(OrganizationList.class);
    private static final OrganizationList instance = new OrganizationList();

    public static List<Organization> get() {
        return (List)instance.getInternal();
    }

    @Override
    protected List<Organization> getCallback() {
        List<Organization> organizations;
        try {
            organizations = ThriftManager.getMasterClient().getOrganizations();
        }
        catch (Exception e1) {
            LOGGER.warn("Could not fetch Organization list from master, using local data...", (Throwable)(e1 instanceof TTransportException ? null : e1));
            try {
                return DbOrganization.getAll();
            }
            catch (Exception e) {
                LOGGER.warn("Using local Organization list from database also failed.", (Throwable)e);
                return null;
            }
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try {
                    DbOrganization.storeOrganizations(organizations);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });
        return organizations;
    }

    public static Organization find(String organizationId) {
        List<Organization> list = OrganizationList.get();
        if (list == null) {
            return null;
        }
        for (Organization org : list) {
            if (org == null || !organizationId.equals(org.organizationId)) continue;
            return org;
        }
        return null;
    }
}

