/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift.cache;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.sat.database.mappers.DbOsVirt;
import org.openslx.bwlp.sat.thrift.cache.CacheBase;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class VirtualizerList
extends CacheBase<List<Virtualizer>> {
    private static final Logger LOGGER = LogManager.getLogger(VirtualizerList.class);
    private static final VirtualizerList instance = new VirtualizerList();

    public static List<Virtualizer> get() {
        return (List)instance.getInternal();
    }

    @Override
    protected List<Virtualizer> getCallback() throws TException {
        List<Virtualizer> list;
        try {
            list = ThriftManager.getMasterClient().getVirtualizers();
        }
        catch (Exception e1) {
            LOGGER.warn("Could not fetch Virtualizer list from master, using local data...", (Throwable)(e1 instanceof TTransportException ? null : e1));
            try {
                return DbOsVirt.getVirtualizerList();
            }
            catch (Exception e) {
                LOGGER.warn("Using local Virtualizer list from database also failed.", (Throwable)e);
                return null;
            }
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try {
                    DbOsVirt.storeVirtualizerList(list);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });
        return list;
    }
}

