/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import java.util.HashMap;
import java.util.Map;

public class BashVars {
    private final Map<String, String> vars = new HashMap<String, String>();

    public void addVar(String variable, String value) {
        this.vars.put(variable, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> kvp : this.vars.entrySet()) {
            sb.append(kvp.getKey());
            sb.append('=');
            sb.append(this.escape(kvp.getValue()));
            sb.append('\n');
        }
        return sb.toString();
    }

    private String escape(String value) {
        boolean hasAp = value.contains("'");
        if (hasAp && !value.contains("!!") && !value.contains("$")) {
            if (value.contains("\"")) {
                return '\"' + value.replace("\"", "\\\"") + '\"';
            }
            return '\"' + value + '\"';
        }
        if (hasAp) {
            return "'" + value.replace("'", "'\\''") + "'";
        }
        return "'" + value + "'";
    }
}

