/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openslx.util.Util;

public class Configuration {
    private static final Logger LOGGER = LogManager.getLogger(Configuration.class);
    private static final DateTimeFormatter subdirDate = DateTimeFormat.forPattern("yy-MM");
    private static final String DEFAULT_WEBSERVER_BIND_ADDRESS_LOCAL = "127.0.0.1";
    private static File vmStoreBasePath;
    private static File vmStoreProdPath;
    private static String dbUri;
    private static String dbUsername;
    private static String dbPassword;
    private static String masterAddress;
    private static boolean masterSsl;
    private static int masterPort;
    private static boolean webServerBindLocalhost;
    private static String dbLocationTable;
    private static SSLContext ctx;

    public static boolean load() throws IOException {
        Properties prop = new Properties();
        try (FileInputStream in = new FileInputStream("./config.properties");){
            prop.load(in);
        }
        vmStoreBasePath = new File(prop.getProperty("vmstore.path"));
        vmStoreProdPath = new File(vmStoreBasePath, "bwlehrpool_store");
        dbUri = prop.getProperty("db.uri");
        dbUsername = prop.getProperty("db.username");
        dbPassword = prop.getProperty("db.password");
        dbLocationTable = prop.getProperty("db.location-table");
        masterAddress = prop.getProperty("master.address");
        if (!Util.isEmptyString(prop.getProperty("master.ssl"))) {
            masterSsl = Boolean.parseBoolean(prop.getProperty("master.ssl"));
        }
        try {
            masterPort = Integer.parseInt(prop.getProperty("master.port"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Util.isEmptyString(prop.getProperty("webserver.bindLocalhost"))) {
            webServerBindLocalhost = Boolean.parseBoolean(prop.getProperty("webserver.bindLocalhost"));
        }
        return vmStoreBasePath != null && dbUri != null && dbUsername != null && dbPassword != null;
    }

    public static File getVmStoreBasePath() {
        return vmStoreBasePath;
    }

    public static String getDbUri() {
        return dbUri;
    }

    public static String getDbUsername() {
        return dbUsername;
    }

    public static String getDbPassword() {
        return dbPassword;
    }

    public static String getDbLocationTable() {
        return dbLocationTable;
    }

    public static File getVmStoreProdPath() {
        return vmStoreProdPath;
    }

    public static String getMasterServerAddress() {
        return masterAddress;
    }

    public static boolean getMasterServerSsl() {
        return masterSsl;
    }

    public static int getMasterServerPort() {
        return masterPort;
    }

    public static boolean getWebServerBindLocalhost() {
        return webServerBindLocalhost;
    }

    public static String getWebServerBindAddressLocal() {
        if (Configuration.getWebServerBindLocalhost()) {
            return DEFAULT_WEBSERVER_BIND_ADDRESS_LOCAL;
        }
        return null;
    }

    public static File getCurrentVmStorePath() {
        return new File(vmStoreProdPath, subdirDate.print(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext getMasterServerSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        if (!Configuration.getMasterServerSsl()) {
            throw new RuntimeException("SSL not activated");
        }
        if (ctx == null) {
            Logger logger = LOGGER;
            synchronized (logger) {
                if (ctx == null) {
                    ctx = SSLContext.getInstance("TLSv1.2");
                    ctx.init(null, null, null);
                }
            }
        }
        return ctx;
    }

    static {
        masterSsl = true;
        masterPort = 9091;
        webServerBindLocalhost = true;
        ctx = null;
    }
}

