/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Constants {
    private static final Logger LOGGER;
    public static final String INCOMPLETE_UPLOAD_SUFFIX = ".upload.partial";
    public static final int MAX_UPLOADS;
    public static final int MAX_UPLOADS_PER_USER;
    public static final int MAX_DOWNLOADS;
    public static final int MAX_CONNECTIONS_PER_TRANSFER;
    public static final int MAX_MASTER_UPLOADS = 2;
    public static final int MAX_MASTER_DOWNLOADS = 3;
    public static final int TRANSFER_TIMEOUT = 15000;
    public static final int HASHCHECK_QUEUE_LEN;

    static {
        int maxUploads;
        LOGGER = LogManager.getLogger(Constants.class);
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem == Long.MAX_VALUE) {
            try (BufferedReader br2 = new BufferedReader(new FileReader("/proc/meminfo"));){
                String line;
                while ((line = br2.readLine()) != null) {
                    if (!line.startsWith("MemTotal:") || !line.endsWith("kB")) continue;
                    String string = line.replaceAll("[^0-9]", "");
                    try {
                        maxMem = Long.parseLong(string) / 2L * 1024L;
                        LOGGER.debug("Guessing usable JVM memory via /proc/meminfo");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
            }
            catch (IOException br2) {
                // empty catch block
            }
            if (maxMem == Long.MAX_VALUE) {
                maxMem = 0x20000000L;
            }
        }
        LOGGER.debug("Maximum JVM memory: " + (maxMem /= 0x100000L) + "MiB");
        int cpuCount = Runtime.getRuntime().availableProcessors();
        int hashQueueLen = (int)(maxMem / 100L);
        if (hashQueueLen < 1) {
            hashQueueLen = 1;
        } else if (hashQueueLen > 6) {
            hashQueueLen = 6;
        }
        int maxPerTransfer = (int)Math.max(1L, (maxMem - 400L) / 128L);
        if (maxPerTransfer > 4) {
            maxPerTransfer = 4;
        }
        if (maxPerTransfer > cpuCount) {
            maxPerTransfer = cpuCount;
        }
        if ((maxUploads = (int)Math.max(1L, (maxMem - 64L) / (long)(16 * (hashQueueLen + 1)))) > cpuCount * 4) {
            maxUploads = cpuCount * 4;
        }
        MAX_CONNECTIONS_PER_TRANSFER = maxPerTransfer;
        MAX_UPLOADS = maxUploads;
        MAX_DOWNLOADS = MAX_UPLOADS * 2;
        MAX_UPLOADS_PER_USER = Math.min(MAX_UPLOADS / 2, 4);
        HASHCHECK_QUEUE_LEN = hashQueueLen;
    }
}

