/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.util.QuickTimer;

public class FileSystem {
    private static final Logger LOGGER = LogManager.getLogger(FileSystem.class);
    private static Object storageMutex = new Object();
    private static long lastStorageFailLog = 0L;

    public static String getRelativePath(File absolutePath, File parentDir) {
        String dir;
        String file;
        try {
            file = absolutePath.getCanonicalPath();
            dir = parentDir.getCanonicalPath() + File.separator;
        }
        catch (Exception e) {
            LOGGER.error("Could not get relative path for " + absolutePath.toString(), (Throwable)e);
            return null;
        }
        if (!file.startsWith(dir)) {
            return null;
        }
        return file.substring(dir.length());
    }

    public static void deleteAsync(final File ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                for (File file : files) {
                    if (file == null || !file.exists() || file.delete()) continue;
                    LOGGER.warn("Could not delete file " + file.getAbsolutePath());
                }
            }
        });
    }

    public static boolean isStorageMounted() {
        File flagFile = new File(Configuration.getVmStoreBasePath(), ".notmounted");
        if (flagFile.exists()) {
            return false;
        }
        File prodPath = Configuration.getVmStoreProdPath();
        if (prodPath.isDirectory()) {
            return true;
        }
        return prodPath.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForStorage() {
        if (FileSystem.isStorageMounted()) {
            return true;
        }
        Object object = storageMutex;
        synchronized (object) {
            if (FileSystem.isStorageMounted()) {
                return true;
            }
            LOGGER.warn("VM storage gone, waiting for it to reappear...");
            long lastComplain = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while waiting", (Throwable)e);
                    return false;
                }
                if (System.currentTimeMillis() - lastComplain <= 600000L) continue;
                lastComplain = System.currentTimeMillis();
                LOGGER.warn("Still waiting for storage...");
            } while (!FileSystem.isStorageMounted());
        }
        LOGGER.info("VM storage back online");
        return true;
    }

    public static void deleteImageRelatedFiles(LocalImageVersion image) {
        File imageFile = FileSystem.composeAbsoluteImagePath(image);
        if (imageFile == null) {
            return;
        }
        File metaFile = new File(imageFile.getPath() + ".meta");
        File crcFile = new File(imageFile.getPath() + ".crc");
        File mapFile = new File(imageFile.getPath() + ".map");
        if (!FileSystem.waitForStorage()) {
            return;
        }
        FileSystem.deleteAsync(imageFile, metaFile, crcFile, mapFile);
    }

    public static File composeAbsoluteImagePath(LocalImageVersion localImageData) {
        if (localImageData == null) {
            return null;
        }
        File path = FileSystem.composeAbsolutePath(localImageData.filePath);
        if (path == null) {
            LOGGER.warn("ImageVersionId is " + localImageData.imageVersionId);
        }
        return path;
    }

    public static File composeAbsolutePath(String relativePath) {
        if (relativePath != null) {
            relativePath = FilenameUtils.normalize(relativePath);
        }
        if (relativePath == null || relativePath.startsWith("/")) {
            LOGGER.warn("Invalid path for local image: " + relativePath);
            return null;
        }
        return new File(Configuration.getVmStoreBasePath(), relativePath);
    }

    public static long getAvailableStorageBytes() {
        if (!FileSystem.isStorageMounted()) {
            return -1L;
        }
        try {
            return Configuration.getVmStoreProdPath().getUsableSpace();
        }
        catch (Exception e) {
            long now = System.currentTimeMillis();
            if (now - lastStorageFailLog > 60000L) {
                lastStorageFailLog = now;
                LOGGER.warn("Could not determine free space of vmstore", (Throwable)e);
            }
            return -1L;
        }
    }
}

