/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import java.io.File;
import java.text.Normalizer;
import java.util.UUID;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.thrift.iface.UserInfo;

public class Formatter {
    private static final DateTimeFormatter vmNameDateFormat = DateTimeFormat.forPattern("dd_HH-mm-ss");
    private static final DateTimeFormatter displayDateFormat = DateTimeFormat.forPattern("dd.MM.yy HH:mm");

    public static File getTempImageName() {
        return new File(Configuration.getCurrentVmStorePath(), UUID.randomUUID().toString() + ".upload.partial");
    }

    public static File getTempImageName(String s) {
        return new File(Configuration.getCurrentVmStorePath(), s + ".upload.partial");
    }

    public static String vmName(long tsMillis, UserInfo user, String imageName, String ext) {
        return Formatter.cleanFileName(vmNameDateFormat.print(tsMillis) + "_" + user.lastName + "_" + imageName + "." + ext).toLowerCase();
    }

    public static String cleanFileName(String name) {
        if (name == null) {
            return "null";
        }
        name = Normalizer.normalize(name, Normalizer.Form.NFD);
        if ((name = name.replaceAll("[^a-zA-Z0-9_\\.\\-]+", "_")).length() > 120) {
            name = name.substring(0, 120);
        }
        return name;
    }

    public static String userFullName(UserInfo ui) {
        if (ui == null) {
            return "null";
        }
        return ui.firstName + " " + ui.lastName;
    }

    public static String date(long unixTime) {
        if (unixTime == 0L) {
            return "???";
        }
        return displayDateFormat.print(unixTime * 1000L);
    }
}

