/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.util;

import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.thrift.iface.DateParamError;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.LectureWrite;
import org.openslx.bwlp.thrift.iface.TInvalidDateParam;

public class Sanitizer {
    private static final long ONE_DAY = 86400L;
    private static final long LOWER_CUTOFF = 15552000L;
    private static final long MAX_IMAGE_EXPIRY = 315360000L;

    public static void handleLectureDates(LectureWrite newLecture, LectureSummary oldLecture) throws TInvalidDateParam {
        if (newLecture.startTime > newLecture.endTime) {
            throw new TInvalidDateParam(DateParamError.NEGATIVE_RANGE, "Start date past end date");
        }
        long now = System.currentTimeMillis() / 1000L;
        long lowLimit = now - 15552000L;
        long highLimit = now + RuntimeConfig.getMaxLectureValiditySeconds();
        if (oldLecture == null || newLecture.startTime != oldLecture.startTime) {
            if (newLecture.startTime < lowLimit) {
                throw new TInvalidDateParam(DateParamError.TOO_LOW, "Start date lies in the past");
            }
            if (newLecture.startTime > highLimit) {
                throw new TInvalidDateParam(DateParamError.TOO_HIGH, "Start date lies too far in the future");
            }
        }
        if (oldLecture == null || newLecture.endTime != oldLecture.endTime) {
            if (newLecture.endTime < lowLimit) {
                throw new TInvalidDateParam(DateParamError.TOO_LOW, "End date lies in the past");
            }
            if (newLecture.endTime > highLimit) {
                if (newLecture.endTime - 86400L > highLimit) {
                    throw new TInvalidDateParam(DateParamError.TOO_HIGH, "End date lies too far in the future");
                }
                newLecture.endTime = highLimit;
            }
        }
    }

    public static void handleImageExpiryDate(long unixTimestamp) throws TInvalidDateParam {
        long now = System.currentTimeMillis() / 1000L;
        long lowLimit = now - 15552000L;
        if (unixTimestamp < lowLimit) {
            throw new TInvalidDateParam(DateParamError.TOO_LOW, "Expiry date lies in the past");
        }
        long highLimit = now + 315360000L;
        if (unixTimestamp > highLimit) {
            throw new TInvalidDateParam(DateParamError.TOO_HIGH, "Expiry date lies too far in the future");
        }
    }

    public static LecturePermissions handleLecturePermissions(LecturePermissions perms) {
        if (perms == null) {
            return new LecturePermissions();
        }
        if (perms.admin && !perms.edit) {
            perms = new LecturePermissions(perms);
            perms.edit = true;
        }
        return perms;
    }

    public static ImagePermissions handleImagePermissions(ImagePermissions perms) {
        if (perms == null) {
            return new ImagePermissions();
        }
        if (!(!perms.admin || perms.edit && perms.download && perms.link)) {
            perms = new ImagePermissions(perms);
            perms.edit = true;
            perms.download = true;
            perms.link = true;
        } else if (perms.edit && !perms.download) {
            perms = new ImagePermissions(perms);
            perms.download = true;
        }
        return perms;
    }
}

