/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.web;

import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbConfiguration;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.mail.MailTemplate;
import org.openslx.bwlp.sat.mail.MailTemplatePlain;
import org.openslx.bwlp.sat.mail.SmtpMailer;
import org.openslx.bwlp.sat.maintenance.DeleteOldImages;
import org.openslx.bwlp.sat.maintenance.ImageValidCheck;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.sat.web.WebServer;
import org.openslx.util.Json;
import org.openslx.util.Util;

public class WebRpc {
    private static final Logger LOGGER = LogManager.getLogger(WebRpc.class);

    public static NanoHTTPD.Response handle(String uri, Map<String, String> params) {
        if (uri.equals("mailtest")) {
            return WebRpc.mailTest(params);
        }
        if (uri.equals("delete-images")) {
            return WebRpc.deleteImages();
        }
        if (uri.equals("start-image-check")) {
            return WebRpc.checkImage(params);
        }
        if (uri.equals("query-image-check")) {
            return WebRpc.queryImageCheck(params);
        }
        if (uri.equals("reset-mail-templates")) {
            return WebRpc.resetMailTemplates();
        }
        if (uri.equals("scan-orphaned-files")) {
            return WebRpc.scanForOrphanedFiles(params);
        }
        return WebServer.notFound();
    }

    private static NanoHTTPD.Response resetMailTemplates() {
        DbConfiguration.updateMailTemplates(true);
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", "OK");
    }

    private static NanoHTTPD.Response scanForOrphanedFiles(Map<String, String> params) {
        Set<String> known;
        if (!FileSystem.isStorageMounted()) {
            return WebServer.internalServerError("VMstore not mounted");
        }
        HashMap orphanedFiles = new HashMap();
        String baseDir = Configuration.getVmStoreBasePath().toString();
        int baseLen = baseDir.length() + (baseDir.endsWith("/") ? 0 : 1);
        boolean del = params.containsKey("action") && params.get("action").equals("delete");
        try {
            known = DbImage.getAllFilenames();
        }
        catch (SQLException e1) {
            return WebServer.internalServerError("Cannot query list of known images from database");
        }
        if (known.isEmpty()) {
            return WebServer.internalServerError("SAFTY CHECK: Known image list empty, aborting");
        }
        AtomicInteger matches = new AtomicInteger();
        try {
            long minBirthTime = System.currentTimeMillis() - 172800L;
            Files.find(Configuration.getVmStoreProdPath().toPath(), 8, (filePath, fileAttr) -> fileAttr.isRegularFile() && fileAttr.creationTime().toMillis() < minBirthTime, new FileVisitOption[0]).forEach(fileName -> WebRpc.checkFile(fileName, orphanedFiles, baseLen, known, matches));
        }
        catch (Exception e) {
            return WebServer.internalServerError(e.toString());
        }
        if (del) {
            for (Map.Entry entry : orphanedFiles.entrySet()) {
                if (matches.get() == 0) {
                    entry.setValue(DeleteResult.SAFETY_ABORT);
                    continue;
                }
                Path filePath2 = Paths.get(baseDir + "/" + (String)entry.getKey(), new String[0]);
                try {
                    Files.delete(filePath2);
                    entry.setValue(DeleteResult.DELETED);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot delete " + filePath2, (Throwable)e);
                    entry.setValue(DeleteResult.ERROR);
                }
            }
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", Json.serialize(orphanedFiles));
    }

    private static void checkFile(Path filePath, Map<String, DeleteResult> result, int baseLen, Set<String> known, AtomicInteger matches) {
        String relativeFileName;
        if (filePath.endsWith("dozmod.lock")) {
            return;
        }
        try {
            relativeFileName = filePath.toAbsolutePath().toString().substring(baseLen);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.warn("Cannot make image path relative", (Throwable)e);
            return;
        }
        String compareFileName = relativeFileName.endsWith(".crc") || relativeFileName.endsWith(".map") ? relativeFileName.substring(0, relativeFileName.length() - 4) : (relativeFileName.endsWith(".meta") ? relativeFileName.substring(0, relativeFileName.length() - 5) : relativeFileName);
        if (known.contains(compareFileName)) {
            matches.incrementAndGet();
        } else {
            result.put(relativeFileName, DeleteResult.EXISTS);
        }
    }

    private static NanoHTTPD.Response checkImage(Map<String, String> params) {
        String versionId = params.get("versionid");
        if (versionId == null) {
            return WebServer.badRequest("Missing versionid param");
        }
        versionId = versionId.toLowerCase();
        boolean checkHashes = Boolean.valueOf(params.get("hash"));
        boolean updateState = Boolean.valueOf(params.get("update"));
        ImageValidCheck.SubmitResult res = ImageValidCheck.check(versionId, checkHashes, updateState);
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", res.name());
    }

    private static NanoHTTPD.Response queryImageCheck(Map<String, String> params) {
        Map<String, ImageValidCheck.CheckResult> result;
        String versionId = params.get("versionid");
        if (versionId == null) {
            result = ImageValidCheck.getAll();
        } else {
            versionId = versionId.toLowerCase();
            ImageValidCheck.CheckResult res = ImageValidCheck.getStatus(versionId);
            result = new HashMap<String, ImageValidCheck.CheckResult>();
            result.put(versionId, res);
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", Json.serialize(result));
    }

    private static NanoHTTPD.Response deleteImages() {
        StringBuilder res = DeleteOldImages.hardDeleteImages();
        if (res == null) {
            return WebServer.internalServerError();
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", res.toString());
    }

    private static NanoHTTPD.Response mailTest(Map<String, String> params) {
        SmtpMailer smtpc;
        SmtpMailer.EncryptionMode ssl;
        String recipient = params.get("recipient");
        String host = params.get("host");
        String senderAddress = params.get("senderAddress");
        String serverName = params.get("serverName");
        String replyTo = params.get("replyTo");
        String username = params.get("username");
        String password = params.get("password");
        int port = Util.parseInt(params.get("port"), 0);
        try {
            ssl = SmtpMailer.EncryptionMode.valueOf(params.get("ssl"));
        }
        catch (Exception e) {
            return WebServer.badRequest("Invalid SSL mode '" + params.get("ssl") + "'");
        }
        if (port < 1 || port > 65535) {
            return WebServer.badRequest("Invalid port");
        }
        if (recipient == null) {
            return WebServer.badRequest("Missing recipient");
        }
        if (host == null) {
            return WebServer.badRequest("Missing host");
        }
        if (senderAddress == null) {
            return WebServer.badRequest("Missing senderAddress");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            smtpc = new SmtpMailer(host, port, ssl, senderAddress, serverName, replyTo, username, password, new PrintStream(baos));
        }
        catch (Exception e) {
            try {
                baos.write("Could not connect to mail server".getBytes(StandardCharsets.UTF_8));
                e.printStackTrace(new PrintWriter(baos));
            }
            catch (Exception exception) {
                // empty catch block
            }
            smtpc = null;
        }
        boolean ret = false;
        if (smtpc != null) {
            MailTemplate template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.TEST_MAIL);
            HashMap<String, String> templateArgs = new HashMap<String, String>();
            templateArgs.put("host", host);
            templateArgs.put("port", String.valueOf(port));
            templateArgs.put("ssl", ssl.toString());
            templateArgs.put("username", username);
            String msg = template.format(templateArgs);
            ret = smtpc.send(recipient, "bwLehrpool Mail Test", msg, "<sat.bwlehrpool.de>");
        }
        try {
            baos.write(("\n\n-----------------------------------------\nTestergebnis: " + (ret ? "" : "nicht ") + "erfolgreich").getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", new ByteArrayInputStream(baos.toByteArray()));
    }

    private static enum DeleteResult {
        EXISTS,
        DELETED,
        ERROR,
        SAFETY_ABORT;

    }
}

