/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.web;

import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.fileserv.FileServer;
import org.openslx.bwlp.sat.fileserv.cow.CowSession;
import org.openslx.bwlp.sat.fileserv.cow.CowSessionManager;
import org.openslx.bwlp.sat.permissions.User;
import org.openslx.bwlp.sat.thrift.SessionManager;
import org.openslx.bwlp.sat.util.BashVars;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.web.VmChooserListXml;
import org.openslx.bwlp.sat.web.WebRpc;
import org.openslx.bwlp.thrift.iface.AuthorizationError;
import org.openslx.bwlp.thrift.iface.NetRule;
import org.openslx.bwlp.thrift.iface.NetShare;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.CascadedThreadPoolExecutor;
import org.openslx.util.Json;
import org.openslx.util.TarArchiveUtil;
import org.openslx.util.Util;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

public class WebServer
extends NanoHTTPD {
    private static final Logger LOGGER = LogManager.getLogger(WebServer.class);
    private static final ThreadPoolExecutor LECTURE_START_TPE = new CascadedThreadPoolExecutor(2, 8, 1L, TimeUnit.MINUTES, 1, "tgz-gen");
    private static final Serializer serializer = new Persister();

    public WebServer(int port, ExecutorService tpe) throws IOException {
        super(Configuration.getWebServerBindAddressLocal(), port, tpe);
        this.maxRequestSize = 65535;
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String uri = session.getUri();
        if (uri == null || uri.length() == 0) {
            return WebServer.internalServerError();
        }
        if (uri.contains("//")) {
            uri = uri.replaceAll("//+", "/");
        }
        try {
            return this.handle(session, uri);
        }
        catch (Throwable t) {
            LOGGER.warn("Could not handle request", t);
            return WebServer.internalServerError();
        }
    }

    private NanoHTTPD.Response handle(NanoHTTPD.IHTTPSession session, String uri) {
        String[] parts = uri.replaceFirst("^/+", "").split("/+");
        if (parts.length < 2) {
            return WebServer.notFound();
        }
        if (parts[0].equals("vmchooser")) {
            if (parts[1].equals("list")) {
                try {
                    return this.serveVmChooserList(session.getParms());
                }
                catch (Exception e) {
                    LOGGER.debug("problem while retrieving the vmChooserList", (Throwable)e);
                    return WebServer.internalServerError();
                }
            }
            if (parts[1].equals("lecture")) {
                if (parts.length < 4) {
                    return WebServer.badRequest("Bad Request");
                }
                if (parts[3].equals("metadata")) {
                    return this.serveMetaData(parts[2], session.getParms());
                }
                if (parts[3].equals("netrules")) {
                    return this.serveLectureNetRules(parts[2]);
                }
                if (parts[3].equals("imagemeta")) {
                    return this.serveContainerImageMetaData(parts[2]);
                }
            }
            return WebServer.notFound();
        }
        if (parts[0].equals("cow")) {
            if (parts.length < 3) {
                return WebServer.badRequest("Bad request");
            }
            if (session.getMethod() == NanoHTTPD.Method.POST) {
                try {
                    session.parseBody();
                }
                catch (NanoHTTPD.ResponseException | IOException e) {
                    LOGGER.debug("could not parse request body", (Throwable)e);
                    return WebServer.internalServerError();
                }
            }
            if (parts[1].equals("v1") && parts[2].equals("file")) {
                if (parts.length < 4) {
                    return WebServer.badRequest("No action");
                }
                if (parts[3].equals("merge")) {
                    return this.cowMerge(session.getParms());
                }
                if (parts[3].equals("update")) {
                    return this.cowUploadCluster(session);
                }
                return WebServer.badRequest("No such API endpoint: " + parts[3]);
            }
            if (parts[1].equals("status")) {
                return this.cowServeStatus(parts[2]);
            }
            if (parts[1].equals("finish")) {
                return this.cowFinish(parts[2]);
            }
            if (parts[1].equals("abort")) {
                return this.cowAbort(parts[2], session.getMethod());
            }
            return WebServer.badRequest("No such API endpoint");
        }
        if (uri.startsWith("/bwlp/container/clusterimages")) {
            return this.serverContainerImages();
        }
        if (uri.startsWith("/image/container/")) {
            if (parts.length < 4) {
                return WebServer.badRequest("Bad Request");
            }
            if (parts[3].equals("metadata")) {
                return this.serveContainerImageMetaData(parts[2]);
            }
        }
        if (uri.startsWith("/status/fileserver")) {
            return this.serveStatus();
        }
        if (session.getMethod() == NanoHTTPD.Method.POST && uri.startsWith("/do/")) {
            try {
                session.parseBody();
            }
            catch (NanoHTTPD.ResponseException | IOException e) {
                LOGGER.debug("could not parse request body", (Throwable)e);
                return WebServer.internalServerError();
            }
            return WebRpc.handle(uri.substring(4), session.getParms());
        }
        return WebServer.notFound();
    }

    private NanoHTTPD.Response cowUploadCluster(NanoHTTPD.IHTTPSession session) {
        byte[] data;
        if (session.getMethod() != NanoHTTPD.Method.POST && session.getMethod() != NanoHTTPD.Method.PUT) {
            return WebServer.badRequest("Not PUT or POST");
        }
        InputStream is = session.getInputStream();
        if (is == null) {
            return WebServer.internalServerError("Cannot get input stream");
        }
        String uuid = session.getParms().get("uuid");
        String sIdx = session.getParms().get("clusterindex");
        if (uuid == null || sIdx == null) {
            return WebServer.badRequest("uuid or clusterindex missing");
        }
        long clusterIndex = Util.parseLong(sIdx, -1L);
        if (clusterIndex < 0L) {
            return WebServer.badRequest("Invalid clusterindex");
        }
        CowSession cowSession = CowSessionManager.get(uuid);
        if (cowSession == null) {
            return WebServer.notFound("Invalid session ID");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(9001);){
            int n;
            byte[] b = new byte[65536];
            while ((n = is.read(b)) > 0) {
                baos.write(b, 0, n);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.warn("Cannot read cluster", (Throwable)e);
            return WebServer.internalServerError("Cannot read cluster data from http stream");
        }
        int cowRet = cowSession.addCluster(clusterIndex, data);
        if (cowRet == 0) {
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", "OK");
        }
        if (cowRet < 0) {
            return WebServer.internalServerError("Error writing received chunk to disk");
        }
        NanoHTTPD.Response reply = new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.SERVICE_UNAVAILABLE, "text/plain; charset=utf-8", "Slow down!");
        reply.addHeader("Retry-After", Integer.toString(cowRet));
        return reply;
    }

    private NanoHTTPD.Response cowMerge(Map<String, String> parms) {
        String uuid = parms.get("uuid");
        String newSz = parms.get("newFileSize");
        if (uuid == null || newSz == null) {
            return WebServer.badRequest("uuid or newFileSize missing");
        }
        CowSession session = CowSessionManager.get(uuid);
        if (session == null) {
            return WebServer.notFound("Invalid session ID");
        }
        long finalSize = Util.parseLong(newSz, -1L);
        long limit = RuntimeConfig.getVmSizeLimit() * 12L / 10L;
        if (limit <= 0L) {
            limit = 300000000000L;
        }
        if (finalSize < 0L || finalSize > limit) {
            return WebServer.badRequest("Illegal final file size");
        }
        try {
            session.uploadFinished(finalSize);
        }
        catch (Exception e) {
            return WebServer.badRequest("Cannot finish upload: " + e.getMessage());
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", "OK");
    }

    private NanoHTTPD.Response cowFinish(String sessionId) {
        CowSession session = CowSessionManager.get(sessionId);
        if (session == null) {
            return WebServer.notFound("Invalid session ID");
        }
        try {
            session.requestFinalization();
        }
        catch (Exception e) {
            return WebServer.badRequest("Cannot finalize image version: " + e.getMessage());
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", "OK");
    }

    private NanoHTTPD.Response cowAbort(String sessionId, NanoHTTPD.Method method) {
        if (method != NanoHTTPD.Method.POST) {
            return WebServer.badRequest("Need abort request as POST");
        }
        CowSession session = CowSessionManager.get(sessionId);
        if (session == null) {
            return WebServer.notFound("Invalid session ID");
        }
        session.abort();
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", "OK");
    }

    private NanoHTTPD.Response cowServeStatus(String sessionId) {
        CowSession session = CowSessionManager.get(sessionId);
        if (session == null) {
            return WebServer.notFound("Invalid session ID");
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", session.getStatusJson());
    }

    private NanoHTTPD.Response serveStatus() {
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", Json.serialize(FileServer.instance().getStatus()));
    }

    private NanoHTTPD.Response serveMetaData(String lectureId, Map<String, String> parms) {
        PipedInputStream sink = new PipedInputStream(10000);
        try {
            DbLecture.LaunchData ld;
            final BashVars vars = new BashVars();
            final TarArchiveUtil.TarArchiveWriter tarArchiveWriter = new TarArchiveUtil.TarArchiveWriter(new PipedOutputStream(sink));
            try {
                ld = DbLecture.getClientLaunchData(lectureId);
            }
            catch (TNotFoundException e) {
                return WebServer.notFound();
            }
            catch (SQLException e) {
                return WebServer.internalServerError();
            }
            vars.addVar("DMSD_IMAGE_PATH", ld.imagePath);
            try {
                String sessionType = parms.get("cow-type");
                String cowUserId = parms.get("cow-user");
                if (cowUserId != null) {
                    String cowSession = CowSessionManager.create(cowUserId, ld, sessionType);
                    vars.addVar("DMSD_COW_SESSION", cowSession);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error creating cow session for " + ld.imageBaseId + ", " + ld.imagePath, (Throwable)e);
                return WebServer.internalServerError("Cannot create COW session: " + e.getMessage());
            }
            LECTURE_START_TPE.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: {
                        try {
                            tarArchiveWriter.writeFile("vmx", ld.configuration);
                            tarArchiveWriter.writeFile("config.inc", vars.toString());
                            tarArchiveWriter.writeFile("runscript", ld.legacyRunScript);
                            tarArchiveWriter.writeFile("netshares", WebServer.this.serializeNetShares(ld.netShares));
                            if (ld.runScript == null) break block5;
                            int cnt = 0;
                            for (DbLecture.RunScript rs : ld.runScript) {
                                tarArchiveWriter.writeFile(String.format("adminrun/%04d-%d-%d.%s", cnt++, rs.visibility, rs.passCreds ? 1 : 0, rs.extension), rs.content);
                            }
                        }
                        catch (IOException e) {
                            try {
                                LOGGER.warn("Error writing to tar stream", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                Util.safeClose(tarArchiveWriter);
                                throw throwable;
                            }
                            Util.safeClose(tarArchiveWriter);
                        }
                    }
                    Util.safeClose(tarArchiveWriter);
                }
            });
        }
        catch (IOException e1) {
            LOGGER.warn("Could not create tar output stream", (Throwable)e1);
            return WebServer.internalServerError();
        }
        catch (RejectedExecutionException e2) {
            LOGGER.warn("Server overloaded; rejecting VM Metadata request", (Throwable)e2);
            return WebServer.internalServerError();
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/gzip", sink);
    }

    private NanoHTTPD.Response serveLectureNetRules(String lectureId) {
        boolean defaultAllowed;
        ArrayList<NetRule> list = new ArrayList<NetRule>();
        try {
            defaultAllowed = DbLecture.getFirewallRules(lectureId, list);
        }
        catch (SQLException e) {
            return WebServer.internalServerError();
        }
        catch (TNotFoundException e) {
            return WebServer.notFound();
        }
        StringBuilder sb = new StringBuilder();
        for (NetRule rule : list) {
            sb.append(rule.direction.name());
            sb.append(' ');
            sb.append(rule.host);
            sb.append(' ');
            sb.append(rule.port);
            sb.append(' ');
            sb.append(defaultAllowed ? "REJECT" : "ACCEPT");
            sb.append('\n');
        }
        if (defaultAllowed) {
            sb.append("IN * 0 ACCEPT\n");
            sb.append("OUT * 0 ACCEPT\n");
        } else {
            sb.append("IN * 0 REJECT\n");
            sb.append("OUT * 0 REJECT\n");
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/plain; charset=utf-8", sb.toString());
    }

    private String serializeNetShares(List<NetShare> list) {
        StringBuilder sb = new StringBuilder();
        if (!list.isEmpty()) {
            for (NetShare share : list) {
                sb.append(share.path);
                sb.append('\t');
                sb.append(share.mountpoint);
                sb.append('\t');
                sb.append(share.displayname);
                if (share.auth == NetShareAuth.LOGIN_USER) {
                    // empty if block
                }
                if (share.auth == NetShareAuth.OTHER_USER && share.isSetUsername()) {
                    sb.append('\t');
                    sb.append(share.username);
                    if (share.isSetPassword()) {
                        sb.append('\t');
                        sb.append(share.password);
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private NanoHTTPD.Response serveVmChooserList(Map<String, String> params) throws Exception {
        String locations = params.get("locations");
        String userToken = params.get("cow-user");
        boolean exams = params.containsKey("exams");
        String addUserError = null;
        UserInfo user = null;
        if (!Util.isEmptyString(userToken)) {
            user = SessionManager.get(userToken);
            if (user == null || user.userId == null) {
                addUserError = "Invalid session token, edit mode not available\nUng\u00fcltiges Sitzungstoken, Editiermodus nicht verf\u00fcgbar";
            } else {
                AuthorizationError err = User.canLogin(user);
                if (err != null) {
                    user = null;
                    addUserError = "You are not allowed to edit VMs\nSie haben keine Berechtigung, um VMs zu bearbeiten.";
                }
            }
        }
        VmChooserListXml listXml = DbLecture.getUsableListXml(exams, locations, user);
        if (addUserError != null) {
            listXml.setError(addUserError);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.write((Object)listXml, baos);
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "text/xml; charset=utf-8", new ByteArrayInputStream(baos.toByteArray()));
    }

    public static NanoHTTPD.Response internalServerError(String body) {
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", body);
    }

    public static NanoHTTPD.Response internalServerError() {
        return WebServer.internalServerError("Internal Server Error");
    }

    public static NanoHTTPD.Response notFound() {
        return WebServer.notFound("Nicht gefunden");
    }

    private static NanoHTTPD.Response notFound(String string) {
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", string);
    }

    public static NanoHTTPD.Response badRequest(String message) {
        if (message == null) {
            message = "Schlechte Anfrage!";
        }
        return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "text/plain", message);
    }

    private NanoHTTPD.Response serverContainerImages() {
        try {
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", Json.serialize(DbImage.getContainerImageCluster()));
        }
        catch (SQLException e) {
            LOGGER.error("error -- could not server container images", (Throwable)e);
            return WebServer.internalServerError();
        }
    }

    private NanoHTTPD.Response serveContainerImageMetaData(String imageBaseId) {
        try {
            return new NanoHTTPD.Response((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, "application/json; charset=utf-8", DbImage.getContainerImageMetadata(imageBaseId));
        }
        catch (SQLException e) {
            LOGGER.error("error -- could not server container image", (Throwable)e);
            return WebServer.internalServerError();
        }
    }
}

