/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.DataReceivedCallback;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.Transfer;
import org.openslx.filetransfer.WantRangeCallback;

public class Downloader
extends Transfer {
    private static final Logger log = LogManager.getLogger(Downloader.class);
    private final LZ4FastDecompressor decompressor = lz4factory.fastDecompressor();
    private final Lz4InStream compressedIn = new Lz4InStream(this.dataFromServer);

    public Downloader(String host, int port, int readTimeoutMs, SSLContext context, String token) throws IOException {
        super(host, port, readTimeoutMs, context, log);
        this.outStream.writeByte(68);
        if (!this.sendToken(token) || !this.sendEndOfMeta()) {
            throw new IOException("Sending token failed");
        }
    }

    protected Downloader(Socket socket) throws IOException {
        super(socket, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(final String destinationFile, WantRangeCallback callback) {
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(new File(destinationFile), "rw");
            }
            catch (FileNotFoundException e2) {
                log.error("Cannot open " + destinationFile + " for writing.");
                boolean bl = false;
                Transfer.safeClose(file);
                return bl;
            }
        }
        catch (Throwable throwable) {
            Transfer.safeClose(file);
            throw throwable;
        }
        final RandomAccessFile f = file;
        DataReceivedCallback cb = new DataReceivedCallback(){

            @Override
            public boolean dataReceived(long fileOffset, int dataLength, byte[] data) {
                try {
                    f.seek(fileOffset);
                    f.write(data, 0, dataLength);
                }
                catch (Exception e) {
                    log.error("Could not write to file " + destinationFile + " at offset " + fileOffset, (Throwable)e);
                    return false;
                }
                return true;
            }
        };
        boolean bl = this.download(cb, callback);
        Transfer.safeClose(file);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(DataReceivedCallback dataCallback, WantRangeCallback rangeCallback) {
        if (this.shouldGetToken()) {
            log.error("You didn't call getToken yet!");
            return false;
        }
        try {
            FileRange requestedRange;
            byte[] incoming = new byte[500000];
            while ((requestedRange = rangeCallback.get()) != null) {
                int ret;
                if (requestedRange.startOffset < 0L || requestedRange.startOffset >= requestedRange.endOffset) {
                    log.error("Callback supplied bad range (" + requestedRange.startOffset + " to " + requestedRange.endOffset + ")");
                    boolean bl = false;
                    return bl;
                }
                if (this.useCompression) {
                    this.sendUseCompression();
                }
                if (!this.sendRange(requestedRange.startOffset, requestedRange.endOffset) || !this.sendEndOfMeta()) {
                    log.error("Could not send next range request, download failed.");
                    boolean bl = false;
                    return bl;
                }
                Transfer.MetaData meta = this.readMetaData();
                if (meta == null) {
                    log.error("Did not receive meta data from uploading remote peer after requesting range, aborting.");
                    boolean bl = false;
                    return bl;
                }
                if (this.getRemoteError() != null) {
                    log.error("Remote peer sent error: " + this.getRemoteError());
                    boolean bl = false;
                    return bl;
                }
                FileRange remoteRange = meta.getRange();
                if (remoteRange == null) {
                    log.error("Remote metadata does not contain range confirmation. " + meta);
                }
                if (!remoteRange.equals(requestedRange)) {
                    log.error("Confirmed range by remote peer (" + remoteRange + ") does not match requested range (" + requestedRange + "), aborting download.");
                    boolean bl = false;
                    return bl;
                }
                int chunkLength = requestedRange.getLength();
                InputStream inStream = meta.peerWantsCompression() ? this.compressedIn : this.dataFromServer;
                for (int hasRead = 0; hasRead < chunkLength; hasRead += ret) {
                    try {
                        ret = inStream.read(incoming, 0, Math.min(chunkLength - hasRead, incoming.length));
                        if (Thread.currentThread().isInterrupted()) {
                            log.debug("Thread interrupted in download loop");
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (IOException e) {
                        log.error("Could not read payload from socket", (Throwable)e);
                        this.sendErrorCode("payload read error");
                        boolean bl = false;
                        return bl;
                    }
                    if (ret == -1) {
                        log.info("Remote peer unexpectedly closed the connection.");
                        boolean bl = false;
                        return bl;
                    }
                    if (dataCallback.dataReceived(requestedRange.startOffset + (long)hasRead, ret, incoming)) continue;
                    this.close("Aborting due to I/O error...");
                    boolean bl = false;
                    return bl;
                }
            }
            this.sendDone();
            this.sendEndOfMeta();
            this.compressedIn.printStats();
            try {
                this.transferSocket.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.close(null);
        }
        return true;
    }

    private class Lz4InStream
    extends InputStream {
        private final DataInputStream parentStream;
        private long compressed;
        private long uncompressed;
        private byte[] buffer;

        public Lz4InStream(DataInputStream in) {
            this.parentStream = in;
            log.debug("DeCompressor: " + Downloader.this.decompressor.getClass().getSimpleName());
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int decompressedLength = this.parentStream.readInt();
                int compressedLength = this.parentStream.readInt();
                this.compressed += (long)compressedLength;
                this.uncompressed += (long)decompressedLength;
                if (decompressedLength > len) {
                    throw new RuntimeException("This should never happen! ;)");
                }
                if (decompressedLength == compressedLength) {
                    this.parentStream.readFully(b, off, decompressedLength);
                } else {
                    if (this.buffer == null || this.buffer.length < compressedLength) {
                        this.buffer = new byte[compressedLength];
                    }
                    this.parentStream.readFully(this.buffer, 0, compressedLength);
                    Downloader.this.decompressor.decompress(this.buffer, 0, b, off, decompressedLength);
                }
                return decompressedLength;
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Cant do this!");
        }

        public void printStats() {
            if (this.compressed == 0L) {
                return;
            }
            log.info("Received bytes: " + this.compressed + ", decompressed bytes: " + this.uncompressed);
        }
    }
}

