/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import net.jpountz.lz4.LZ4Compressor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.Transfer;
import org.openslx.filetransfer.UploadStatusCallback;

public class Uploader
extends Transfer {
    private static final Logger log = LogManager.getLogger(Uploader.class);
    private final LZ4Compressor compressor = lz4factory.fastCompressor();
    private final Lz4OutStream compressedOut = new Lz4OutStream(this.outStream);

    public Uploader(String host, int port, int readTimeoutMs, SSLContext context, String token) throws IOException {
        super(host, port, readTimeoutMs, context, log);
        this.outStream.writeByte(85);
        if (!this.sendToken(token) || !this.sendEndOfMeta()) {
            throw new IOException("Sending token failed");
        }
    }

    public Uploader(Socket socket) throws IOException {
        super(socket, log);
    }

    public boolean upload(String filename) {
        return this.upload(filename, null);
    }

    /*
     * Exception decompiling
     */
    public boolean upload(String filename, UploadStatusCallback callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 22[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class Lz4OutStream
    extends OutputStream {
        private final DataOutputStream parentStream;
        private byte[] buffer;
        private long bytesSentTotal;
        private long bytesDecompressedTotal;
        private int chunksCompressed;
        private int chunksUncompressed;

        public Lz4OutStream(DataOutputStream out) {
            this.parentStream = out;
            log.debug("Compressor: " + Uploader.this.compressor.getClass().getSimpleName());
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("Cannot do this");
        }

        @Override
        public void write(byte[] data, int off, int decompressedLength) throws IOException {
            int maxCompressedLength = Uploader.this.compressor.maxCompressedLength(decompressedLength);
            if (this.buffer == null || this.buffer.length < maxCompressedLength) {
                this.buffer = new byte[maxCompressedLength];
            }
            this.bytesDecompressedTotal += (long)decompressedLength;
            int compressedLength = Uploader.this.compressor.compress(data, off, decompressedLength, this.buffer, 0, maxCompressedLength);
            this.parentStream.writeInt(decompressedLength);
            if (compressedLength * 9 / 8 < decompressedLength) {
                this.bytesSentTotal += (long)compressedLength;
                ++this.chunksCompressed;
                this.parentStream.writeInt(compressedLength);
                this.parentStream.write(this.buffer, 0, compressedLength);
            } else {
                this.bytesSentTotal += (long)decompressedLength;
                ++this.chunksUncompressed;
                this.parentStream.writeInt(decompressedLength);
                this.parentStream.write(data, off, decompressedLength);
            }
        }

        public void printStats() {
            if (this.bytesSentTotal == 0L) {
                return;
            }
            log.info("Bytes sent: " + this.bytesSentTotal + ", decompressed to: " + this.bytesDecompressedTotal);
            log.info("Chunks sent compressed: " + this.chunksCompressed + ", uncompressed: " + this.chunksUncompressed);
        }
    }
}

