/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.bwlp.thrift.iface.TransferStatus;
import org.openslx.filetransfer.DataReceivedCallback;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.LocalChunkSource;
import org.openslx.filetransfer.WantRangeCallback;
import org.openslx.filetransfer.util.AbstractTransfer;
import org.openslx.filetransfer.util.ChunkList;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.filetransfer.util.HashChecker;
import org.openslx.filetransfer.util.LocalCopyManager;
import org.openslx.util.ThriftUtil;

public abstract class IncomingTransferBase
extends AbstractTransfer
implements HashChecker.HashCheckCallback {
    private static final Logger LOGGER;
    private List<Downloader> downloads = new ArrayList<Downloader>();
    private final File tmpFileName;
    private final RandomAccessFile tmpFileHandle;
    private final ChunkList chunks;
    private TransferState state = TransferState.IDLE;
    private final long fileSize;
    private static final HashChecker hashChecker;
    protected static int MAX_CONNECTIONS_PER_TRANSFER;
    private boolean fileWritable = true;
    private final LocalChunkSource localChunkSource;
    private final LocalCopyManager localCopyManager;

    public IncomingTransferBase(String transferId, File absFilePath, long fileSize, List<byte[]> blockHashes, LocalChunkSource localChunkSource) throws FileNotFoundException {
        super(transferId);
        this.fileSize = fileSize;
        this.localChunkSource = localChunkSource;
        this.tmpFileName = absFilePath;
        this.tmpFileName.getParentFile().mkdirs();
        this.tmpFileHandle = new RandomAccessFile(absFilePath, "rw");
        try {
            if (this.tmpFileHandle.length() > fileSize) {
                this.tmpFileHandle.setLength(fileSize);
            }
        }
        catch (IOException e) {
            LOGGER.debug("File " + this.tmpFileName + " is too long and could not be truncated");
        }
        this.chunks = new ChunkList(fileSize, blockHashes);
        if (this.localChunkSource != null) {
            this.localCopyManager = new LocalCopyManager(this, this.chunks);
            this.checkLocalCopyCandidates(blockHashes, 0);
        } else {
            this.localCopyManager = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.state == TransferState.IDLE || this.state == TransferState.WORKING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancel() {
        if (this.state != TransferState.FINISHED && this.state != TransferState.ERROR) {
            this.state = TransferState.ERROR;
        }
        List<Downloader> list = this.downloads;
        synchronized (list) {
            for (Downloader download : this.downloads) {
                download.cancel();
            }
        }
        this.potentialFinishTime.set(0L);
        if (this.localCopyManager != null) {
            this.localCopyManager.interrupt();
        }
        IncomingTransferBase.safeClose(this.tmpFileHandle);
        if (this.getTransferInfo() != null && this.getTransferInfo().token != null) {
            LOGGER.debug("Cancelled upload " + this.getTransferInfo().token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getActiveConnectionCount() {
        List<Downloader> list = this.downloads;
        synchronized (list) {
            return this.downloads.size();
        }
    }

    public final boolean hashesEqual(List<ByteBuffer> blockHashes) {
        List<FileChunk> existing = this.chunks.getAll();
        if (existing.size() != blockHashes.size()) {
            return false;
        }
        List<byte[]> hashes = ThriftUtil.unwrapByteBufferList(blockHashes);
        FileChunk first = existing.get(0);
        if (first == null || first.getSha1Sum() == null) {
            return false;
        }
        Iterator<byte[]> it = hashes.iterator();
        for (FileChunk existingChunk : existing) {
            byte[] testChunk = it.next();
            if (Arrays.equals(testChunk, existingChunk.getSha1Sum())) continue;
            return false;
        }
        return true;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    public final File getTmpFileName() {
        return this.tmpFileName;
    }

    public final TransferState getState() {
        return this.state;
    }

    public synchronized TransferStatus getStatus() {
        return new TransferStatus(this.chunks.getStatusArray(), this.getState());
    }

    public final ChunkList getChunks() {
        return this.chunks;
    }

    public void updateBlockHashList(List<byte[]> hashList) {
        FileChunk chunk;
        if (this.state != TransferState.IDLE && this.state != TransferState.WORKING) {
            LOGGER.info(this.getId() + ": Rejecting block hash list in state " + this.state);
            return;
        }
        if (hashList == null) {
            LOGGER.info(this.getId() + ": Rejecting null block hash list");
            return;
        }
        int firstNew = this.chunks.updateSha1Sums(hashList);
        if (hashChecker == null) {
            return;
        }
        for (int cnt = 0; cnt < 3 && (chunk = this.chunks.getUnhashedComplete()) != null; ++cnt) {
            byte[] data = null;
            try {
                data = this.loadChunkFromFile(chunk);
            }
            catch (EOFException e1) {
                LOGGER.warn("blockhash update: file too short, marking chunk as invalid");
                this.chunks.markFailed(chunk);
                this.chunkStatusChanged(chunk);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("unexpected fail while loading chunk from disk", (Throwable)e);
            }
            if (data == null) {
                LOGGER.warn("blockhash update: Will mark unloadable unhashed chunk as valid :-(");
                this.chunks.markCompleted(chunk, true);
                this.chunkStatusChanged(chunk);
                continue;
            }
            try {
                if (hashChecker.queue(chunk, data, this, 2)) continue;
                this.chunks.markCompleted(chunk, false);
                break;
            }
            catch (InterruptedException e) {
                LOGGER.debug("updateBlockHashList got interrupted");
                this.chunks.markCompleted(chunk, false);
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.checkLocalCopyCandidates(hashList, firstNew);
    }

    private void checkLocalCopyCandidates(List<byte[]> hashList, int firstNew) {
        if (this.localChunkSource == null || hashList == null || hashList.isEmpty()) {
            return;
        }
        List<byte[]> sums = firstNew <= 0 ? hashList : hashList.subList(firstNew, hashList.size());
        if (sums == null) {
            return;
        }
        sums = Collections.unmodifiableList(sums);
        List<LocalChunkSource.ChunkSource> sources = null;
        try {
            sources = this.localChunkSource.getCloneSources(sums);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get chunk sources", (Throwable)e);
        }
        if (sources != null && !sources.isEmpty()) {
            this.chunks.markLocalCopyCandidates(sources);
        }
        if (this.state == TransferState.IDLE) {
            this.state = TransferState.WORKING;
        }
        this.localCopyManager.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadChunkFromFile(FileChunk chunk) throws EOFException {
        RandomAccessFile randomAccessFile = this.tmpFileHandle;
        synchronized (randomAccessFile) {
            if (this.state != TransferState.IDLE && this.state != TransferState.WORKING) {
                return null;
            }
            try {
                this.tmpFileHandle.seek(chunk.range.startOffset);
                byte[] buffer = new byte[chunk.range.getLength()];
                this.tmpFileHandle.readFully(buffer);
                return buffer;
            }
            catch (EOFException e) {
                throw e;
            }
            catch (IOException e) {
                LOGGER.error("Could not read chunk " + chunk.getChunkIndex() + " of File " + this.getTmpFileName().toString(), (Throwable)e);
                return null;
            }
        }
    }

    final boolean chunkReceivedInternal(FileChunk currentChunk, byte[] buffer) throws InterruptedException {
        boolean needNewBuffer = false;
        try {
            needNewBuffer = this.chunkReceived(currentChunk, buffer);
        }
        catch (Exception e) {
            LOGGER.warn("Callback chunkReceived caused exception", (Throwable)e);
            needNewBuffer = true;
        }
        InterruptedException passEx = null;
        if (hashChecker != null && currentChunk.getSha1Sum() != null) {
            try {
                hashChecker.queue(currentChunk, buffer, this, 3);
                return true;
            }
            catch (InterruptedException e) {
                passEx = e;
            }
        }
        long pre = System.currentTimeMillis();
        this.writeFileData(currentChunk.range.startOffset, currentChunk.range.getLength(), buffer);
        long duration = System.currentTimeMillis() - pre;
        if (duration > 2000L) {
            LOGGER.warn("Writing chunk to disk before hash check took " + duration + "ms. Storage backend overloaded?");
        }
        this.chunks.markCompleted(currentChunk, false);
        this.chunkStatusChanged(currentChunk);
        if (passEx != null) {
            throw passEx;
        }
        return needNewBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(final Downloader connection, ExecutorService pool) {
        if (this.state == TransferState.FINISHED) {
            this.handleIncomingWhenFinished(connection, pool);
            return true;
        }
        if (this.state == TransferState.ERROR) {
            return false;
        }
        List<Downloader> list = this.downloads;
        synchronized (list) {
            if (this.downloads.size() >= MAX_CONNECTIONS_PER_TRANSFER) {
                return false;
            }
            this.downloads.add(connection);
        }
        try {
            pool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int active;
                    try {
                        CbHandler cbh = new CbHandler(connection);
                        if (connection.download(cbh, (WantRangeCallback)cbh)) {
                            IncomingTransferBase.this.connectFails.set(0);
                        } else {
                            IncomingTransferBase.this.connectFails.incrementAndGet();
                            if (cbh.currentChunk != null) {
                                IncomingTransferBase.this.chunks.markFailed(cbh.currentChunk);
                                if (IncomingTransferBase.this.localCopyManager != null && ((CbHandler)cbh).currentChunk.sha1sum != null) {
                                    ArrayList<byte[]> lst = new ArrayList<byte[]>(1);
                                    lst.add(((CbHandler)cbh).currentChunk.sha1sum);
                                    IncomingTransferBase.this.checkLocalCopyCandidates(lst, 0);
                                }
                                IncomingTransferBase.this.chunkStatusChanged(cbh.currentChunk);
                            }
                            LOGGER.info("Connection for " + IncomingTransferBase.this.getTmpFileName().getAbsolutePath() + " dropped prematurely");
                        }
                        if (IncomingTransferBase.this.state != TransferState.FINISHED && IncomingTransferBase.this.state != TransferState.ERROR) {
                            IncomingTransferBase.this.lastActivityTime.set(System.currentTimeMillis());
                        }
                    }
                    finally {
                        List list = IncomingTransferBase.this.downloads;
                        synchronized (list) {
                            IncomingTransferBase.this.downloads.remove(connection);
                            active = IncomingTransferBase.this.downloads.size();
                        }
                    }
                    if (IncomingTransferBase.this.chunks.isComplete()) {
                        IncomingTransferBase.this.finishUploadInternal();
                    } else if (IncomingTransferBase.this.state == TransferState.WORKING) {
                        IncomingTransferBase.this.queueUnhashedChunk(true);
                        if (IncomingTransferBase.this.localCopyManager != null) {
                            IncomingTransferBase.this.localCopyManager.trigger();
                        }
                        LOGGER.info("Downloader disconnected, " + active + " still running. " + IncomingTransferBase.this.chunks.getStats());
                    } else {
                        LOGGER.info("Downloader disconnected, state=" + IncomingTransferBase.this.state + ". " + IncomingTransferBase.this.chunks.getStats());
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("threadpool rejected the incoming file transfer", (Throwable)e);
            List<Downloader> list2 = this.downloads;
            synchronized (list2) {
                this.downloads.remove(connection);
            }
            return false;
        }
        if (this.state == TransferState.IDLE) {
            this.state = TransferState.WORKING;
        }
        return true;
    }

    private boolean handleIncomingWhenFinished(final Downloader connection, ExecutorService pool) {
        try {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    connection.sendDoneAndClose();
                }
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileData(long fileOffset, int dataLength, byte[] data) {
        RandomAccessFile randomAccessFile = this.tmpFileHandle;
        synchronized (randomAccessFile) {
            if (this.state != TransferState.WORKING) {
                throw new IllegalStateException("Cannot write to file if state != WORKING (is " + this.state.toString() + ")");
            }
            try {
                this.tmpFileHandle.seek(fileOffset);
                this.tmpFileHandle.write(data, 0, dataLength);
            }
            catch (IOException e) {
                LOGGER.error("Cannot write to '" + this.getTmpFileName() + "'. Disk full, network storage error, bad permissions, ...?", (Throwable)e);
                this.fileWritable = false;
            }
        }
        if (!this.fileWritable) {
            this.cancel();
        }
    }

    @Override
    public void hashCheckDone(HashChecker.HashResult result, byte[] data, FileChunk chunk) {
        if (this.state != TransferState.IDLE && this.state != TransferState.WORKING) {
            LOGGER.warn("hashCheckDone called in bad state " + this.state.name());
            return;
        }
        switch (result) {
            case FAILURE: {
                LOGGER.warn("Hash check of chunk " + chunk.toString() + " could not be executed. Assuming valid :-(");
            }
            case VALID: {
                if (chunk.isWrittenToDisk()) {
                    this.chunks.markCompleted(chunk, true);
                } else {
                    try {
                        long pre = System.currentTimeMillis();
                        this.writeFileData(chunk.range.startOffset, chunk.range.getLength(), data);
                        long duration = System.currentTimeMillis() - pre;
                        if (duration > 2000L) {
                            LOGGER.warn("Writing chunk to disk after hash check took " + duration + "ms. Storage backend overloaded?");
                        }
                        this.chunks.markCompleted(chunk, true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write to file after hash check", (Throwable)e);
                        this.chunks.markFailed(chunk);
                    }
                }
                this.chunkStatusChanged(chunk);
                if (!this.chunks.isComplete()) break;
                this.finishUploadInternal();
                break;
            }
            case INVALID: {
                LOGGER.warn("Hash check of chunk " + chunk.getChunkIndex() + " resulted in mismatch " + chunk.getFailCount() + "x :-(");
                this.chunks.markFailed(chunk);
                this.chunkStatusChanged(chunk);
                break;
            }
            case NONE: {
                LOGGER.warn("Got hashCheckDone with result NONE");
            }
        }
        this.queueUnhashedChunk(false);
        if (this.localCopyManager != null && this.localCopyManager.isAlive()) {
            this.localCopyManager.trigger();
        }
    }

    protected void queueUnhashedChunk(boolean blocking) {
        byte[] data;
        FileChunk chunk = this.chunks.getUnhashedComplete();
        if (chunk == null) {
            return;
        }
        try {
            data = this.loadChunkFromFile(chunk);
        }
        catch (EOFException e1) {
            LOGGER.warn("Cannot queue unhashed chunk: file too short. Marking as invalid.");
            this.chunks.markFailed(chunk);
            this.chunkStatusChanged(chunk);
            return;
        }
        if (data == null) {
            LOGGER.warn("Cannot queue unhashed chunk: Will mark unloadable unhashed chunk as valid :-(");
            this.chunks.markCompleted(chunk, true);
            this.chunkStatusChanged(chunk);
            return;
        }
        try {
            int flags = 2;
            if (blocking) {
                flags |= 1;
            }
            if (!hashChecker.queue(chunk, data, this, flags)) {
                this.chunks.markCompleted(chunk, false);
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted while trying to queueUnhashedChunk");
            this.chunks.markCompleted(chunk, false);
            Thread.currentThread().interrupt();
        }
    }

    final synchronized void finishUploadInternal() {
        if (this.state == TransferState.FINISHED || this.state == TransferState.ERROR) {
            return;
        }
        try {
            if (this.tmpFileHandle.length() < this.fileSize && this.chunks.lastChunkIsZero()) {
                this.tmpFileHandle.setLength(this.fileSize);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot extend file size to " + this.fileSize);
        }
        IncomingTransferBase.safeClose(this.tmpFileHandle);
        if (this.localCopyManager != null) {
            this.localCopyManager.interrupt();
        }
        this.state = TransferState.FINISHED;
        if (!this.finishIncomingTransfer()) {
            this.state = TransferState.ERROR;
        }
    }

    public static HashChecker getHashChecker() {
        return hashChecker;
    }

    protected abstract boolean hasEnoughFreeSpace();

    protected abstract boolean finishIncomingTransfer();

    protected abstract void chunkStatusChanged(FileChunk var1);

    protected boolean chunkReceived(FileChunk chunk, byte[] data) {
        return false;
    }

    public boolean isServerSideCopyingEnabled() {
        return this.localCopyManager != null && !this.localCopyManager.isPaused();
    }

    public void enableServerSideCopying(boolean serverSideCopying) {
        if (this.localCopyManager != null) {
            this.localCopyManager.setPaused(!serverSideCopying);
        }
    }

    static {
        HashChecker hc;
        LOGGER = LogManager.getLogger(IncomingTransferBase.class);
        MAX_CONNECTIONS_PER_TRANSFER = 2;
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem == Long.MAX_VALUE) {
            LOGGER.warn("Cannot determine maximum JVM memory -- assuming 1GB -- this might not be safe");
            maxMem = 1024L;
        } else {
            maxMem /= 0x100000L;
        }
        int maxLen = Math.max(6, Runtime.getRuntime().availableProcessors());
        int hashQueueLen = (int)(maxMem / 150L);
        if (hashQueueLen < 1) {
            hashQueueLen = 1;
        } else if (hashQueueLen > maxLen) {
            hashQueueLen = maxLen;
        }
        LOGGER.debug("Queue length: " + hashQueueLen);
        try {
            hc = new HashChecker("SHA-1", hashQueueLen);
        }
        catch (NoSuchAlgorithmException e) {
            hc = null;
        }
        hashChecker = hc;
    }

    private class CbHandler
    implements WantRangeCallback,
    DataReceivedCallback {
        private FileChunk currentChunk = null;
        private byte[] buffer = new byte[0x1000000];
        private final Downloader downloader;

        private CbHandler(Downloader downloader) {
            this.downloader = downloader;
        }

        @Override
        public boolean dataReceived(long fileOffset, int dataLength, byte[] data) {
            if (this.currentChunk == null) {
                throw new IllegalStateException("dataReceived without current chunk");
            }
            if (!this.currentChunk.range.contains(fileOffset, fileOffset + (long)dataLength)) {
                throw new IllegalStateException("dataReceived with file data out of range");
            }
            System.arraycopy(data, 0, this.buffer, (int)(fileOffset - this.currentChunk.range.startOffset), dataLength);
            return IncomingTransferBase.this.fileWritable;
        }

        @Override
        public FileRange get() {
            boolean needNewBuffer = false;
            if (this.currentChunk != null) {
                try {
                    if (IncomingTransferBase.this.chunkReceivedInternal(this.currentChunk, this.buffer)) {
                        needNewBuffer = true;
                    }
                }
                catch (InterruptedException e3) {
                    LOGGER.info("Downloader was interrupted when trying to hash");
                    this.currentChunk = null;
                    return null;
                }
                if (needNewBuffer) {
                    try {
                        this.buffer = new byte[this.buffer.length];
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            Thread.sleep(6000L);
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                            return null;
                        }
                        try {
                            this.buffer = new byte[this.buffer.length];
                        }
                        catch (OutOfMemoryError e2) {
                            LOGGER.warn("Out of JVM memory - aborting incoming " + IncomingTransferBase.this.getId());
                            this.downloader.sendErrorCode("Out of RAM");
                            IncomingTransferBase.this.cancel();
                        }
                    }
                }
                this.currentChunk = null;
            }
            try {
                this.currentChunk = IncomingTransferBase.this.chunks.getMissing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.info("Incoming transfer connection was interrupted");
                return null;
            }
            if (this.currentChunk == null) {
                return null;
            }
            if (!IncomingTransferBase.this.hasEnoughFreeSpace()) {
                this.downloader.sendErrorCode("Out of disk space");
                LOGGER.error("Out of space: Cancelling upload of " + IncomingTransferBase.this.getTmpFileName().getAbsolutePath());
                IncomingTransferBase.this.cancel();
                return null;
            }
            if (IncomingTransferBase.this.state == TransferState.IDLE) {
                IncomingTransferBase.this.state = TransferState.WORKING;
            }
            return this.currentChunk.range;
        }
    }
}

