/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.firmware;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import org.openslx.firmware.FirmwareMapping;
import org.openslx.firmware.FirmwareTarget;

public class QemuFirmware {
    public static final String DEFAULT_SPEC_DIR = "/usr/share/qemu/firmware";
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="interface-types")
    private ArrayList<String> interfaceTypes;
    @SerializedName(value="mapping")
    private FirmwareMapping mapping;
    @SerializedName(value="targets")
    private ArrayList<FirmwareTarget> targets;
    @SerializedName(value="features")
    private ArrayList<String> features;
    @SerializedName(value="tags")
    private ArrayList<String> tags;

    public String getDescription() {
        return this.description;
    }

    public ArrayList<String> getInterfaceTypes() {
        return this.interfaceTypes;
    }

    public FirmwareMapping getMapping() {
        return this.mapping;
    }

    public ArrayList<FirmwareTarget> getTargets() {
        return this.targets;
    }

    public ArrayList<String> getFeatures() {
        return this.features;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    public static QemuFirmware fromFwSpec(File fwSpecFile) {
        Gson gson = new Gson();
        QemuFirmware firmware = null;
        try {
            FileReader jsonContent = new FileReader(fwSpecFile);
            firmware = gson.fromJson((Reader)jsonContent, QemuFirmware.class);
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException | NullPointerException e) {
            firmware = null;
        }
        return firmware;
    }
}

