/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.capabilities.guest;

import java.util.ArrayList;
import java.util.List;
import org.openslx.libvirt.capabilities.guest.Domain;
import org.openslx.libvirt.capabilities.guest.Machine;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.w3c.dom.NodeList;

public class Guest
extends LibvirtXmlNode {
    public Guest() {
    }

    public Guest(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Domain.OsType getOsType() {
        String osType = this.getXmlElementValue("os_type");
        return Domain.OsType.fromString(osType);
    }

    public String getArchName() {
        return this.getXmlElementAttributeValue("arch", "name");
    }

    public int getArchWordSize() {
        String archWordSize = this.getXmlElementValue("arch/wordsize");
        return Integer.parseInt(archWordSize);
    }

    public String getArchEmulator() {
        return this.getXmlElementValue("arch/emulator");
    }

    public List<Machine> getArchMachines() {
        ArrayList<Machine> machinesList = new ArrayList<Machine>();
        NodeList machineNodes = this.getXmlNodes("arch/machine");
        for (int i = 0; i < machineNodes.getLength(); ++i) {
            LibvirtXmlNode machineNode = new LibvirtXmlNode(this.getXmlDocument(), machineNodes.item(i));
            Machine machine = Machine.newInstance(machineNode);
            if (machine == null) continue;
            machinesList.add(machine);
        }
        return machinesList;
    }

    public List<Domain> getArchDomains() {
        ArrayList<Domain> domainList = new ArrayList<Domain>();
        NodeList domainNodes = this.getXmlNodes("arch/domain");
        for (int i = 0; i < domainNodes.getLength(); ++i) {
            LibvirtXmlNode domainNode = new LibvirtXmlNode(this.getXmlDocument(), domainNodes.item(i));
            Domain domain = Domain.newInstance(domainNode);
            if (domain == null) continue;
            domainList.add(domain);
        }
        return domainList;
    }

    public static Guest newInstance(LibvirtXmlNode xmlNode) {
        return new Guest(xmlNode);
    }
}

