/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.openslx.libvirt.domain.DomainUtils;
import org.openslx.libvirt.domain.device.Controller;
import org.openslx.libvirt.domain.device.ControllerFloppy;
import org.openslx.libvirt.domain.device.ControllerIde;
import org.openslx.libvirt.domain.device.ControllerPci;
import org.openslx.libvirt.domain.device.ControllerSata;
import org.openslx.libvirt.domain.device.ControllerScsi;
import org.openslx.libvirt.domain.device.ControllerUsb;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.Disk;
import org.openslx.libvirt.domain.device.DiskCdrom;
import org.openslx.libvirt.domain.device.DiskFloppy;
import org.openslx.libvirt.domain.device.DiskStorage;
import org.openslx.libvirt.domain.device.FileSystem;
import org.openslx.libvirt.domain.device.Graphics;
import org.openslx.libvirt.domain.device.GraphicsSpice;
import org.openslx.libvirt.domain.device.GraphicsVnc;
import org.openslx.libvirt.domain.device.Hostdev;
import org.openslx.libvirt.domain.device.HostdevMdev;
import org.openslx.libvirt.domain.device.HostdevPci;
import org.openslx.libvirt.domain.device.HostdevUsb;
import org.openslx.libvirt.domain.device.Interface;
import org.openslx.libvirt.domain.device.InterfaceBridge;
import org.openslx.libvirt.domain.device.InterfaceNetwork;
import org.openslx.libvirt.domain.device.Parallel;
import org.openslx.libvirt.domain.device.RedirDevice;
import org.openslx.libvirt.domain.device.Serial;
import org.openslx.libvirt.domain.device.Shmem;
import org.openslx.libvirt.domain.device.Sound;
import org.openslx.libvirt.domain.device.Video;
import org.openslx.libvirt.xml.LibvirtXmlDocument;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.libvirt.xml.LibvirtXmlResources;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.openslx.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Domain
extends LibvirtXmlDocument {
    private static final String XMLNS_QEMU_NS_URI = "http://libvirt.org/schemas/domain/qemu/1.0";
    private static final String XMLNS_QEMU_NS_PREFIX = "qemu";

    public Domain(String xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("domain.rng"));
        this.assertDomainType();
    }

    public Domain(File xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("domain.rng"));
        this.assertDomainType();
    }

    public Domain(InputStream xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("domain.rng"));
        this.assertDomainType();
    }

    public Domain(InputSource xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("domain.rng"));
        this.assertDomainType();
    }

    private void assertDomainType() throws LibvirtXmlValidationException {
        try {
            XPathExpression expr = XmlHelper.compileXPath("/domain[@type]");
            Object nodesObject = expr.evaluate(this.getRootXmlNode().getXmlDocument(), XPathConstants.NODESET);
            NodeList nodes = (NodeList)nodesObject;
            if (nodes.getLength() == 0) {
                throw new LibvirtXmlValidationException("Root element isn't <domain type=...>");
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Type getType() {
        String typeValue = this.getRootXmlNode().getXmlElementAttributeValue(null, "type");
        return Type.fromString(typeValue);
    }

    public void setType(Type type) {
        this.getRootXmlNode().setXmlElementAttributeValue(null, "type", type.toString());
    }

    public String getName() {
        return this.getRootXmlNode().getXmlElementValue("name");
    }

    public void setName(String name) {
        this.getRootXmlNode().setXmlElementValue("name", name);
    }

    public String getTitle() {
        return this.getRootXmlNode().getXmlElementValue("title");
    }

    public void setTitle(String title) {
        this.getRootXmlNode().setXmlElementValue("title", title);
    }

    public String getDescription() {
        return this.getRootXmlNode().getXmlElementValue("description");
    }

    public void setDescription(String description) {
        this.getRootXmlNode().setXmlElementValue("description", description);
    }

    public String getLibOsInfoOsId() {
        return this.getRootXmlNode().getXmlElementAttributeValue("metadata/*[local-name()='libosinfo']/*[local-name()='os']", "id");
    }

    public boolean isFeatureHypervVendorIdStateOn() {
        return this.getRootXmlNode().getXmlElementAttributeValueAsBool("features/hyperv/vendor_id", "state");
    }

    public void setFeatureHypervVendorIdState(boolean on) {
        this.getRootXmlNode().setXmlElementAttributeValueOnOff("features/hyperv/vendor_id", "state", on);
    }

    public String getFeatureHypervVendorIdValue() {
        return this.getRootXmlNode().getXmlElementAttributeValue("features/hyperv/vendor_id", "value");
    }

    public void setFeatureHypervVendorIdValue(String value) {
        this.getRootXmlNode().setXmlElementAttributeValue("features/hyperv/vendor_id", "value", value);
    }

    public boolean isFeatureKvmHiddenStateOn() {
        return this.getRootXmlNode().getXmlElementAttributeValueAsBool("features/kvm/hidden", "state");
    }

    public void setFeatureKvmHiddenState(boolean on) {
        this.getRootXmlNode().setXmlElementAttributeValueOnOff("features/kvm/hidden", "state", on);
        this.getRootXmlNode().setXmlElement("cpu");
        if (on) {
            Element cpu = this.getRootXmlNode().getXmlElement("cpu");
            XmlHelper.getOrCreateElement(this.getRootXmlNode().getXmlDocument(), cpu, null, null, "feature", "name", "hypervisor");
            this.getRootXmlNode().setXmlElementAttributeValue("cpu/feature", "policy", "disable");
        } else {
            this.getRootXmlNode().removeXmlElement("cpu/feature[@name='hypervisor']");
        }
    }

    public String getUuid() {
        return this.getRootXmlNode().getXmlElementValue("uuid");
    }

    public void setUuid(String uuid) {
        this.getRootXmlNode().setXmlElementValue("uuid", uuid);
    }

    public void removeUuid() {
        this.getRootXmlNode().removeXmlElement("uuid");
    }

    public BigInteger getMemory() {
        String memValue = this.getRootXmlNode().getXmlElementValue("memory");
        String memUnit = this.getRootXmlNode().getXmlElementAttributeValue("memory", "unit");
        return DomainUtils.decodeMemory(memValue, memUnit);
    }

    public void setMemory(BigInteger memory) {
        this.getRootXmlNode().setXmlElementAttributeValue("memory", "unit", "KiB");
        this.getRootXmlNode().setXmlElementValue("memory", DomainUtils.encodeMemory(memory, "KiB"));
    }

    public BigInteger getCurrentMemory() {
        String memValue = this.getRootXmlNode().getXmlElementValue("currentMemory");
        String memUnit = this.getRootXmlNode().getXmlElementAttributeValue("currentMemory", "unit");
        return DomainUtils.decodeMemory(memValue, memUnit);
    }

    public void setCurrentMemory(BigInteger currentMemory) {
        this.getRootXmlNode().setXmlElementAttributeValue("currentMemory", "unit", "KiB");
        this.getRootXmlNode().setXmlElementValue("currentMemory", DomainUtils.encodeMemory(currentMemory, "KiB"));
    }

    public int getVCpu() {
        String number = this.getRootXmlNode().getXmlElementValue("vcpu");
        return Integer.parseUnsignedInt(number);
    }

    public void setVCpu(int number) {
        this.getRootXmlNode().setXmlElementValue("vcpu", Integer.toString(number));
    }

    public OsType getOsType() {
        String osType = this.getRootXmlNode().getXmlElementValue("os/type");
        return OsType.fromString(osType);
    }

    public void setOsType(OsType type) {
        this.getRootXmlNode().setXmlElementValue("os/type", type.toString());
    }

    public String getOsArch() {
        return this.getRootXmlNode().getXmlElementAttributeValue("os/type", "arch");
    }

    public void setOsArch(String arch) {
        this.getRootXmlNode().setXmlElementAttributeValue("os/type", "arch", arch);
    }

    public String getOsMachine() {
        return this.getRootXmlNode().getXmlElementAttributeValue("os/type", "machine");
    }

    public void setOsMachine(String machine) {
        this.getRootXmlNode().setXmlElementAttributeValue("os/type", "machine", machine);
    }

    public String getOsLoader() {
        return this.getRootXmlNode().getXmlElementValue("os/loader");
    }

    public void setOsLoader(String loader) {
        if (loader == null) {
            this.getRootXmlNode().removeXmlElement("os/loader");
        } else {
            this.getRootXmlNode().setXmlElementValue("os/loader", loader);
        }
    }

    public String getOsFirmware() {
        return this.getRootXmlNode().getXmlElementAttributeValue("os", "firmware");
    }

    public void setOsFirmware(String firmware) {
        this.getRootXmlNode().setXmlElementAttributeValue("os", "firmware", firmware);
    }

    public String getOsNvram() {
        return this.getRootXmlNode().getXmlElementValue("os/nvram");
    }

    public void setOsNvram(String nvram) {
        this.getRootXmlNode().setXmlElementValue("os/nvram", nvram);
    }

    public String getCpuModel() {
        return this.getRootXmlNode().getXmlElementValue("cpu/model");
    }

    public void setCpuModel(String model) {
        this.getRootXmlNode().setXmlElementValue("cpu/model", model);
    }

    public CpuMode getCpuMode() {
        String cpuMode = this.getRootXmlNode().getXmlElementAttributeValue("cpu", "mode");
        return CpuMode.fromString(cpuMode);
    }

    public void setCpuMode(CpuMode mode) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu", "mode", mode.toString());
        if (mode == CpuMode.HOST_PASSTHROUGH) {
            this.getRootXmlNode().setXmlElementAttributeValue("cpu/cache", "mode", "passthrough");
        } else if ("passthrough".equals(this.getRootXmlNode().getXmlElementAttributeValue("cpu/cache", "mode"))) {
            this.getRootXmlNode().removeXmlElement("cpu/cache");
        }
    }

    public boolean getCpuMigratable() {
        return this.getRootXmlNode().getXmlElementAttributeValueAsBool("cpu", "migratable");
    }

    public void setCpuMigratable(boolean migratable) {
        this.getRootXmlNode().setXmlElementAttributeValueOnOff("cpu", "migratable", migratable);
    }

    public CpuCheck getCpuCheck() {
        String cpuCheck = this.getRootXmlNode().getXmlElementAttributeValue("cpu", "check");
        return CpuCheck.fromString(cpuCheck);
    }

    public void setCpuCheck(CpuCheck check) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu", "check", check.toString());
    }

    public int getCpuDies() {
        String numDies = this.getRootXmlNode().getXmlElementAttributeValue("cpu/topology", "dies");
        return Integer.valueOf(numDies);
    }

    public void setCpuDies(int number) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu/topology", "dies", Integer.toString(number));
    }

    public int getCpuSockets() {
        String numSockets = this.getRootXmlNode().getXmlElementAttributeValue("cpu/topology", "sockets");
        return Integer.valueOf(numSockets);
    }

    public void setCpuSockets(int number) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu/topology", "sockets", Integer.toString(number));
    }

    public int getCpuCores() {
        String numCores = this.getRootXmlNode().getXmlElementAttributeValue("cpu/topology", "cores");
        return Integer.valueOf(numCores);
    }

    public void setCpuCores(int number) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu/topology", "cores", Integer.toString(number));
    }

    public int getCpuThreads() {
        String numThreads = this.getRootXmlNode().getXmlElementAttributeValue("cpu/topology", "threads");
        return Integer.valueOf(numThreads);
    }

    public void setCpuThreads(int number) {
        this.getRootXmlNode().setXmlElementAttributeValue("cpu/topology", "threads", Integer.toString(number));
    }

    public String getDevicesEmulator() {
        return this.getRootXmlNode().getXmlElementValue("devices/emulator");
    }

    public void setDevicesEmulator(String emulator) {
        this.getRootXmlNode().setXmlElementValue("devices/emulator", emulator);
    }

    public ArrayList<Device> getDevices() {
        ArrayList<Device> devices = new ArrayList<Device>();
        Element devicesNode = this.getRootXmlNode().getXmlElement("devices");
        if (devicesNode != null) {
            NodeList devicesElements = devicesNode.getChildNodes();
            for (int i = 0; i < devicesElements.getLength(); ++i) {
                LibvirtXmlNode deviceNode;
                Device device;
                Node childNode = devicesElements.item(i);
                if (childNode.getNodeType() != 1 || (device = Device.newInstance(deviceNode = new LibvirtXmlNode(this.getRootXmlNode().getXmlDocument(), childNode))) == null) continue;
                devices.add(device);
            }
        }
        return devices;
    }

    private static <R> ArrayList<R> filterDevices(Class<R> cls, ArrayList<Device> devices) {
        Predicate<Device> byFilter = device -> cls.isInstance(device);
        Function<Device, Object> castFunction = device -> cls.cast(device);
        return devices.stream().filter(byFilter).map(castFunction).collect(Collectors.toCollection(ArrayList::new));
    }

    public ArrayList<Controller> getControllerDevices() {
        return Domain.filterDevices(Controller.class, this.getDevices());
    }

    public ArrayList<ControllerFloppy> getFloppyControllerDevices() {
        return Domain.filterDevices(ControllerFloppy.class, this.getDevices());
    }

    public ArrayList<ControllerIde> getIdeControllerDevices() {
        return Domain.filterDevices(ControllerIde.class, this.getDevices());
    }

    public ArrayList<ControllerPci> getPciControllerDevices() {
        return Domain.filterDevices(ControllerPci.class, this.getDevices());
    }

    public ArrayList<ControllerSata> getSataControllerDevices() {
        return Domain.filterDevices(ControllerSata.class, this.getDevices());
    }

    public ArrayList<ControllerScsi> getScsiControllerDevices() {
        return Domain.filterDevices(ControllerScsi.class, this.getDevices());
    }

    public ArrayList<ControllerUsb> getUsbControllerDevices() {
        return Domain.filterDevices(ControllerUsb.class, this.getDevices());
    }

    public ArrayList<Disk> getDiskDevices() {
        return Domain.filterDevices(Disk.class, this.getDevices());
    }

    public ArrayList<DiskCdrom> getDiskCdromDevices() {
        return Domain.filterDevices(DiskCdrom.class, this.getDevices());
    }

    public ArrayList<DiskFloppy> getDiskFloppyDevices() {
        return Domain.filterDevices(DiskFloppy.class, this.getDevices());
    }

    public ArrayList<DiskStorage> getDiskStorageDevices() {
        return Domain.filterDevices(DiskStorage.class, this.getDevices());
    }

    public ArrayList<FileSystem> getFileSystemDevices() {
        return Domain.filterDevices(FileSystem.class, this.getDevices());
    }

    public ArrayList<Hostdev> getHostdevDevices() {
        return Domain.filterDevices(Hostdev.class, this.getDevices());
    }

    public ArrayList<HostdevMdev> getHostdevMdevDevices() {
        return Domain.filterDevices(HostdevMdev.class, this.getDevices());
    }

    public ArrayList<HostdevPci> getHostdevPciDevices() {
        return Domain.filterDevices(HostdevPci.class, this.getDevices());
    }

    public ArrayList<HostdevUsb> getHostdevUsbDevices() {
        return Domain.filterDevices(HostdevUsb.class, this.getDevices());
    }

    public ArrayList<Interface> getInterfaceDevices() {
        return Domain.filterDevices(Interface.class, this.getDevices());
    }

    public ArrayList<Graphics> getGraphicDevices() {
        return Domain.filterDevices(Graphics.class, this.getDevices());
    }

    public ArrayList<GraphicsSpice> getGraphicSpiceDevices() {
        return Domain.filterDevices(GraphicsSpice.class, this.getDevices());
    }

    public ArrayList<GraphicsVnc> getGraphicVncDevices() {
        return Domain.filterDevices(GraphicsVnc.class, this.getDevices());
    }

    public ArrayList<Parallel> getParallelDevices() {
        return Domain.filterDevices(Parallel.class, this.getDevices());
    }

    public ArrayList<Serial> getSerialDevices() {
        return Domain.filterDevices(Serial.class, this.getDevices());
    }

    public ArrayList<Shmem> getShmemDevices() {
        return Domain.filterDevices(Shmem.class, this.getDevices());
    }

    public ArrayList<Sound> getSoundDevices() {
        return Domain.filterDevices(Sound.class, this.getDevices());
    }

    public ArrayList<Video> getVideoDevices() {
        return Domain.filterDevices(Video.class, this.getDevices());
    }

    public ArrayList<RedirDevice> getRedirectDevices() {
        return Domain.filterDevices(RedirDevice.class, this.getDevices());
    }

    public ArrayList<String> getQemuCmdlnArguments() {
        Document xmlDocument = this.getRootXmlNode().getXmlDocument();
        ArrayList<String> qemuCmdlnArgs = new ArrayList<String>();
        NodeList qemuCmdlnNodes = xmlDocument.getElementsByTagNameNS(XMLNS_QEMU_NS_URI, "commandline");
        if (qemuCmdlnNodes.getLength() > 0) {
            Node qemuCmdlnNode = qemuCmdlnNodes.item(0);
            NodeList qemuCmdlnArgNodes = qemuCmdlnNode.getChildNodes();
            for (int i = 0; i < qemuCmdlnArgNodes.getLength(); ++i) {
                Element qemuCmdlnArgElement;
                String value;
                Node qemuCmdlnArgNode = qemuCmdlnArgNodes.item(i);
                if (qemuCmdlnArgNode.getNodeType() != 1 || (value = (qemuCmdlnArgElement = (Element)Element.class.cast(qemuCmdlnArgNode)).getAttribute("value")) == null || value.isEmpty()) continue;
                qemuCmdlnArgs.add(value);
            }
        }
        return qemuCmdlnArgs;
    }

    public Device addDevice(Device device) {
        Element devicesNode;
        Device addedDevice = null;
        if (device != null && (devicesNode = this.getRootXmlNode().getXmlElement("devices")) != null) {
            LibvirtXmlNode parentDevicesNode = null;
            parentDevicesNode = new LibvirtXmlNode(this.getRootXmlNode().getXmlDocument(), devicesNode);
            addedDevice = Device.createInstance(device, parentDevicesNode);
        }
        return addedDevice;
    }

    public Controller addControllerDevice() {
        return (Controller)Controller.class.cast(this.addDevice(new Controller()));
    }

    public ControllerFloppy addControllerFloppyDevice() {
        return (ControllerFloppy)ControllerFloppy.class.cast(this.addDevice(new ControllerFloppy()));
    }

    public ControllerIde addControllerIdeDevice() {
        return (ControllerIde)ControllerIde.class.cast(this.addDevice(new ControllerIde()));
    }

    public ControllerPci addControllerPciDevice() {
        return (ControllerPci)ControllerPci.class.cast(this.addDevice(new ControllerPci()));
    }

    public ControllerSata addControllerSataDevice() {
        return (ControllerSata)ControllerSata.class.cast(this.addDevice(new ControllerSata()));
    }

    public ControllerScsi addControllerScsiDevice() {
        return (ControllerScsi)ControllerScsi.class.cast(this.addDevice(new ControllerScsi()));
    }

    public ControllerUsb addControllerUsbDevice() {
        return (ControllerUsb)ControllerUsb.class.cast(this.addDevice(new ControllerUsb()));
    }

    public Disk addDiskDevice() {
        return (Disk)Disk.class.cast(this.addDevice(new Disk()));
    }

    public DiskCdrom addDiskCdromDevice() {
        return (DiskCdrom)DiskCdrom.class.cast(this.addDevice(new DiskCdrom()));
    }

    public DiskFloppy addDiskFloppyDevice() {
        return (DiskFloppy)DiskFloppy.class.cast(this.addDevice(new DiskFloppy()));
    }

    public DiskStorage addDiskStorageDevice() {
        return (DiskStorage)DiskStorage.class.cast(this.addDevice(new DiskStorage()));
    }

    public FileSystem addFileSystemDevice() {
        return (FileSystem)FileSystem.class.cast(this.addDevice(new FileSystem()));
    }

    public Hostdev addHostdevDevice() {
        return (Hostdev)Hostdev.class.cast(this.addDevice(new Hostdev()));
    }

    public HostdevMdev addHostdevMdevDevice() {
        return (HostdevMdev)HostdevMdev.class.cast(this.addDevice(new HostdevMdev()));
    }

    public HostdevPci addHostdevPciDevice() {
        return (HostdevPci)HostdevPci.class.cast(this.addDevice(new HostdevPci()));
    }

    public HostdevUsb addHostdevUsbDevice() {
        return (HostdevUsb)HostdevUsb.class.cast(this.addDevice(new HostdevUsb()));
    }

    public Interface addInterfaceDevice() {
        return (Interface)Interface.class.cast(this.addDevice(new Interface()));
    }

    public InterfaceBridge addInterfaceBridgeDevice() {
        return (InterfaceBridge)InterfaceBridge.class.cast(this.addDevice(new InterfaceBridge()));
    }

    public InterfaceNetwork addInterfaceNetworkDevice() {
        return (InterfaceNetwork)InterfaceNetwork.class.cast(this.addDevice(new InterfaceNetwork()));
    }

    public Graphics addGraphicsDevice() {
        return (Graphics)Graphics.class.cast(this.addDevice(new Graphics()));
    }

    public GraphicsSpice addGraphicsSpiceDevice() {
        return (GraphicsSpice)GraphicsSpice.class.cast(this.addDevice(new GraphicsSpice()));
    }

    public GraphicsVnc addGraphicsVncDevice() {
        return (GraphicsVnc)GraphicsVnc.class.cast(this.addDevice(new GraphicsVnc()));
    }

    public Parallel addParallelDevice() {
        return (Parallel)Parallel.class.cast(this.addDevice(new Parallel()));
    }

    public Serial addSerialDevice() {
        return (Serial)Serial.class.cast(this.addDevice(new Serial()));
    }

    public Shmem addShmemDevice() {
        return (Shmem)Shmem.class.cast(this.addDevice(new Shmem()));
    }

    public Sound addSoundDevice() {
        return (Sound)Sound.class.cast(this.addDevice(new Sound()));
    }

    public Video addVideoDevice() {
        return (Video)Video.class.cast(this.addDevice(new Video()));
    }

    public void addQemuCmdlnArgument(String value) {
        Element qemuCmdlnElement;
        Element rootElement = (Element)Element.class.cast(this.getRootXmlNode().getXmlBaseNode());
        Document xmlDocument = this.getRootXmlNode().getXmlDocument();
        NodeList qemuCmdlnNodes = rootElement.getElementsByTagNameNS(XMLNS_QEMU_NS_URI, "commandline");
        if (qemuCmdlnNodes.getLength() < 1) {
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:qemu", XMLNS_QEMU_NS_URI);
            qemuCmdlnElement = xmlDocument.createElementNS(XMLNS_QEMU_NS_URI, "commandline");
            qemuCmdlnElement.setPrefix(XMLNS_QEMU_NS_PREFIX);
            rootElement.appendChild(qemuCmdlnElement);
        } else {
            Node qemuCmdlnNode = qemuCmdlnNodes.item(0);
            assert (qemuCmdlnNode.getNodeType() == 1);
            qemuCmdlnElement = (Element)Element.class.cast(qemuCmdlnNode);
        }
        Element qemuCmdlnArgElement = xmlDocument.createElementNS(XMLNS_QEMU_NS_URI, "arg");
        qemuCmdlnArgElement.setAttribute("value", value);
        qemuCmdlnElement.appendChild(qemuCmdlnArgElement);
    }

    public void addGvtg(String optionalRomfile) {
        Element qemuOverrideElement;
        Element rootElement = (Element)Element.class.cast(this.getRootXmlNode().getXmlBaseNode());
        Document xmlDocument = this.getRootXmlNode().getXmlDocument();
        NodeList qemuCmdlnNodes = rootElement.getElementsByTagNameNS(XMLNS_QEMU_NS_URI, "override");
        if (qemuCmdlnNodes.getLength() < 1) {
            rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:qemu", XMLNS_QEMU_NS_URI);
            qemuOverrideElement = xmlDocument.createElementNS(XMLNS_QEMU_NS_URI, "override");
            qemuOverrideElement.setPrefix(XMLNS_QEMU_NS_PREFIX);
            rootElement.appendChild(qemuOverrideElement);
        } else {
            Node qemuOverrideNode = qemuCmdlnNodes.item(0);
            assert (qemuOverrideNode.getNodeType() == 1);
            qemuOverrideElement = (Element)Element.class.cast(qemuOverrideNode);
        }
        Element qemuDeviceElement = XmlHelper.getOrCreateElement(xmlDocument, qemuOverrideElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "device", "alias", "hostdev0");
        Element qemuFrontendElement = XmlHelper.getOrCreateElement(xmlDocument, qemuDeviceElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "frontend", null, null);
        Element prop = XmlHelper.getOrCreateElement(xmlDocument, qemuFrontendElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "property", "name", "x-igd-opregion");
        prop.setAttribute("type", "bool");
        prop.setAttribute("value", "true");
        prop = XmlHelper.getOrCreateElement(xmlDocument, qemuFrontendElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "property", "name", "driver");
        prop.setAttribute("type", "string");
        prop.setAttribute("value", "vfio-pci-nohotplug");
        prop = XmlHelper.getOrCreateElement(xmlDocument, qemuFrontendElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "property", "name", "ramfb");
        prop.setAttribute("type", "bool");
        prop.setAttribute("value", "true");
        if (optionalRomfile != null) {
            prop = XmlHelper.getOrCreateElement(xmlDocument, qemuFrontendElement, XMLNS_QEMU_NS_URI, XMLNS_QEMU_NS_PREFIX, "property", "name", "romfile");
            prop.setAttribute("type", "string");
            prop.setAttribute("value", optionalRomfile);
        }
    }

    public void removeBootOrder() {
        for (Disk diskDevice : this.getDiskDevices()) {
            diskDevice.removeBootOrder();
        }
        for (Interface interfaceDevice : this.getInterfaceDevices()) {
            interfaceDevice.removeBootOrder();
        }
        for (Hostdev hostdevDevice : this.getHostdevDevices()) {
            hostdevDevice.removeBootOrder();
        }
        this.getRootXmlNode().removeXmlElement("os/boot");
    }

    public void removeDiskDevicesStorage() {
        for (Disk diskDevice : this.getDiskDevices()) {
            diskDevice.removeStorage();
        }
    }

    public void removeOsNvram() {
        Element nvramElement = this.getRootXmlNode().getXmlElement("os/nvram");
        if (nvramElement != null) {
            nvramElement.getParentNode().removeChild(nvramElement);
        }
    }

    public void removeInterfaceDevicesSource() {
        for (Interface interfaceDevice : this.getInterfaceDevices()) {
            interfaceDevice.setSource("");
        }
    }

    public void resetCpuPin() {
        this.getRootXmlNode().removeXmlElement("cputune");
        this.getRootXmlNode().removeXmlElement("numatune");
    }

    public void addCpuPin(int virtualCore, int hostCore) {
        Element rootElement = (Element)Element.class.cast(this.getRootXmlNode().getXmlBaseNode());
        Document xmlDocument = this.getRootXmlNode().getXmlDocument();
        Element cpuTune = this.getRootXmlNode().getXmlElement("cputune");
        if (cpuTune == null) {
            cpuTune = xmlDocument.createElement("cputune");
            rootElement.appendChild(cpuTune);
        }
        Element pin = xmlDocument.createElement("vcpupin");
        pin.setAttribute("vcpu", Integer.toString(virtualCore));
        pin.setAttribute("cpuset", Integer.toString(hostCore));
        cpuTune.appendChild(pin);
        Element vcpuNode = this.getRootXmlNode().getXmlElement("vcpu");
        if (vcpuNode instanceof Element) {
            vcpuNode.setAttribute("placement", "static");
        }
    }

    public static enum CpuCheck {
        NONE("none"),
        PARTIAL("partial"),
        FULL("full");

        private String cpuCheck;

        private CpuCheck(String check) {
            this.cpuCheck = check;
        }

        public String toString() {
            return this.cpuCheck;
        }

        public static CpuCheck fromString(String check) {
            for (CpuCheck t : CpuCheck.values()) {
                if (!t.cpuCheck.equalsIgnoreCase(check)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum CpuMode {
        CUSTOM("custom"),
        HOST_MODEL("host-model"),
        HOST_PASSTHROUGH("host-passthrough");

        private String cpuMode;

        private CpuMode(String mode) {
            this.cpuMode = mode;
        }

        public String toString() {
            return this.cpuMode;
        }

        public static CpuMode fromString(String mode) {
            for (CpuMode t : CpuMode.values()) {
                if (!t.cpuMode.equalsIgnoreCase(mode)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum OsType {
        XEN("xen"),
        LINUX("linux"),
        HVM("hvm"),
        EXE("exe"),
        UML("uml");

        private final String osType;

        private OsType(String osType) {
            this.osType = osType;
        }

        public String toString() {
            return this.osType;
        }

        public static OsType fromString(String osType) {
            for (OsType t : OsType.values()) {
                if (!t.osType.equalsIgnoreCase(osType)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum Type {
        QEMU("qemu"),
        KQEMU("kqemu"),
        KVM("kvm"),
        XEN("xen"),
        LXC("lxc"),
        UML("uml"),
        OPENVZ("openvz"),
        TEST("test"),
        VMWARE("vmware"),
        HYPERV("hyperv"),
        VBOX("vbox"),
        PHYP("phyp"),
        VZ("vz"),
        BHYVE("bhyve");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

