/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.ControllerFloppy;
import org.openslx.libvirt.domain.device.ControllerIde;
import org.openslx.libvirt.domain.device.ControllerPci;
import org.openslx.libvirt.domain.device.ControllerSata;
import org.openslx.libvirt.domain.device.ControllerScsi;
import org.openslx.libvirt.domain.device.ControllerUsb;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Controller
extends Device {
    public Controller() {
    }

    public Controller(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public int getIndex() {
        String index = this.getXmlElementAttributeValue("index");
        return Integer.parseInt(index);
    }

    public void setIndex(int index) {
        this.setXmlElementAttributeValue("index", Integer.toString(index));
    }

    public static Controller createInstance(Controller controller, LibvirtXmlNode xmlNode) {
        Controller addedController = null;
        if (controller instanceof ControllerFloppy) {
            xmlNode.setXmlElementAttributeValue("type", Type.FLOPPY.toString());
            addedController = ControllerFloppy.createInstance(xmlNode);
        } else if (controller instanceof ControllerIde) {
            xmlNode.setXmlElementAttributeValue("type", Type.IDE.toString());
            addedController = ControllerIde.createInstance(xmlNode);
        } else if (controller instanceof ControllerPci) {
            xmlNode.setXmlElementAttributeValue("type", Type.PCI.toString());
            addedController = ControllerPci.createInstance(xmlNode);
        } else if (controller instanceof ControllerSata) {
            xmlNode.setXmlElementAttributeValue("type", Type.SATA.toString());
            addedController = ControllerSata.createInstance(xmlNode);
        } else if (controller instanceof ControllerScsi) {
            xmlNode.setXmlElementAttributeValue("type", Type.SCSI.toString());
            addedController = ControllerScsi.createInstance(xmlNode);
        } else if (controller instanceof ControllerUsb) {
            xmlNode.setXmlElementAttributeValue("type", Type.USB.toString());
            addedController = ControllerUsb.createInstance(xmlNode);
        }
        return addedController;
    }

    public static Controller newInstance(LibvirtXmlNode xmlNode) {
        Controller deviceController = null;
        Type type = Type.fromString(xmlNode.getXmlElementAttributeValue("type"));
        if (type == null) {
            return null;
        }
        switch (type) {
            case FLOPPY: {
                deviceController = ControllerFloppy.newInstance(xmlNode);
                break;
            }
            case IDE: {
                deviceController = ControllerIde.newInstance(xmlNode);
                break;
            }
            case PCI: {
                deviceController = ControllerPci.newInstance(xmlNode);
                break;
            }
            case SATA: {
                deviceController = ControllerSata.newInstance(xmlNode);
                break;
            }
            case SCSI: {
                deviceController = ControllerScsi.newInstance(xmlNode);
                break;
            }
            case USB: {
                deviceController = ControllerUsb.newInstance(xmlNode);
            }
        }
        return deviceController;
    }

    static enum Type {
        FLOPPY("fdc"),
        IDE("ide"),
        PCI("pci"),
        SATA("sata"),
        SCSI("scsi"),
        USB("usb");

        private String type = null;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

