/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.apache.commons.lang3.NotImplementedException;
import org.openslx.libvirt.domain.device.BusType;
import org.openslx.libvirt.domain.device.Controller;
import org.openslx.libvirt.domain.device.Disk;
import org.openslx.libvirt.domain.device.FileSystem;
import org.openslx.libvirt.domain.device.Graphics;
import org.openslx.libvirt.domain.device.Hostdev;
import org.openslx.libvirt.domain.device.HostdevAddressableTarget;
import org.openslx.libvirt.domain.device.HostdevPciDeviceAddress;
import org.openslx.libvirt.domain.device.HostdevUsbDeviceAddress;
import org.openslx.libvirt.domain.device.HostdevUtils;
import org.openslx.libvirt.domain.device.Interface;
import org.openslx.libvirt.domain.device.Parallel;
import org.openslx.libvirt.domain.device.RedirDevice;
import org.openslx.libvirt.domain.device.Serial;
import org.openslx.libvirt.domain.device.Shmem;
import org.openslx.libvirt.domain.device.Sound;
import org.openslx.libvirt.domain.device.Video;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Device
extends LibvirtXmlNode
implements HostdevAddressableTarget<HostdevPciDeviceAddress> {
    public Device() {
    }

    public Device(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public void remove() {
        Node node = this.getXmlElement();
        node.getParentNode().removeChild(node);
    }

    private static LibvirtXmlNode createDeviceElement(LibvirtXmlNode xmlParentNode, DeviceClass deviceType) {
        Document xmlDocument = xmlParentNode.getXmlDocument();
        Element deviceNode = xmlDocument.createElement(deviceType.toString());
        xmlParentNode.getXmlBaseNode().appendChild(deviceNode);
        return new LibvirtXmlNode(xmlParentNode.getXmlDocument(), deviceNode);
    }

    public static Device createInstance(Device device, LibvirtXmlNode xmlParentNode) {
        Device createdDevice = null;
        if (device instanceof Controller) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.CONTROLLER);
            createdDevice = Controller.createInstance((Controller)Controller.class.cast(device), xmlNode);
        } else if (device instanceof Disk) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.DISK);
            createdDevice = Disk.createInstance((Disk)Disk.class.cast(device), xmlNode);
        } else if (device instanceof FileSystem) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.FILESYSTEM);
            createdDevice = FileSystem.createInstance(xmlNode);
        } else if (device instanceof Hostdev) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.HOSTDEV);
            createdDevice = Hostdev.createInstance((Hostdev)Hostdev.class.cast(device), xmlNode);
        } else if (device instanceof Interface) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.INTERFACE);
            createdDevice = Interface.createInstance((Interface)Interface.class.cast(device), xmlNode);
        } else if (device instanceof Graphics) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.GRAPHICS);
            createdDevice = Graphics.createInstance((Graphics)Graphics.class.cast(device), xmlNode);
        } else if (device instanceof Parallel) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.PARALLEL);
            createdDevice = Parallel.createInstance(xmlNode);
        } else if (device instanceof Serial) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.SERIAL);
            createdDevice = Serial.createInstance(xmlNode);
        } else if (device instanceof Shmem) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.SHMEM);
            createdDevice = Shmem.createInstance(xmlNode);
        } else if (device instanceof Sound) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.SOUND);
            createdDevice = Sound.createInstance(xmlNode);
        } else if (device instanceof Video) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.VIDEO);
            createdDevice = Video.createInstance(xmlNode);
        } else if (device instanceof RedirDevice) {
            LibvirtXmlNode xmlNode = Device.createDeviceElement(xmlParentNode, DeviceClass.REDIRDEV);
            createdDevice = RedirDevice.createInstance(xmlNode);
        }
        return createdDevice;
    }

    public static Device newInstance(LibvirtXmlNode xmlNode) {
        Node element = xmlNode.getXmlElement();
        if (element == null) {
            return null;
        }
        Device device = null;
        DeviceClass type = DeviceClass.fromString(element.getNodeName());
        if (type == null) {
            return new Device(xmlNode);
        }
        switch (type) {
            case CONTROLLER: {
                device = Controller.newInstance(xmlNode);
                break;
            }
            case DISK: {
                device = Disk.newInstance(xmlNode);
                break;
            }
            case FILESYSTEM: {
                device = FileSystem.newInstance(xmlNode);
                break;
            }
            case HOSTDEV: {
                device = Hostdev.newInstance(xmlNode);
                break;
            }
            case INTERFACE: {
                device = Interface.newInstance(xmlNode);
                break;
            }
            case GRAPHICS: {
                device = Graphics.newInstance(xmlNode);
                break;
            }
            case PARALLEL: {
                device = Parallel.newInstance(xmlNode);
                break;
            }
            case REDIRDEV: {
                device = RedirDevice.newInstance(xmlNode);
                break;
            }
            case SERIAL: {
                device = Serial.newInstance(xmlNode);
                break;
            }
            case SHMEM: {
                device = Shmem.newInstance(xmlNode);
                break;
            }
            case SOUND: {
                device = Sound.newInstance(xmlNode);
                break;
            }
            case VIDEO: {
                device = Video.newInstance(xmlNode);
                break;
            }
            default: {
                throw new NotImplementedException("Class not implemented");
            }
        }
        return device;
    }

    protected void setUsbAddress(String expression, HostdevUsbDeviceAddress address) {
        this.setXmlElementAttributeValue(expression, "bus", Integer.toString(address.getUsbBus()));
        this.setXmlElementAttributeValue(expression, "port", Integer.toString(address.getUsbPort()));
        this.setXmlElementAttributeValue(expression, "type", BusType.USB.toString());
    }

    protected void setPciAddress(String expression, HostdevPciDeviceAddress address, boolean includeType) {
        String pciDomain = HostdevUtils.appendHexPrefix(address.getPciDomainAsString());
        String pciBus = HostdevUtils.appendHexPrefix(address.getPciBusAsString());
        String pciDevice = HostdevUtils.appendHexPrefix(address.getPciDeviceAsString());
        String pciFunction = HostdevUtils.appendHexPrefix(address.getPciFunctionAsString());
        this.setXmlElementAttributeValue(expression, "domain", pciDomain);
        this.setXmlElementAttributeValue(expression, "bus", pciBus);
        this.setXmlElementAttributeValue(expression, "slot", pciDevice);
        this.setXmlElementAttributeValue(expression, "function", pciFunction);
        if (includeType) {
            this.setXmlElementAttributeValue(expression, "type", BusType.PCI.toString());
        } else {
            this.removeXmlElementAttribute(expression, "type");
        }
    }

    protected HostdevPciDeviceAddress getPciAddress(String expression) {
        String pciDomain = this.getXmlElementAttributeValue(expression, "domain");
        String pciBus = this.getXmlElementAttributeValue(expression, "bus");
        String pciDevice = this.getXmlElementAttributeValue(expression, "slot");
        String pciFunction = this.getXmlElementAttributeValue(expression, "function");
        pciDomain = HostdevUtils.removeHexPrefix(pciDomain);
        pciBus = HostdevUtils.removeHexPrefix(pciBus);
        pciDevice = HostdevUtils.removeHexPrefix(pciDevice);
        pciFunction = HostdevUtils.removeHexPrefix(pciFunction);
        return HostdevPciDeviceAddress.valueOf(pciDomain + ":" + pciBus + ":" + pciDevice + "." + pciFunction);
    }

    @Override
    public HostdevPciDeviceAddress getPciTarget() {
        if (!"pci".equals(this.getXmlElementAttributeValue("address", "type"))) {
            return null;
        }
        return this.getPciAddress("address");
    }

    @Override
    public void setPciTarget(HostdevPciDeviceAddress address) {
        this.setPciAddress("address", address, true);
    }

    protected HostdevUsbDeviceAddress getUsbAddress(String expression) {
        String bus = this.getXmlElementAttributeValue(expression, "bus");
        String port = this.getXmlElementAttributeValue(expression, "port");
        return HostdevUsbDeviceAddress.valueOf(bus, port);
    }

    public BusType getDeviceBusType() {
        return BusType.fromString(this.getXmlElementAttributeValue("bus"));
    }

    public DeviceClass getDeviceClass() {
        return DeviceClass.fromString(this.getXmlBaseNode().getLocalName());
    }

    public HostdevUsbDeviceAddress getUsbTarget() {
        if (!"usb".equals(this.getXmlElementAttributeValue("address", "type"))) {
            return null;
        }
        return this.getUsbAddress("address");
    }

    public void setUsbTarget(HostdevUsbDeviceAddress address) {
        this.setUsbAddress("address", address);
    }

    public static enum DeviceClass {
        CONTROLLER("controller"),
        DISK("disk"),
        FILESYSTEM("filesystem"),
        HOSTDEV("hostdev"),
        INTERFACE("interface"),
        GRAPHICS("graphics"),
        PARALLEL("parallel"),
        REDIRDEV("redirdev"),
        SERIAL("serial"),
        SHMEM("shmem"),
        SOUND("sound"),
        VIDEO("video");

        private String type = null;

        private DeviceClass(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static DeviceClass fromString(String type) {
            for (DeviceClass t : DeviceClass.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

