/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.DiskCdrom;
import org.openslx.libvirt.domain.device.DiskFloppy;
import org.openslx.libvirt.domain.device.DiskStorage;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.w3c.dom.Element;

public class Disk
extends Device {
    public Disk() {
    }

    public Disk(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public StorageType getStorageType() {
        String storageType = this.getXmlElementAttributeValue("type");
        return StorageType.fromString(storageType);
    }

    protected void setStorageType(StorageType storageType) {
        this.setXmlElementAttributeValue("type", storageType.toString());
    }

    public String getStorageSource() {
        StorageType storageType = this.getStorageType();
        String storageSource = null;
        switch (storageType) {
            case FILE: {
                storageSource = this.getXmlElementAttributeValue("source", "file");
                break;
            }
            case BLOCK: {
                storageSource = this.getXmlElementAttributeValue("source", "dev");
            }
        }
        return storageSource;
    }

    protected void setStorageSource(String source) {
        StorageType storageType = this.getStorageType();
        this.removeXmlElementAttributes("source");
        switch (storageType) {
            case FILE: {
                this.setXmlElementAttributeValue("source", "file", source);
                break;
            }
            case BLOCK: {
                this.setXmlElementAttributeValue("source", "dev", source);
            }
        }
    }

    public void setStorage(StorageType storageType, String source) {
        this.setStorageType(storageType);
        this.setStorageSource(source);
    }

    public void removeStorage() {
        this.removeXmlElement("source");
    }

    public void removeBootOrder() {
        this.removeXmlElement("boot");
    }

    public boolean isReadOnly() {
        Element readOnly = this.getXmlElement("readonly");
        return readOnly != null;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setXmlElement("readonly");
        } else {
            this.removeXmlElement("readonly");
        }
    }

    public BusType getBusType() {
        String busType = this.getXmlElementAttributeValue("target", "bus");
        return BusType.fromString(busType);
    }

    public void setBusType(BusType busType) {
        this.setXmlElementAttributeValue("target", "bus", busType.toString());
    }

    public String getTargetDevice() {
        return this.getXmlElementAttributeValue("target", "dev");
    }

    public void setTargetDevice(String targetDevice) {
        this.setXmlElementAttributeValue("target", "dev", targetDevice);
    }

    public static Disk createInstance(Disk disk, LibvirtXmlNode xmlNode) {
        Disk addedDisk = null;
        if (disk instanceof DiskCdrom) {
            xmlNode.setXmlElementAttributeValue("device", Type.CDROM.toString());
            addedDisk = DiskCdrom.createInstance(xmlNode);
        } else if (disk instanceof DiskFloppy) {
            xmlNode.setXmlElementAttributeValue("device", Type.FLOPPY.toString());
            addedDisk = DiskFloppy.createInstance(xmlNode);
        } else if (disk instanceof DiskStorage) {
            xmlNode.setXmlElementAttributeValue("device", Type.STORAGE.toString());
            addedDisk = DiskStorage.createInstance(xmlNode);
        }
        return addedDisk;
    }

    public static Disk newInstance(LibvirtXmlNode xmlNode) {
        Disk deviceDisk = null;
        Type type = Type.fromString(xmlNode.getXmlElementAttributeValue("device"));
        if (type == null) {
            return null;
        }
        switch (type) {
            case CDROM: {
                deviceDisk = DiskCdrom.newInstance(xmlNode);
                break;
            }
            case FLOPPY: {
                deviceDisk = DiskFloppy.newInstance(xmlNode);
                break;
            }
            case STORAGE: {
                deviceDisk = DiskStorage.newInstance(xmlNode);
            }
        }
        return deviceDisk;
    }

    public static enum BusType {
        IDE("ide"),
        FDC("fdc"),
        SATA("sata"),
        SCSI("scsi"),
        SD("sd"),
        USB("usb"),
        VIRTIO("virtio"),
        XEN("xen");

        private String busType = null;

        private BusType(String busType) {
            this.busType = busType;
        }

        public String toString() {
            return this.busType;
        }

        public static BusType fromString(String busType) {
            for (BusType t : BusType.values()) {
                if (!t.busType.equalsIgnoreCase(busType)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum StorageType {
        FILE("file"),
        BLOCK("block");

        private String storageType = null;

        private StorageType(String storageType) {
            this.storageType = storageType;
        }

        public String toString() {
            return this.storageType;
        }

        public static StorageType fromString(String storageType) {
            for (StorageType t : StorageType.values()) {
                if (!t.storageType.equalsIgnoreCase(storageType)) continue;
                return t;
            }
            return null;
        }
    }

    static enum Type {
        CDROM("cdrom"),
        FLOPPY("floppy"),
        STORAGE("disk");

        private String type = null;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

