/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class FileSystem
extends Device {
    public FileSystem() {
    }

    public FileSystem(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public AccessMode getAccessMode() {
        String mode = this.getXmlElementAttributeValue("accessmode");
        return AccessMode.fromString(mode);
    }

    public void setAccessMode(AccessMode mode) {
        this.setXmlElementAttributeValue("accessmode", mode.toString());
    }

    public Type getType() {
        String type = this.getXmlElementAttributeValue("type");
        return Type.fromString(type);
    }

    public void setType(Type type) {
        this.setXmlElementAttributeValue("type", type.toString());
    }

    public String getSource() {
        Type type = this.getType();
        String source = null;
        switch (type) {
            case BIND: {
                source = this.getXmlElementAttributeValue("source", "dir");
                break;
            }
            case BLOCK: {
                source = this.getXmlElementAttributeValue("source", "dev");
                break;
            }
            case FILE: {
                source = this.getXmlElementAttributeValue("source", "file");
                break;
            }
            case MOUNT: {
                source = this.getXmlElementAttributeValue("source", "dir");
                break;
            }
            case RAM: {
                source = this.getXmlElementAttributeValue("source", "usage");
                break;
            }
            case TEMPLATE: {
                source = this.getXmlElementAttributeValue("source", "name");
            }
        }
        return source;
    }

    public void setSource(String source) {
        Type type = this.getType();
        this.removeXmlElementAttributes("source");
        switch (type) {
            case BIND: {
                this.setXmlElementAttributeValue("source", "dir", source);
                break;
            }
            case BLOCK: {
                this.setXmlElementAttributeValue("source", "dev", source);
                break;
            }
            case FILE: {
                this.setXmlElementAttributeValue("source", "file", source);
                break;
            }
            case MOUNT: {
                this.setXmlElementAttributeValue("source", "dir", source);
                break;
            }
            case RAM: {
                this.setXmlElementAttributeValue("source", "usage", source);
                break;
            }
            case TEMPLATE: {
                this.setXmlElementAttributeValue("source", "name", source);
            }
        }
    }

    public String getTarget() {
        return this.getXmlElementAttributeValue("target", "dir");
    }

    public void setTarget(String target) {
        this.setXmlElementAttributeValue("target", "dir", target);
    }

    public static FileSystem createInstance(LibvirtXmlNode xmlNode) {
        return FileSystem.newInstance(xmlNode);
    }

    public static FileSystem newInstance(LibvirtXmlNode xmlNode) {
        return new FileSystem(xmlNode);
    }

    public static enum Type {
        MOUNT("mount"),
        TEMPLATE("template"),
        FILE("file"),
        BLOCK("block"),
        RAM("ram"),
        BIND("bind");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum AccessMode {
        PASSTHROUGH("passthrough"),
        MAPPED("mapped"),
        SQUASH("squash");

        private String mode;

        private AccessMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }

        public static AccessMode fromString(String mode) {
            for (AccessMode a : AccessMode.values()) {
                if (!a.mode.equalsIgnoreCase(mode)) continue;
                return a;
            }
            return null;
        }
    }
}

