/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.GraphicsSpice;
import org.openslx.libvirt.domain.device.GraphicsVnc;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Graphics
extends Device {
    public Graphics() {
    }

    public Graphics(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public ListenType getListenType() {
        String listenType = this.getXmlElementAttributeValue("listen", "type");
        return ListenType.fromString(listenType);
    }

    public void setListenType(ListenType type) {
        this.setXmlElementAttributeValue("listen", "type", type.toString());
    }

    public InetAddress getListenAddress() {
        InetAddress parsedListenAddress = null;
        if (this.getListenType() == ListenType.ADDRESS) {
            String rawListenAddress = this.getXmlElementAttributeValue("listen", "address");
            try {
                parsedListenAddress = InetAddress.getByName(rawListenAddress);
            }
            catch (UnknownHostException e) {
                parsedListenAddress = null;
            }
        }
        return parsedListenAddress;
    }

    public void setListenAddress(InetAddress listenAddress) {
        if (this.getListenType() == ListenType.ADDRESS && listenAddress != null) {
            this.setXmlElementAttributeValue("listen", "address", listenAddress.getHostAddress());
        }
    }

    public int getListenPort() {
        String listenPort = this.getXmlElementAttributeValue("port");
        return Integer.valueOf(listenPort);
    }

    public void setListenPort(int listenPort) {
        if (this.getListenType() == ListenType.ADDRESS) {
            this.setXmlElementAttributeValue("port", Integer.toString(listenPort));
        }
    }

    public static Graphics createInstance(Graphics graphics, LibvirtXmlNode xmlNode) {
        Graphics addedGraphics = null;
        if (graphics instanceof GraphicsSpice) {
            xmlNode.setXmlElementAttributeValue("type", Type.SPICE.toString());
            addedGraphics = GraphicsSpice.createInstance(xmlNode);
        } else if (graphics instanceof GraphicsVnc) {
            xmlNode.setXmlElementAttributeValue("type", Type.VNC.toString());
            addedGraphics = GraphicsVnc.createInstance(xmlNode);
        }
        return addedGraphics;
    }

    public static Graphics newInstance(LibvirtXmlNode xmlNode) {
        Graphics deviceGraphics = null;
        Type type = Type.fromString(xmlNode.getXmlElementAttributeValue("type"));
        if (type == null) {
            return null;
        }
        switch (type) {
            case SPICE: {
                deviceGraphics = GraphicsSpice.newInstance(xmlNode);
                break;
            }
            case VNC: {
                deviceGraphics = GraphicsVnc.newInstance(xmlNode);
            }
        }
        return deviceGraphics;
    }

    static enum Type {
        SPICE("spice"),
        VNC("vnc");

        private String type = null;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum ListenType {
        NONE("none"),
        ADDRESS("address"),
        NETWORK("network"),
        SOCKET("socket");

        private String type = null;

        private ListenType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static ListenType fromString(String type) {
            for (ListenType t : ListenType.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

