/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostdevPciDeviceAddress {
    private static final String DEVICE_ADDRESS_REGEX = "^([a-f0-9]{4}):([a-f0-9]{2}):([a-f0-9]{2})\\.([0-7]{1})$";
    private static final int DEVICE_ADDRESS_MIN_VALUE = 0;
    private static final int DEVICE_ADDRESS_DOMAIN_MAX_VALUE = 65535;
    private static final int DEVICE_ADDRESS_BUS_MAX_VALUE = 255;
    private static final int DEVICE_ADDRESS_DEVICE_MAX_VALUE = 31;
    private static final int DEVICE_ADDRESS_FUNCTION_MAX_VALUE = 7;
    final int pciDomain;
    final int pciBus;
    final int pciDevice;
    final int pciFunction;

    public HostdevPciDeviceAddress() {
        this(0, 0, 0, 0);
    }

    public HostdevPciDeviceAddress(int pciBus, int pciDevice, int pciFunction) throws IllegalArgumentException {
        this(0, pciBus, pciDevice, pciFunction);
    }

    public HostdevPciDeviceAddress(int pciDomain, int pciBus, int pciDevice, int pciFunction) throws IllegalArgumentException {
        HostdevPciDeviceAddress.validatePciDeviceAddress(pciDomain, "PCI domain", 65535);
        HostdevPciDeviceAddress.validatePciDeviceAddress(pciBus, "PCI bus", 255);
        HostdevPciDeviceAddress.validatePciDeviceAddress(pciDevice, "PCI device", 31);
        HostdevPciDeviceAddress.validatePciDeviceAddress(pciFunction, "PCI function", 7);
        this.pciDomain = pciDomain;
        this.pciBus = pciBus;
        this.pciDevice = pciDevice;
        this.pciFunction = pciFunction;
    }

    private static void validatePciDeviceAddress(int address, String addressName, int upperLimit) throws IllegalArgumentException {
        if (address < 0) {
            throw new IllegalArgumentException("The " + addressName + " address must be larger or equal than " + 0);
        }
        if (address > upperLimit) {
            throw new IllegalArgumentException("The " + addressName + " address must be smaller or equal than " + upperLimit);
        }
    }

    public int getPciDomain() {
        return this.pciDomain;
    }

    public String getPciDomainAsString() {
        return String.format("%04x", 0xFFFF & this.getPciDomain());
    }

    public int getPciBus() {
        return this.pciBus;
    }

    public String getPciBusAsString() {
        return String.format("%02x", 0xFF & this.getPciBus());
    }

    public int getPciDevice() {
        return this.pciDevice;
    }

    public String getPciDeviceAsString() {
        return String.format("%02x", 0x1F & this.getPciDevice());
    }

    public int getPciFunction() {
        return this.pciFunction;
    }

    public String getPciFunctionAsString() {
        return String.format("%01x", 7 & this.getPciFunction());
    }

    public static HostdevPciDeviceAddress valueOf(String pciDeviceAddress) {
        HostdevPciDeviceAddress parsedPciDeviceAddress;
        if (pciDeviceAddress == null || pciDeviceAddress.isEmpty()) {
            parsedPciDeviceAddress = null;
        } else {
            Pattern pciDeviceAddressPattern = Pattern.compile(DEVICE_ADDRESS_REGEX);
            Matcher pciDeviceAddressMatcher = pciDeviceAddressPattern.matcher(pciDeviceAddress.toLowerCase());
            if (pciDeviceAddressMatcher.find()) {
                int pciDomain = Integer.valueOf(pciDeviceAddressMatcher.group(1), 16);
                int pciBus = Integer.valueOf(pciDeviceAddressMatcher.group(2), 16);
                int pciDevice = Integer.valueOf(pciDeviceAddressMatcher.group(3), 16);
                int pciFunction = Integer.valueOf(pciDeviceAddressMatcher.group(4), 16);
                try {
                    parsedPciDeviceAddress = new HostdevPciDeviceAddress(pciDomain, pciBus, pciDevice, pciFunction);
                }
                catch (IllegalArgumentException e) {
                    parsedPciDeviceAddress = null;
                }
            } else {
                parsedPciDeviceAddress = null;
            }
        }
        return parsedPciDeviceAddress;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostdevPciDeviceAddress other = (HostdevPciDeviceAddress)HostdevPciDeviceAddress.class.cast(obj);
        return this.getPciDomain() == other.getPciDomain() && this.getPciBus() == other.getPciBus() && this.getPciDevice() == other.getPciDevice() && this.getPciFunction() == other.getPciFunction();
    }

    public String toString() {
        return this.getPciDomainAsString() + ":" + this.getPciBusAsString() + ":" + this.getPciDeviceAsString() + "." + this.getPciFunctionAsString();
    }
}

