/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Hostdev;
import org.openslx.libvirt.domain.device.HostdevAddressableSource;
import org.openslx.libvirt.domain.device.HostdevUsbDeviceAddress;
import org.openslx.libvirt.domain.device.HostdevUsbDeviceDescription;
import org.openslx.libvirt.domain.device.HostdevUtils;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class HostdevUsb
extends Hostdev
implements HostdevAddressableSource<HostdevUsbDeviceDescription> {
    public HostdevUsb() {
    }

    public HostdevUsb(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    @Override
    public HostdevUsbDeviceDescription getSource() {
        String vendorId = this.getXmlElementAttributeValue("source/address/vendor", "id");
        String productId = this.getXmlElementAttributeValue("source/address/product", "id");
        vendorId = HostdevUtils.removeHexPrefix(vendorId);
        productId = HostdevUtils.removeHexPrefix(productId);
        return HostdevUsbDeviceDescription.valueOf(vendorId + ":" + productId);
    }

    @Override
    public void setSource(HostdevUsbDeviceDescription description) {
        String vendorId = HostdevUtils.appendHexPrefix(description.getVendorIdAsString());
        String productId = HostdevUtils.appendHexPrefix(description.getProductIdAsString());
        this.setXmlElementAttributeValue("source/address/vendor", "id", vendorId);
        this.setXmlElementAttributeValue("source/address/product", "id", productId);
    }

    @Override
    public HostdevUsbDeviceAddress getUsbTarget() {
        String usbBus = this.getXmlElementAttributeValue("address", "bus");
        String usbPort = this.getXmlElementAttributeValue("address", "port");
        return HostdevUsbDeviceAddress.valueOf(usbBus, usbPort);
    }

    @Override
    public void setUsbTarget(HostdevUsbDeviceAddress address) {
        this.setXmlElementAttributeValue("address", "bus", Integer.toString(address.getUsbBus()));
        this.setXmlElementAttributeValue("address", "port", Integer.toString(address.getUsbPort()));
    }

    public static HostdevUsb createInstance(LibvirtXmlNode xmlNode) {
        return HostdevUsb.newInstance(xmlNode);
    }

    public static HostdevUsb newInstance(LibvirtXmlNode xmlNode) {
        return new HostdevUsb(xmlNode);
    }
}

