/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

public class HostdevUsbDeviceAddress {
    private static final int DEVICE_ADDRESS_MIN_VALUE = 0;
    static final int DEVICE_BUS_MAX_VALUE = 127;
    static final int DEVICE_PORT_MAX_VALUE = 127;
    final int usbBus;
    final int usbPort;

    public HostdevUsbDeviceAddress(int usbBus, int usbPort) throws IllegalArgumentException {
        HostdevUsbDeviceAddress.validateUsbDeviceAddress(usbBus, "USB bus", 127);
        HostdevUsbDeviceAddress.validateUsbDeviceAddress(usbPort, "USB port", 127);
        this.usbBus = usbBus;
        this.usbPort = usbPort;
    }

    private static void validateUsbDeviceAddress(int address, String addressName, int upperLimit) throws IllegalArgumentException {
        if (address < 0) {
            throw new IllegalArgumentException("The " + addressName + " must be larger or equal than " + 0);
        }
        if (address > upperLimit) {
            throw new IllegalArgumentException("The " + addressName + " must be smaller or equal than " + upperLimit);
        }
    }

    public int getUsbBus() {
        return this.usbBus;
    }

    public int getUsbPort() {
        return this.usbPort;
    }

    public static HostdevUsbDeviceAddress valueOf(String usbBus, String usbPort) {
        HostdevUsbDeviceAddress usbDeviceAddress;
        if (usbBus == null || usbBus.isEmpty() || usbPort == null || usbPort.isEmpty()) {
            usbDeviceAddress = null;
        } else {
            try {
                int parsedUsbBus = Integer.valueOf(usbBus);
                int parsedUsbPort = Integer.valueOf(usbPort);
                usbDeviceAddress = new HostdevUsbDeviceAddress(parsedUsbBus, parsedUsbPort);
            }
            catch (IllegalArgumentException e) {
                usbDeviceAddress = null;
            }
        }
        return usbDeviceAddress;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostdevUsbDeviceAddress other = (HostdevUsbDeviceAddress)HostdevUsbDeviceAddress.class.cast(obj);
        return this.getUsbBus() == other.getUsbBus() && this.getUsbPort() == other.getUsbPort();
    }

    public String toString() {
        return this.getUsbBus() + ":" + this.getUsbPort();
    }
}

