/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.BusType;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class RedirDevice
extends Device {
    public RedirDevice() {
    }

    public RedirDevice(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public SrcType getSrcType() {
        String type = this.getXmlElementAttributeValue("type");
        return SrcType.fromString(type);
    }

    public void setSrcType(SrcType type) {
        this.setXmlElementAttributeValue("type", type.toString());
    }

    public static RedirDevice createInstance(LibvirtXmlNode xmlNode) {
        return RedirDevice.newInstance(xmlNode);
    }

    public static RedirDevice newInstance(LibvirtXmlNode xmlNode) {
        return new RedirDevice(xmlNode);
    }

    public void setBusType(BusType usb) {
        this.setXmlElementAttributeValue("bus", usb.toString());
    }

    public static enum SrcType {
        DEV("dev"),
        FILE("file"),
        PIPE("pipe"),
        UNIX("unix"),
        TCP("tcp"),
        UDP("udp"),
        NULL("null"),
        STDIO("stdio"),
        VC("vc"),
        PTY("pty"),
        SPICEVMC("spicevmc"),
        SPICEPORT("spiceport"),
        NMDM("nmdm"),
        QEMU_VDAGENT("qemu-vdagent"),
        DBUS("dbus");

        private String typeString = null;

        private SrcType(String typeString) {
            this.typeString = typeString;
        }

        public String toString() {
            return this.typeString;
        }

        public static SrcType fromString(String model) {
            for (SrcType m : SrcType.values()) {
                if (!m.typeString.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }
}

