/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Serial
extends Device {
    public Serial() {
    }

    public Serial(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Type getType() {
        String type = this.getXmlElementAttributeValue("type");
        return Type.fromString(type);
    }

    public void setType(Type type) {
        this.setXmlElementAttributeValue("type", type.toString());
    }

    public String getSource() {
        return this.getXmlElementAttributeValue("source", "path");
    }

    public void setSource(String source) {
        this.setXmlElementAttributeValue("source", "path", source);
    }

    public static Serial createInstance(LibvirtXmlNode xmlNode) {
        return Serial.newInstance(xmlNode);
    }

    public static Serial newInstance(LibvirtXmlNode xmlNode) {
        return new Serial(xmlNode);
    }

    public static enum Type {
        DEV("dev"),
        FILE("file"),
        PIPE("pipe"),
        UNIX("unix"),
        TCP("tcp"),
        UDP("udp"),
        NULL("null"),
        STDIO("stdio"),
        VC("vc"),
        PTY("pty"),
        SPICEVMC("spicevmc"),
        SPICEPORT("spiceport"),
        NMDM("nmdm");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

