/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.math.BigInteger;
import org.openslx.libvirt.domain.DomainUtils;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Shmem
extends Device {
    public Shmem() {
    }

    public Shmem(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model", "type");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", "type", model.toString());
    }

    public String getName() {
        return this.getXmlElementAttributeValue("name");
    }

    public void setName(String name) {
        this.setXmlElementAttributeValue("name", name);
    }

    public BigInteger getSize() {
        String unit = this.getXmlElementAttributeValue("size", "unit");
        String size = this.getXmlElementValue("size");
        return DomainUtils.decodeMemory(size, unit);
    }

    public void setSize(BigInteger memory) {
        String unit = "M";
        String size = DomainUtils.encodeMemory(memory, "M");
        this.setXmlElementAttributeValue("size", "unit", "M");
        this.setXmlElementValue("size", size);
    }

    public static Shmem createInstance(LibvirtXmlNode xmlNode) {
        return Shmem.newInstance(xmlNode);
    }

    public static Shmem newInstance(LibvirtXmlNode xmlNode) {
        return new Shmem(xmlNode);
    }

    public static enum Model {
        IVSHMEM("ivshmem"),
        IVSHMEM_PLAIN("ivshmem-plain"),
        IVSHMEM_DOORBELL("ivshmem-doorbell");

        private String model;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model m : Model.values()) {
                if (!m.model.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }
}

