/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Sound
extends Device {
    public Sound() {
    }

    public Sound(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", model.toString());
    }

    public static Sound createInstance(LibvirtXmlNode xmlNode) {
        return Sound.newInstance(xmlNode);
    }

    public static Sound newInstance(LibvirtXmlNode xmlNode) {
        return new Sound(xmlNode);
    }

    public static enum Model {
        AC97("ac97"),
        ES1370("es1370"),
        ICH6("ich6"),
        ICH9("ich9"),
        SB16("sb16");

        private String model;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model m : Model.values()) {
                if (!m.model.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }
}

