/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.libvirt.xml.LibvirtXmlResources;
import org.openslx.libvirt.xml.LibvirtXmlSchemaValidator;
import org.openslx.libvirt.xml.LibvirtXmlSerializable;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlValidatable;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LibvirtXmlDocument
implements LibvirtXmlSerializable,
LibvirtXmlValidatable {
    private DocumentBuilder domBuilder = null;
    private Document xmlDocument = null;
    private Transformer xmlTransformer = null;
    private LibvirtXmlNode rootXmlNode = null;
    private LibvirtXmlSchemaValidator rngValidator = null;

    private void createXmlContext(InputStream rngSchema) throws LibvirtXmlDocumentException {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setIgnoringElementContentWhitespace(true);
            domFactory.setNamespaceAware(true);
            this.domBuilder = domFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String errorMsg = "Setting up XML context for reading from the Libvirt XML document failed.";
            throw new LibvirtXmlDocumentException(errorMsg);
        }
        try {
            System.setProperty(TransformerFactory.class.getName(), "org.apache.xalan.processor.TransformerFactoryImpl");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            InputStream xslOutputSchemaStream = LibvirtXmlResources.getLibvirtXsl("xml-output-transformation.xsl");
            StreamSource xslOutputSchema = new StreamSource(xslOutputSchemaStream);
            this.xmlTransformer = transformerFactory.newTransformer(xslOutputSchema);
            this.xmlTransformer.setOutputProperty("encoding", "UTF-8");
        }
        catch (TransformerConfigurationException e) {
            String errorMsg = "Setting up XML context for writing to the Libvirt XML document failed.";
            throw new LibvirtXmlDocumentException(errorMsg);
        }
        if (rngSchema != null) {
            try {
                this.rngValidator = new LibvirtXmlSchemaValidator(rngSchema);
            }
            catch (SAXException e) {
                String errorMsg = "Setting up XML context for validating to the Libvirt XML document failed.";
                e.printStackTrace();
                throw new LibvirtXmlDocumentException(errorMsg);
            }
        }
    }

    public LibvirtXmlDocument(String xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this(xml, null);
    }

    public LibvirtXmlDocument(String xml, InputStream rngSchema) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this.createXmlContext(rngSchema);
        this.fromXml(xml);
    }

    public LibvirtXmlDocument(File xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this(xml, null);
    }

    public LibvirtXmlDocument(File xml, InputStream rngSchema) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this.createXmlContext(rngSchema);
        this.fromXml(xml);
    }

    public LibvirtXmlDocument(InputStream xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this(xml, null);
    }

    public LibvirtXmlDocument(InputStream xml, InputStream rngSchema) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this.createXmlContext(rngSchema);
        this.fromXml(xml);
    }

    public LibvirtXmlDocument(InputSource xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this(xml, null);
    }

    public LibvirtXmlDocument(InputSource xml, InputStream rngSchema) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException {
        this.createXmlContext(rngSchema);
        this.fromXml(xml);
    }

    public LibvirtXmlNode getRootXmlNode() {
        return this.rootXmlNode;
    }

    @Override
    public void fromXml(String xml) throws LibvirtXmlSerializationException {
        this.fromXml(new InputSource(new StringReader(xml)));
    }

    @Override
    public void fromXml(File xml) throws LibvirtXmlSerializationException {
        try {
            this.xmlDocument = this.domBuilder.parse(xml);
            this.xmlDocument.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        this.rootXmlNode = new LibvirtXmlNode(this.xmlDocument, this.xmlDocument.getDocumentElement());
    }

    @Override
    public void fromXml(InputStream xml) throws LibvirtXmlSerializationException {
        try {
            this.xmlDocument = this.domBuilder.parse(xml);
            this.xmlDocument.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        this.rootXmlNode = new LibvirtXmlNode(this.xmlDocument, this.xmlDocument.getDocumentElement());
    }

    @Override
    public void fromXml(InputSource xml) throws LibvirtXmlSerializationException {
        try {
            this.xmlDocument = this.domBuilder.parse(xml);
            this.xmlDocument.getDocumentElement().normalize();
        }
        catch (SAXException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        this.rootXmlNode = new LibvirtXmlNode(this.xmlDocument, this.xmlDocument.getDocumentElement());
    }

    @Override
    public String toXml() throws LibvirtXmlSerializationException {
        StringWriter xmlWriter = null;
        String xml = null;
        try {
            xmlWriter = new StringWriter();
            DOMSource source = new DOMSource(this.xmlDocument);
            StreamResult xmlString = new StreamResult(xmlWriter);
            this.xmlTransformer.transform(source, xmlString);
            xml = xmlWriter.toString();
        }
        catch (Exception e) {
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        finally {
            try {
                xmlWriter.close();
            }
            catch (Throwable throwable) {}
        }
        return xml;
    }

    @Override
    public void toXml(File xml) throws LibvirtXmlSerializationException {
        FileWriter xmlWriter = null;
        try {
            xmlWriter = new FileWriter(xml);
            DOMSource source = new DOMSource(this.xmlDocument);
            StreamResult xmlStream = new StreamResult(xmlWriter);
            this.xmlTransformer.transform(source, xmlStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LibvirtXmlSerializationException(e.getLocalizedMessage());
        }
        finally {
            try {
                xmlWriter.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void validateXml() throws LibvirtXmlValidationException {
        if (this.rngValidator != null) {
            this.rngValidator.validate(this.xmlDocument);
        }
    }

    public String toString() {
        try {
            return this.toXml();
        }
        catch (LibvirtXmlSerializationException e) {
            return null;
        }
    }
}

