/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

public class TransferStatusWrapper {
    private byte[] blocks = null;

    public TransferStatusWrapper(byte[] blocks) {
        this.blocks = blocks;
    }

    public void setBlocks(byte[] blocks) {
        this.blocks = blocks;
    }

    public boolean isComplete() {
        for (byte block : this.blocks) {
            if (block == 0) continue;
            return false;
        }
        return true;
    }

    public float getComplete() {
        int done = 0;
        for (byte block : this.blocks) {
            if (block != 0 && block != 5) continue;
            ++done;
        }
        return (float)done / (float)this.blocks.length;
    }

    public void getCompleteEx(Progress progress) {
        int done = 0;
        int potentialDone = 0;
        for (byte block : this.blocks) {
            if (block == 0) {
                ++done;
                continue;
            }
            if (block != 3 && block != 4 && block != 5) continue;
            ++potentialDone;
        }
        progress.done = (float)done / (float)this.blocks.length;
        progress.potentiallyDone = (float)potentialDone / (float)this.blocks.length;
    }

    public float getPercentComplete() {
        return this.getComplete() * 100.0f;
    }

    public byte[] getBlocks() {
        return this.blocks;
    }

    public boolean isEmpty() {
        return this.blocks == null || this.blocks.length == 0;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    public BlockStatus get(int index) {
        switch (this.blocks[index]) {
            case 0: {
                return BlockStatus.COMPLETE;
            }
            case 1: {
                return BlockStatus.MISSING;
            }
            case 2: {
                return BlockStatus.UPLOADING;
            }
            case 3: {
                return BlockStatus.QUEUED_FOR_COPYING;
            }
            case 4: {
                return BlockStatus.COPYING;
            }
        }
        return null;
    }

    public static class Progress {
        public float done;
        public float potentiallyDone;
    }

    public static enum BlockStatus {
        COMPLETE,
        MISSING,
        UPLOADING,
        QUEUED_FOR_COPYING,
        COPYING,
        HASHING;

    }
}

