/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openslx.util.PrioThreadFactory;

public class CascadedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final RejectedExecutionHandler defaultHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            FALLBACK_TPE.execute(r);
        }
    };
    private static final ThreadPoolExecutor FALLBACK_TPE = new ThreadPoolExecutor(16, 128, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(4), new PrioThreadFactory("FallbackTP"), new ThreadPoolExecutor.AbortPolicy());
    private RejectedExecutionHandler customRejectionHandler = null;

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, String threadNamePrefix) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, (ThreadFactory)new PrioThreadFactory(threadNamePrefix), null);
    }

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueSize, String threadNamePrefix) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queueSize, null, threadNamePrefix);
    }

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueSize, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queueSize, threadFactory, null);
    }

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueSize, RejectedExecutionHandler handler, String threadNamePrefix) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, queueSize, (ThreadFactory)new PrioThreadFactory(threadNamePrefix), handler);
    }

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int queueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, handler);
    }

    public CascadedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, threadFactory, defaultHandler);
        this.customRejectionHandler = handler;
    }

    @Override
    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            if (this.customRejectionHandler == null || this.customRejectionHandler.getClass().equals(ThreadPoolExecutor.AbortPolicy.class)) {
                throw e;
            }
            this.customRejectionHandler.rejectedExecution(command, this);
        }
    }

    static {
        FALLBACK_TPE.allowCoreThreadTimeOut(true);
    }
}

