/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericDataCache<T> {
    private static final Logger LOGGER = LogManager.getLogger(GenericDataCache.class);
    private final int validMs;
    private long validUntil = 0L;
    private final AtomicReference<T> item = new AtomicReference();

    public GenericDataCache(int validMs) {
        this.validMs = validMs;
    }

    public T get() {
        return this.get(CacheMode.DEFAULT);
    }

    public T get(CacheMode mode) {
        switch (mode) {
            case FORCE_CACHED: {
                break;
            }
            case PREFER_CACHED: {
                if (this.validUntil != 0L) break;
                this.ensureUpToDate(true);
                break;
            }
            case DEFAULT: {
                this.ensureUpToDate(false);
                break;
            }
            case NEVER_CACHED: {
                if (this.ensureUpToDate(true)) break;
                return null;
            }
        }
        return this.item.get();
    }

    private synchronized boolean ensureUpToDate(boolean force) {
        T fetched;
        long now = System.currentTimeMillis();
        if (!force && now < this.validUntil) {
            return true;
        }
        try {
            fetched = this.update();
            if (fetched == null) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not fetch fresh data", (Throwable)e);
            return false;
        }
        this.item.set(fetched);
        this.validUntil = now + (long)this.validMs;
        return true;
    }

    protected abstract T update() throws Exception;

    public static enum CacheMode {
        FORCE_CACHED,
        PREFER_CACHED,
        DEFAULT,
        NEVER_CACHED;

    }
}

