/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;

public class Json {
    private static final Logger LOGGER = LogManager.getLogger(Json.class);
    private static final AtomicReference<Gson> gsonRef = new AtomicReference();
    private static final GsonBuilder gsonThriftBuilder = new GsonBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TBase<?, ?>> void registerThriftClass(Class<T> thriftClass) {
        Field[] fieldArray = thriftClass.getFields();
        ArrayList<ThriftField> fields = new ArrayList<ThriftField>(fieldArray.length);
        for (Field field : fieldArray) {
            if ("__isset_bitfield".equals(field.getName()) || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            String upperName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            try {
                Method getter;
                try {
                    getter = thriftClass.getMethod("get" + upperName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    getter = thriftClass.getMethod("is" + upperName, new Class[0]);
                }
                fields.add(new ThriftField(field, getter, thriftClass.getMethod("set" + upperName, field.getType()), thriftClass.getMethod("isSet" + upperName, new Class[0])));
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Nein", (Throwable)e);
            }
        }
        Class<Json> clazz = Json.class;
        synchronized (Json.class) {
            gsonThriftBuilder.registerTypeAdapter(thriftClass, new JsonThriftHandler<T>(thriftClass, fields));
            gsonRef.set(null);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Gson getInstance() {
        Gson gson = gsonRef.get();
        if (gson != null) return gson;
        Class<Json> clazz = Json.class;
        synchronized (Json.class) {
            gson = gsonThriftBuilder.create();
            gsonRef.set(gson);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return gson;
        }
    }

    public static <T> T deserialize(String data, Class<T> classOfData) {
        try {
            return Json.getInstance().fromJson(data, classOfData);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Cannot deserialize to " + classOfData.getSimpleName(), (Throwable)e);
            return null;
        }
    }

    public static String serialize(Object object) {
        return Json.getInstance().toJson(object);
    }

    private static class ThriftField {
        public final Method getter;
        public final Method setter;
        public final Method isset;
        public final Field field;

        ThriftField(Field field, Method getter, Method setter, Method isset) {
            this.field = field;
            this.getter = getter;
            this.setter = setter;
            this.isset = isset;
        }
    }

    private static class JsonThriftHandler<T>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        private final Class<T> clazz;
        private final List<ThriftField> fields;

        public JsonThriftHandler(Class<T> classOfData, List<ThriftField> fields) {
            this.clazz = classOfData;
            this.fields = fields;
        }

        @Override
        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            T inst;
            if (!(json instanceof JsonObject)) {
                throw new JsonParseException("Need a json object, have " + json.getClass().getSimpleName());
            }
            JsonObject obj = (JsonObject)json;
            try {
                inst = this.clazz.newInstance();
            }
            catch (Exception e) {
                LOGGER.warn("Could not deserialize to class " + this.clazz.getName(), (Throwable)e);
                throw new JsonParseException("Cannot instantiate class " + this.clazz.getSimpleName());
            }
            for (ThriftField field : this.fields) {
                JsonElement element = obj.get(field.field.getName());
                if (element == null || element.isJsonNull()) continue;
                try {
                    field.setter.invoke(inst, context.deserialize(element, field.field.getType()));
                }
                catch (Exception e) {
                    LOGGER.warn("Could not call " + field.setter.getName() + " on " + this.clazz.getSimpleName(), (Throwable)e);
                }
            }
            return inst;
        }

        @Override
        public JsonElement serialize(T thriftClass, Type typeOfT, JsonSerializationContext context) {
            JsonObject o = new JsonObject();
            for (ThriftField thrift : this.fields) {
                try {
                    Object value;
                    Object ret = thrift.isset.invoke(thriftClass, new Object[0]);
                    if (!(ret instanceof Boolean) || !((Boolean)ret).booleanValue() || (value = thrift.getter.invoke(thriftClass, new Object[0])) == null) continue;
                    JsonElement jo = null;
                    jo = value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Character ? new JsonPrimitive((Character)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : context.serialize(value))));
                    o.add(thrift.field.getName(), jo);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot serialize field " + thrift.field.getName() + " of thift class " + thriftClass.getClass().getSimpleName(), (Throwable)e);
                }
            }
            return o;
        }
    }
}

