/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.util.CascadedThreadPoolExecutor;

public class Util {
    private static Logger log = LogManager.getLogger(Util.class);
    private static Pattern nonprintableExp = Pattern.compile("[\\p{C}\\p{Zl}\\p{Zp}]");
    private static Pattern nonSpaceExp = Pattern.compile("[^\\p{C}\\p{Z}]");
    private static final String[] UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "???"};

    public static void notNullFatal(Object something, String message) {
        if (something == null) {
            if (message != null) {
                log.fatal("[NOTNULL] " + message);
            }
            log.warn("Fatal null pointer exception", (Throwable)new NullPointerException());
            System.exit(2);
        }
    }

    public static boolean isPrintable(String string) {
        return !nonprintableExp.matcher(string).find();
    }

    public static boolean isEmptyString(String string) {
        return string == null || !nonSpaceExp.matcher(string).find();
    }

    public static void notNullOrEmptyFatal(String something, String message) {
        if (Util.isEmptyString(something)) {
            if (message != null) {
                log.fatal("[NOTNULL] " + message);
            }
            log.warn("Fatal null pointer or empty exception", (Throwable)new NullPointerException());
            System.exit(2);
        }
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long parseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void safeClose(AutoCloseable ... closeable) {
        for (AutoCloseable c : closeable) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean sleep(int millis) {
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean joinThread(Thread t) {
        try {
            t.join();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static long unixTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long tickCount() {
        return System.nanoTime() / 1000000L;
    }

    public static String formatBytes(double val) {
        int unit = 0;
        while (Math.abs(val) > 1024.0) {
            val /= 1024.0;
            ++unit;
        }
        if (unit >= UNITS.length) {
            unit = UNITS.length - 1;
        }
        return String.format("%.1f %s", val, UNITS[unit]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Socket connectAllRecords(final SocketFactory fac, String host, final int port, final int timeout) throws IOException {
        block11: {
            addrList = InetAddress.getAllByName(host);
            if (addrList.length == 0) {
                throw new UnknownHostException("Unknown host: " + host);
            }
            if (addrList.length == 1) {
                s = fac.createSocket();
                s.connect(new InetSocketAddress(addrList[0], port), timeout);
                return s;
            }
            Util.log.debug("Got " + addrList.length + " hosts for " + host);
            name = host.length() > 12 ? host.substring(0, 12) : host;
            tpe = new CascadedThreadPoolExecutor(Math.min(addrList.length, 4), 4, 2L, TimeUnit.SECONDS, 4, new ThreadPoolExecutor.AbortPolicy(), name);
            fe = new AtomicReference<V>();
            retSock = new AtomicReference<V>();
            sem = new Semaphore(0);
            try {
                endIdx = addrList.length - 1;
                idx = 0;
lbl17:
                // 2 sources

                while (idx <= endIdx) {
                    addr = addrList[idx];
                    task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Socket s = fac.createSocket();
                                log.debug("Trying " + addr.toString());
                                s.connect(new InetSocketAddress(addr, port), timeout);
                                if (retSock.compareAndSet(null, s)) {
                                    log.debug(addr.toString() + ": Success");
                                    sem.release();
                                } else {
                                    log.debug(addr.toString() + ": Success, but lost race");
                                    s.close();
                                }
                            }
                            catch (IOException e) {
                                fe.set(e);
                            }
                        }
                    };
                    try {
                        tpe.execute(task);
                    }
                    catch (Exception e) {
                        Util.log.debug("Failed to queue connect for " + addr.toString());
                    }
                    gotit = false;
                    Util.log.debug("Waiting for connect...");
                    try {
                        gotit = idx == endIdx ? sem.tryAcquire(timeout + 10, TimeUnit.MILLISECONDS) : sem.tryAcquire(250L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException var15_17) {
                        // empty catch block
                    }
                    if (gotit) {
                        sem.release();
                        var15_18 = retSock.getAndSet(null);
                        tpe.shutdownNow();
                        break block11;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl49
            }
            catch (Throwable var16_19) {
                tpe.shutdownNow();
                Util.safeClose(new AutoCloseable[]{(AutoCloseable)retSock.get()});
                throw var16_19;
            }
        }
        Util.safeClose(new AutoCloseable[]{(AutoCloseable)retSock.get()});
        return var15_18;
lbl-1000:
        // 1 sources

        {
            ++idx;
            ** GOTO lbl17
lbl49:
            // 1 sources

            Util.log.debug("Out of addresses");
            sem.release();
            throw (IOException)fe.get();
        }
    }
}

