/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlHelper {
    private static final Logger LOGGER = LogManager.getLogger(XmlHelper.class);
    private static final XPath XPath = XPathFactory.newInstance().newXPath();
    private static DocumentBuilder dBuilder;

    public static String globalXPathToLocalXPath(String xPath) {
        String[] elements;
        StringBuilder exprBuilder = new StringBuilder();
        for (String element : elements = xPath.split("/")) {
            String elementSpecifier;
            String elementName;
            if (element.isEmpty()) continue;
            Pattern arraySpecifierRegex = Pattern.compile("^(.*)\\[(.*)\\]$");
            Matcher arraySpecifierMatcher = arraySpecifierRegex.matcher(element);
            if (arraySpecifierMatcher.find()) {
                elementName = arraySpecifierMatcher.group(1);
                elementSpecifier = arraySpecifierMatcher.group(2);
            } else {
                elementName = element;
                elementSpecifier = null;
            }
            if (!elementName.startsWith("@") && !elementName.equals("*")) {
                exprBuilder.append("/*[local-name()='" + elementName + "']");
            } else {
                exprBuilder.append("/" + elementName);
            }
            if (elementSpecifier == null || elementSpecifier.isEmpty()) continue;
            exprBuilder.append("[" + elementSpecifier + "]");
        }
        return exprBuilder.toString();
    }

    public static XPathExpression compileXPath(String xPath) throws XPathExpressionException {
        String localXPath = XmlHelper.globalXPathToLocalXPath(xPath);
        return XPath.compile(localXPath);
    }

    public static Document parseDocumentFromStream(InputStream is) {
        Document doc = null;
        try {
            doc = dBuilder.parse(is);
        }
        catch (IOException | SAXException e) {
            doc = null;
        }
        if (doc != null) {
            doc.getDocumentElement().normalize();
        }
        return doc;
    }

    public static Document removeFormattingNodes(Document doc) {
        NodeList empty;
        try {
            empty = (NodeList)XPath.evaluate("//text()[normalize-space(.) = '']", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Bad XPath expression to find all empty text nodes.");
            return null;
        }
        for (int i = 0; i < empty.getLength(); ++i) {
            Node node = empty.item(i);
            node.getParentNode().removeChild(node);
        }
        return doc;
    }

    public static String getUnformattedXml(InputStream is) {
        Document doc = XmlHelper.parseDocumentFromStream(is);
        return XmlHelper.getXmlFromDocument(XmlHelper.removeFormattingNodes(doc), false);
    }

    public static String getFormattedXml(InputStream is) {
        Document doc = XmlHelper.parseDocumentFromStream(is);
        return XmlHelper.getXmlFromDocument(doc, true);
    }

    public static String getXmlFromDocument(Document doc, boolean humanReadable) {
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            if (humanReadable) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to transform XML to String: ", (Throwable)ex);
            return null;
        }
    }

    public static Element getOrCreateElement(Document doc, Element parent, String nsUri, String nsName, String name, String attrName, String attrValue) {
        NodeList childList = nsUri == null ? parent.getElementsByTagName(name) : parent.getElementsByTagNameNS(nsUri, name);
        Element element = null;
        block0: for (int i = 0; i < childList.getLength(); ++i) {
            Node n = childList.item(i);
            if (n.getNodeType() != 1) continue;
            if (attrName != null && attrValue != null) {
                for (int ai = 0; ai < n.getAttributes().getLength(); ++ai) {
                    Attr a;
                    Node attr = n.getAttributes().item(ai);
                    if (attr.getNodeType() != 1 || !attrName.equals((a = (Attr)attr).getLocalName()) || !attrValue.equals(a.getValue())) continue;
                    element = (Element)n;
                    break block0;
                }
                continue;
            }
            element = (Element)n;
            break;
        }
        if (element == null) {
            if (nsUri == null || nsName == null) {
                element = doc.createElement(name);
            } else {
                element = doc.createElementNS(nsUri, name);
                element.setPrefix(nsName);
            }
            if (attrName != null && attrValue != null) {
                element.setAttribute(attrName, attrValue);
            }
            parent.appendChild(element);
        }
        return element;
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setIgnoringComments(true);
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Failed to initalize DOM parser with default configurations.");
        }
    }
}

