/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfigurationDocker;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationQemu;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVirtualBox;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVmware;
import org.openslx.virtualization.hardware.ConfigurationGroups;
import org.openslx.virtualization.hardware.VirtOptionValue;
import org.openslx.virtualization.virtualizer.Virtualizer;

public abstract class VirtualizationConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfiguration.class);
    private final Virtualizer virtualizer;
    protected final List<HardDisk> hdds = new ArrayList<HardDisk>();
    protected final List<OperatingSystem> osList;
    private OperatingSystem os = null;
    protected String displayName = null;
    protected boolean isMachineSnapshot;
    protected final List<ConfigurableOptionGroup> configurableOptions = new ArrayList<ConfigurableOptionGroup>();

    public OperatingSystem getOs() {
        return this.os;
    }

    public void setOs(OperatingSystem os) {
        this.os = os;
    }

    public List<HardDisk> getHdds() {
        return Collections.unmodifiableList(this.hdds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isMachineSnapshot() {
        return this.isMachineSnapshot;
    }

    public String getSuspendedFile() {
        return null;
    }

    public VirtualizationConfiguration(Virtualizer virtualizer, List<OperatingSystem> osList) {
        this.virtualizer = virtualizer;
        this.osList = osList == null ? new ArrayList<OperatingSystem>() : osList;
        List<Version> availables = this.getVirtualizer().getSupportedVersions();
        if (availables != null) {
            ArrayList<VirtOptionValue> list = new ArrayList<VirtOptionValue>();
            for (Version ver : availables) {
                list.add(new VersionOption(ver));
            }
            this.configurableOptions.add(new ConfigurableOptionGroup(ConfigurationGroups.HW_VERSION, list));
        }
        this.registerVirtualHW();
    }

    public static VirtualizationConfiguration getInstance(List<OperatingSystem> osList, File file) throws IOException {
        try {
            return new VirtualizationConfigurationVmware(osList, file);
        }
        catch (VirtualizationConfigurationException e) {
            LOGGER.debug("Not a VMware file", (Throwable)e);
            try {
                return new VirtualizationConfigurationVirtualBox(osList, file);
            }
            catch (VirtualizationConfigurationException e2) {
                LOGGER.debug("Not a VirtualBox file", (Throwable)e2);
                try {
                    return new VirtualizationConfigurationQemu(osList, file);
                }
                catch (VirtualizationConfigurationException e3) {
                    LOGGER.debug("Not a Libvirt file", (Throwable)e3);
                    try {
                        return new VirtualizationConfigurationDocker(osList, file);
                    }
                    catch (VirtualizationConfigurationException e4) {
                        LOGGER.debug("Not a tar.gz file, for docker container", (Throwable)e4);
                        LOGGER.error("Could not detect any known virtualizer format");
                        return null;
                    }
                }
            }
        }
    }

    public static VirtualizationConfiguration getInstance(List<OperatingSystem> osList, byte[] vmContent, int length) throws IOException, VirtualizationConfigurationException {
        try {
            return new VirtualizationConfigurationVmware(osList, vmContent, length);
        }
        catch (VirtualizationConfigurationException e) {
            LOGGER.debug("Not a VMware file", (Throwable)e);
            try {
                return new VirtualizationConfigurationDocker(osList, vmContent, length);
            }
            catch (VirtualizationConfigurationException e2) {
                LOGGER.debug("Not a tar.gz file, for docker container", (Throwable)e2);
                try {
                    return new VirtualizationConfigurationVirtualBox(osList, vmContent, length);
                }
                catch (VirtualizationConfigurationException e3) {
                    LOGGER.debug("Not a VirtualBox file", (Throwable)e3);
                    try {
                        return new VirtualizationConfigurationQemu(osList, vmContent, length);
                    }
                    catch (VirtualizationConfigurationException e4) {
                        LOGGER.debug("Not a Libvirt file", (Throwable)e4);
                        throw new VirtualizationConfigurationException("Unknown virtualizer config format");
                    }
                }
            }
        }
    }

    public abstract String getFileNameExtension();

    public abstract boolean addEmptyHddTemplate();

    public abstract boolean addHddTemplate(File var1, String var2, String var3);

    public abstract boolean addHddTemplate(String var1, String var2, String var3);

    public abstract boolean addDefaultNat();

    public abstract void setOs(String var1);

    public abstract boolean addDisplayName(String var1);

    public abstract boolean addRam(int var1);

    public abstract void addFloppy(int var1, String var2, boolean var3);

    public abstract boolean addCdrom(String var1);

    public abstract boolean addCpuCoreCount(int var1);

    public abstract void disableUsb();

    public abstract void setVirtualizerVersion(Version var1);

    public abstract Version getVirtualizerVersion();

    public abstract byte[] getConfigurationAsByteArray();

    public String getConfigurationAsString() {
        return new String(this.getConfigurationAsByteArray(), StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.getConfigurationAsString();
    }

    public abstract boolean addEthernet(EtherType var1);

    public Virtualizer getVirtualizer() {
        return this.virtualizer;
    }

    public abstract void validate() throws VirtualizationConfigurationException;

    public abstract void transformPrivacy() throws VirtualizationConfigurationException;

    public abstract void transformEditable() throws VirtualizationConfigurationException;

    public abstract void transformNonPersistent() throws VirtualizationConfigurationException;

    public abstract void registerVirtualHW();

    public List<ConfigurableOptionGroup> getConfigurableOptions() {
        return Collections.unmodifiableList(this.configurableOptions);
    }

    private class VersionOption
    extends VirtOptionValue {
        private final Version version;

        public VersionOption(Version version) {
            super(Integer.toString(version.getVersion()), version.getName());
            this.version = version;
        }

        @Override
        public boolean isActive() {
            try {
                return VirtualizationConfiguration.this.getVirtualizerVersion().equals(this.version);
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        @Override
        public void apply() {
            VirtualizationConfiguration.this.setVirtualizerVersion(this.version);
        }
    }

    public static class ConfigurableOptionGroup {
        public final ConfigurationGroups groupIdentifier;
        public final List<VirtOptionValue> availableOptions;

        public ConfigurableOptionGroup(ConfigurationGroups groupIdentifier, List<VirtOptionValue> availableOptions) {
            this.groupIdentifier = groupIdentifier;
            this.availableOptions = Collections.unmodifiableList(availableOptions);
        }

        public VirtOptionValue getSelected() {
            for (VirtOptionValue hw : this.availableOptions) {
                if (!hw.isActive()) continue;
                return hw;
            }
            return null;
        }
    }

    public static enum EtherType {
        NAT,
        BRIDGED,
        HOST_ONLY;

    }

    public static class HardDisk {
        public final String chipsetDriver;
        public final DriveBusType bus;
        public final String diskImage;

        public HardDisk(String chipsetDriver, DriveBusType bus, String diskImage) {
            this.chipsetDriver = chipsetDriver;
            this.bus = bus;
            this.diskImage = diskImage;
        }
    }

    public static enum DriveBusType {
        SCSI,
        IDE,
        SATA,
        NVME;

    }
}

