/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.virtualizer.VirtualizerDocker;

public class VirtualizationConfigurationDocker
extends VirtualizationConfiguration {
    private static final String FILE_NAME_EXTENSION = null;
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfigurationDocker.class);
    private byte[] containerDefinition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualizationConfigurationDocker(List<OperatingSystem> osList, File file) throws VirtualizationConfigurationException {
        super(new VirtualizerDocker(), osList);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            this.containerDefinition = new byte[(int)file.length()];
            bis.read(this.containerDefinition);
            this.checkIsTarGz();
        }
        catch (IOException | VirtualizationConfigurationException e) {
            LOGGER.error("Couldn't read dockerfile", (Throwable)e);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not close the input stream!");
            }
        }
    }

    public VirtualizationConfigurationDocker(List<OperatingSystem> osList, byte[] vmContent, int length) throws VirtualizationConfigurationException {
        super(new VirtualizerDocker(), osList);
        this.containerDefinition = vmContent;
        this.checkIsTarGz();
    }

    private void checkIsTarGz() throws VirtualizationConfigurationException {
        if (31 != this.containerDefinition[0] || -117 != this.containerDefinition[1]) {
            LOGGER.debug("Not Supported Content.");
            throw new VirtualizationConfigurationException("DockerMetaDataDummy: Not tar.gz encoded content!");
        }
    }

    @Override
    public void transformEditable() throws VirtualizationConfigurationException {
    }

    @Override
    public void transformPrivacy() throws VirtualizationConfigurationException {
    }

    @Override
    public boolean addEmptyHddTemplate() {
        return true;
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        return true;
    }

    @Override
    public boolean addHddTemplate(String diskImagePath, String hddMode, String redoDir) {
        return false;
    }

    @Override
    public boolean addDefaultNat() {
        return true;
    }

    @Override
    public void setOs(String vendorOsId) {
    }

    @Override
    public boolean addDisplayName(String name) {
        return true;
    }

    @Override
    public boolean addRam(int mem) {
        return true;
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
    }

    @Override
    public boolean addCdrom(String image) {
        return true;
    }

    @Override
    public boolean addCpuCoreCount(int nrOfCores) {
        return true;
    }

    @Override
    public void setVirtualizerVersion(Version type) {
    }

    @Override
    public Version getVirtualizerVersion() {
        return null;
    }

    @Override
    public byte[] getConfigurationAsByteArray() {
        return this.containerDefinition;
    }

    @Override
    public boolean addEthernet(VirtualizationConfiguration.EtherType type) {
        return true;
    }

    @Override
    public void transformNonPersistent() throws VirtualizationConfigurationException {
    }

    @Override
    public void registerVirtualHW() {
    }

    @Override
    public String getFileNameExtension() {
        return FILE_NAME_EXTENSION;
    }

    @Override
    public void validate() throws VirtualizationConfigurationException {
    }

    @Override
    public void disableUsb() {
    }
}

