/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.firmware.FirmwareException;
import org.openslx.firmware.QemuFirmwareUtil;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.domain.DomainUtils;
import org.openslx.libvirt.domain.device.BusType;
import org.openslx.libvirt.domain.device.ControllerUsb;
import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.Disk;
import org.openslx.libvirt.domain.device.DiskCdrom;
import org.openslx.libvirt.domain.device.DiskFloppy;
import org.openslx.libvirt.domain.device.DiskStorage;
import org.openslx.libvirt.domain.device.Graphics;
import org.openslx.libvirt.domain.device.GraphicsSpice;
import org.openslx.libvirt.domain.device.HostdevUsbDeviceAddress;
import org.openslx.libvirt.domain.device.Interface;
import org.openslx.libvirt.domain.device.RedirDevice;
import org.openslx.libvirt.domain.device.Sound;
import org.openslx.libvirt.domain.device.Video;
import org.openslx.libvirt.libosinfo.LibOsInfo;
import org.openslx.libvirt.libosinfo.os.Os;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.openslx.util.LevenshteinDistance;
import org.openslx.util.Util;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationQemuUtils;
import org.openslx.virtualization.hardware.ConfigurationGroups;
import org.openslx.virtualization.hardware.VirtOptionValue;
import org.openslx.virtualization.virtualizer.VirtualizerQemu;

public class VirtualizationConfigurationQemu
extends VirtualizationConfiguration {
    public static final String NETWORK_BRIDGE_LAN_DEFAULT = "br0";
    public static final String NETWORK_BRIDGE_NAT_DEFAULT = "nat1";
    public static final String NETWORK_BRIDGE_HOST_ONLY_DEFAULT = "vsw2";
    public static final String CDROM_DEFAULT_PHYSICAL_DRIVE = "/dev/sr0";
    public static final String FILE_NAME_EXTENSION = "xml";
    private Domain vmConfig = null;

    public VirtualizationConfigurationQemu(List<OperatingSystem> osList, File file) throws VirtualizationConfigurationException {
        super(new VirtualizerQemu(), osList);
        try {
            this.vmConfig = new Domain(file);
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
            throw new VirtualizationConfigurationException(e.getLocalizedMessage());
        }
        this.parseVmConfig();
    }

    public VirtualizationConfigurationQemu(List<OperatingSystem> osList, byte[] vmContent, int length) throws VirtualizationConfigurationException {
        super(new VirtualizerQemu(), osList);
        try {
            this.vmConfig = new Domain(new String(vmContent, 0, length, StandardCharsets.UTF_8));
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
            throw new VirtualizationConfigurationException(e.getLocalizedMessage());
        }
        this.parseVmConfig();
    }

    private void preconfigureUsb(boolean onlyIfAtLeastOne) {
        int port;
        int MAX_BUSES = 4;
        int MAX_DEV_PER_BUS = 16;
        int MIN_USB_REDIR_DEVS = 5;
        int devs = 0;
        byte[][] busPort = new byte[4][];
        for (int i = 0; i < busPort.length; ++i) {
            busPort[i] = new byte[16];
        }
        for (Device d : this.vmConfig.getDevices()) {
            HostdevUsbDeviceAddress addr;
            if (d.getDeviceBusType() == BusType.USB && d.getDeviceClass() == Device.DeviceClass.REDIRDEV && "spicevmc".equals(d.getXmlElementAttributeValue("type"))) {
                ++devs;
            }
            if ((addr = d.getUsbTarget()) == null) continue;
            int bus = addr.getUsbBus();
            port = addr.getUsbPort();
            if (bus < 0 || port <= 0 || bus >= busPort.length || port >= busPort[bus].length) continue;
            busPort[bus][port] = 1;
        }
        if (devs >= 5) {
            return;
        }
        for (ControllerUsb c : this.vmConfig.getUsbControllerDevices()) {
            int bus = c.getIndex();
            if (bus < 0 || bus >= busPort.length) continue;
            int ports = c.getPortCount();
            for (port = 1; port < ports; ++port) {
                if (busPort[bus][port] != 0) continue;
                RedirDevice dev = (RedirDevice)this.vmConfig.addDevice(new RedirDevice());
                dev.setSrcType(RedirDevice.SrcType.SPICEVMC);
                dev.setBusType(BusType.USB);
                dev.setUsbTarget(new HostdevUsbDeviceAddress(bus, port));
                if (++devs < 5) continue;
                return;
            }
        }
    }

    private void parseVmConfig() {
        this.displayName = this.vmConfig.getName();
        this.isMachineSnapshot = false;
        for (DiskStorage storageDiskDevice : this.vmConfig.getDiskStorageDevices()) {
            this.addHddMetaData(storageDiskDevice);
        }
        this.setOs(this.vmConfig.getLibOsInfoOsId());
    }

    private void addHddMetaData(DiskStorage storageDiskDevice) {
        String hddChipsetModel = null;
        VirtualizationConfiguration.DriveBusType hddChipsetBus = VirtualizationConfigurationQemuUtils.convertBusType(storageDiskDevice.getBusType());
        String hddImagePath = storageDiskDevice.getStorageSource();
        this.hdds.add(new VirtualizationConfiguration.HardDisk(hddChipsetModel, hddChipsetBus, hddImagePath));
    }

    private OperatingSystem detectOperatingSystem(String osId) {
        Os osLookup;
        OperatingSystem os = null;
        if (osId != null && !osId.isEmpty() && (osLookup = LibOsInfo.lookupOs(osId)) != null) {
            LevenshteinDistance distance = new LevenshteinDistance(2, 1, 1);
            int smallestDistance = Integer.MAX_VALUE;
            String osLookupOsName = osLookup.getName();
            int osArchSize = VirtualizationConfigurationQemuUtils.getOsArchSize(this.vmConfig.getOsArch());
            if (osArchSize > 0) {
                osLookupOsName = osLookupOsName + " (" + osArchSize + " Bit)";
            }
            for (OperatingSystem osCandidate : this.osList) {
                int currentDistance = distance.calculateDistance(osLookupOsName, osCandidate.getOsName());
                if (currentDistance >= smallestDistance) continue;
                smallestDistance = currentDistance;
                os = osCandidate;
            }
        }
        return os;
    }

    @Override
    public void transformEditable() throws VirtualizationConfigurationException {
    }

    public void transformOsLoader() throws VirtualizationConfigurationException {
        if ("efi".equalsIgnoreCase(this.vmConfig.getOsFirmware())) {
            this.vmConfig.setOsLoader(null);
            return;
        }
        String sourceOsLoader = this.vmConfig.getOsLoader();
        String sourceOsArch = this.vmConfig.getOsArch();
        String sourceOsMachine = this.vmConfig.getOsMachine();
        if (!Util.isEmptyString(sourceOsLoader)) {
            String targetOsLoader = null;
            try {
                targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoaderDefaultFwSpecDir(sourceOsLoader, sourceOsArch, sourceOsMachine);
            }
            catch (FirmwareException e) {
                throw new VirtualizationConfigurationException(e);
            }
            if (!Util.isEmptyString(targetOsLoader)) {
                this.vmConfig.setOsLoader(targetOsLoader);
            }
        }
    }

    @Override
    public boolean addEmptyHddTemplate() {
        return this.addHddTemplate("", null, null);
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        return this.addHddTemplate(diskImage.getAbsolutePath(), hddMode, redoDir);
    }

    @Override
    public boolean addHddTemplate(String diskImagePath, String hddMode, String redoDir) {
        int index = this.vmConfig.getDiskStorageDevices().size() - 1;
        index = index > 0 ? index : 0;
        return this.addHddTemplate(index, diskImagePath, hddMode, redoDir);
    }

    public boolean addHddTemplate(int index, String diskImagePath, String hddMode, String redoDir) {
        ArrayList<DiskStorage> storageDiskDevices = this.vmConfig.getDiskStorageDevices();
        DiskStorage storageDiskDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(storageDiskDevices, index);
        if (storageDiskDevice == null) {
            Disk.BusType devBusType = Disk.BusType.VIRTIO;
            String targetDevName = VirtualizationConfigurationQemuUtils.createDeviceName(this.vmConfig, devBusType);
            storageDiskDevice = this.vmConfig.addDiskStorageDevice();
            storageDiskDevice.setReadOnly(false);
            storageDiskDevice.setBusType(devBusType);
            storageDiskDevice.setTargetDevice(targetDevName);
            if (diskImagePath == null || diskImagePath.isEmpty()) {
                storageDiskDevice.removeStorage();
            } else {
                storageDiskDevice.setStorage(Disk.StorageType.FILE, diskImagePath);
            }
            this.addHddMetaData(storageDiskDevice);
        } else if (diskImagePath == null || diskImagePath.isEmpty()) {
            storageDiskDevice.removeStorage();
        } else {
            storageDiskDevice.setStorage(Disk.StorageType.FILE, diskImagePath);
        }
        return true;
    }

    @Override
    public boolean addDefaultNat() {
        return true;
    }

    @Override
    public void setOs(String vendorOsId) {
        OperatingSystem os = this.detectOperatingSystem(vendorOsId);
        this.setOs(os);
    }

    @Override
    public boolean addDisplayName(String name) {
        this.vmConfig.setName(name);
        boolean statusName = this.vmConfig.getName().equals(name);
        return statusName;
    }

    @Override
    public boolean addRam(int mem) {
        BigInteger memory = DomainUtils.decodeMemory(Integer.toString(mem), "MiB");
        this.vmConfig.setMemory(memory);
        this.vmConfig.setCurrentMemory(memory);
        boolean isMemorySet = this.vmConfig.getMemory().equals(memory);
        boolean isCurrentMemorySet = this.vmConfig.getCurrentMemory().equals(memory);
        return isMemorySet && isCurrentMemorySet;
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
        ArrayList<DiskFloppy> floppyDiskDevices = this.vmConfig.getDiskFloppyDevices();
        DiskFloppy floppyDiskDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(floppyDiskDevices, index);
        if (floppyDiskDevice == null) {
            Disk.BusType devBusType = Disk.BusType.FDC;
            String targetDevName = VirtualizationConfigurationQemuUtils.createDeviceName(this.vmConfig, devBusType);
            floppyDiskDevice = this.vmConfig.addDiskFloppyDevice();
            floppyDiskDevice.setBusType(devBusType);
            floppyDiskDevice.setTargetDevice(targetDevName);
            floppyDiskDevice.setReadOnly(readOnly);
            if (image == null || image.isEmpty()) {
                floppyDiskDevice.removeStorage();
            } else {
                floppyDiskDevice.setStorage(Disk.StorageType.FILE, image);
            }
        } else {
            floppyDiskDevice.setReadOnly(readOnly);
            if (image == null || image.isEmpty()) {
                floppyDiskDevice.removeStorage();
            } else {
                floppyDiskDevice.setStorage(Disk.StorageType.FILE, image);
            }
        }
    }

    @Override
    public boolean addCdrom(String image) {
        int index = this.vmConfig.getDiskCdromDevices().size() - 1;
        index = index > 0 ? index : 0;
        return this.addCdrom(index, image);
    }

    public boolean addCdrom(int index, String image) {
        ArrayList<DiskCdrom> cdromDiskDevices = this.vmConfig.getDiskCdromDevices();
        DiskCdrom cdromDiskDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(cdromDiskDevices, index);
        if (cdromDiskDevice == null) {
            Disk.BusType devBusType = Disk.BusType.SATA;
            String targetDevName = VirtualizationConfigurationQemuUtils.createDeviceName(this.vmConfig, devBusType);
            cdromDiskDevice = this.vmConfig.addDiskCdromDevice();
            cdromDiskDevice.setBusType(devBusType);
            cdromDiskDevice.setTargetDevice(targetDevName);
            cdromDiskDevice.setReadOnly(true);
            if (image == null) {
                cdromDiskDevice.setStorage(Disk.StorageType.BLOCK, CDROM_DEFAULT_PHYSICAL_DRIVE);
            } else if (image.isEmpty()) {
                cdromDiskDevice.removeStorage();
            } else {
                cdromDiskDevice.setStorage(Disk.StorageType.FILE, image);
            }
        } else {
            cdromDiskDevice.setReadOnly(true);
            if (image == null) {
                cdromDiskDevice.setStorage(Disk.StorageType.BLOCK, CDROM_DEFAULT_PHYSICAL_DRIVE);
            } else if (image.isEmpty()) {
                cdromDiskDevice.removeStorage();
            } else {
                cdromDiskDevice.setStorage(Disk.StorageType.FILE, image);
            }
        }
        return true;
    }

    @Override
    public boolean addCpuCoreCount(int nrOfCores) {
        this.vmConfig.setVCpu(nrOfCores);
        boolean isVCpuSet = this.vmConfig.getVCpu() == nrOfCores;
        return isVCpuSet;
    }

    @Override
    public void setVirtualizerVersion(Version type) {
        String osMachine;
        String osMachineName;
        if (type != null && (osMachineName = VirtualizationConfigurationQemuUtils.getOsMachineName(osMachine = this.vmConfig.getOsMachine())) != null && !osMachineName.isEmpty()) {
            String modifiedOsMachineVersion = VirtualizationConfigurationQemuUtils.getOsMachineVersion(type);
            String modifiedOsMachine = VirtualizationConfigurationQemuUtils.getOsMachine(osMachineName, modifiedOsMachineVersion);
            this.vmConfig.setOsMachine(modifiedOsMachine);
        }
    }

    @Override
    public Version getVirtualizerVersion() {
        String osMachine = this.vmConfig.getOsMachine();
        Version uncheckedVersion = VirtualizationConfigurationQemuUtils.getOsMachineVersion(osMachine);
        Version checkedVersion = uncheckedVersion == null ? null : Version.getInstanceByMajorMinorFromVersions(uncheckedVersion.getMajor(), uncheckedVersion.getMinor(), this.getVirtualizer().getSupportedVersions());
        return checkedVersion;
    }

    @Override
    public byte[] getConfigurationAsByteArray() {
        String configuration = this.vmConfig.toString();
        if (configuration == null) {
            return null;
        }
        return configuration.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean addEthernet(VirtualizationConfiguration.EtherType type) {
        int index = this.vmConfig.getInterfaceDevices().size() - 1;
        index = index > 0 ? index : 0;
        return this.addEthernet(index, type);
    }

    public boolean addEthernet(int index, VirtualizationConfiguration.EtherType type) {
        ArrayList<Interface> interfaceDevices = this.vmConfig.getInterfaceDevices();
        Interface interfaceDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(interfaceDevices, index);
        Interface.Model defaultNetworkDeviceModel = Interface.Model.VIRTIO_NET_PCI;
        if (interfaceDevice == null) {
            switch (type) {
                case BRIDGED: {
                    interfaceDevice = this.vmConfig.addInterfaceBridgeDevice();
                    interfaceDevice.setModel(defaultNetworkDeviceModel);
                    interfaceDevice.setSource(NETWORK_BRIDGE_LAN_DEFAULT);
                    break;
                }
                case HOST_ONLY: {
                    interfaceDevice = this.vmConfig.addInterfaceBridgeDevice();
                    interfaceDevice.setModel(defaultNetworkDeviceModel);
                    interfaceDevice.setSource(NETWORK_BRIDGE_HOST_ONLY_DEFAULT);
                    break;
                }
                case NAT: {
                    interfaceDevice = this.vmConfig.addInterfaceBridgeDevice();
                    interfaceDevice.setModel(defaultNetworkDeviceModel);
                    interfaceDevice.setSource(NETWORK_BRIDGE_NAT_DEFAULT);
                }
            }
        } else {
            switch (type) {
                case BRIDGED: {
                    interfaceDevice.setType(Interface.Type.BRIDGE);
                    interfaceDevice.setSource(NETWORK_BRIDGE_LAN_DEFAULT);
                    break;
                }
                case HOST_ONLY: {
                    interfaceDevice.setType(Interface.Type.BRIDGE);
                    interfaceDevice.setSource(NETWORK_BRIDGE_HOST_ONLY_DEFAULT);
                    break;
                }
                case NAT: {
                    interfaceDevice.setType(Interface.Type.BRIDGE);
                    interfaceDevice.setSource(NETWORK_BRIDGE_NAT_DEFAULT);
                }
            }
        }
        return true;
    }

    @Override
    public void transformNonPersistent() throws VirtualizationConfigurationException {
        this.preconfigureUsb(false);
    }

    @Override
    public void transformPrivacy() throws VirtualizationConfigurationException {
        this.vmConfig.removeDiskDevicesStorage();
        this.vmConfig.removeOsNvram();
    }

    @Override
    public void registerVirtualHW() {
        ArrayList<VirtOptionValue> list = new ArrayList<VirtOptionValue>();
        list.add(new QemuSoundCardModel(Sound.Model.ICH9, "(default)"));
        list.add(new QemuSoundCardModel(Sound.Model.SB16, "Sound Blaster 16"));
        list.add(new QemuSoundCardModel(Sound.Model.ES1370, "ES 1371"));
        list.add(new QemuSoundCardModel(Sound.Model.AC97, "Intel ICH Audio Codec 97"));
        list.add(new QemuSoundCardModel(Sound.Model.ICH9, "Intel Integrated HD Audio"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.SOUND_CARD_MODEL, list));
        list = new ArrayList();
        list.add(new QemuGfxModel(Video.Model.VGA, "VGA"));
        list.add(new QemuGfxModel(Video.Model.QXL, "QXL"));
        list.add(new QemuGfxModel(Video.Model.VMVGA, "VMware VGA"));
        list.add(new QemuGfxModel(Video.Model.VIRTIO, "virtio-gpu"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.GFX_MODEL, list));
        list = new ArrayList();
        list.add(new QemuGfxType("false", "2D"));
        list.add(new QemuGfxType("true", "3D"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.GFX_TYPE, list));
        list = new ArrayList();
        list.add(new QemuNicModel(0, Interface.Model.VIRTIO, "(default)"));
        list.add(new QemuNicModel(0, Interface.Model.PCNET, "PCnet-PCI II"));
        list.add(new QemuNicModel(0, Interface.Model.E1000, "Intel E1000 (PCI)"));
        list.add(new QemuNicModel(0, Interface.Model.E1000E, "Intel E1000e (PCI-Express)"));
        list.add(new QemuNicModel(0, Interface.Model.VMXNET3, "VMXnet 3"));
        list.add(new QemuNicModel(0, Interface.Model.VIRTIO_NET_PCI, "Paravirtualized Network"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.NIC_MODEL, list));
        list = new ArrayList();
        list.add(new QemuUsbSpeed(ControllerUsb.Model.NONE, "None"));
        list.add(new QemuUsbSpeed(ControllerUsb.Model.ICH9_UHCI1, "USB 1.1"));
        list.add(new QemuUsbSpeed(ControllerUsb.Model.ICH9_EHCI1, "USB 2.0"));
        list.add(new QemuUsbSpeed(ControllerUsb.Model.QEMU_XHCI, "USB 3.0"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.USB_SPEED, list));
    }

    @Override
    public String getFileNameExtension() {
        return FILE_NAME_EXTENSION;
    }

    @Override
    public void validate() throws VirtualizationConfigurationException {
        try {
            this.vmConfig.validateXml();
        }
        catch (LibvirtXmlValidationException e) {
            throw new VirtualizationConfigurationException(e.getLocalizedMessage());
        }
    }

    @Override
    public void disableUsb() {
        ArrayList<RedirDevice> list = this.vmConfig.getRedirectDevices();
        for (RedirDevice dev : list) {
            if (dev.getDeviceBusType() != BusType.USB) continue;
            dev.remove();
        }
    }

    class QemuUsbSpeed
    extends VirtOptionValue {
        public QemuUsbSpeed(ControllerUsb.Model id, String displayName) {
            super(id.toString(), displayName);
        }

        @Override
        public void apply() {
            ArrayList<ControllerUsb> usbControllerDevices = VirtualizationConfigurationQemu.this.vmConfig.getUsbControllerDevices();
            ControllerUsb.Model usbControllerModel = ControllerUsb.Model.fromString(this.id);
            if (usbControllerDevices.isEmpty()) {
                ControllerUsb usbControllerDevice = VirtualizationConfigurationQemu.this.vmConfig.addControllerUsbDevice();
                usbControllerDevice.setModel(usbControllerModel);
            } else {
                for (ControllerUsb usbControllerDevice : usbControllerDevices) {
                    usbControllerDevice.setModel(usbControllerModel);
                }
            }
        }

        @Override
        public boolean isActive() {
            ArrayList<ControllerUsb> usbControllerDevices = VirtualizationConfigurationQemu.this.vmConfig.getUsbControllerDevices();
            for (ControllerUsb usbControllerDevice : usbControllerDevices) {
                ControllerUsb.Model usbControllerModel = usbControllerDevice.getModel();
                if (!usbControllerModel.toString().equals(this.id)) continue;
                return true;
            }
            return false;
        }
    }

    class QemuSoundCardModel
    extends VirtOptionValue {
        public QemuSoundCardModel(Sound.Model id, String displayName) {
            super(id.toString(), displayName);
        }

        @Override
        public void apply() {
            ArrayList<Sound> soundDevices = VirtualizationConfigurationQemu.this.vmConfig.getSoundDevices();
            Sound.Model soundDeviceModel = Sound.Model.fromString(this.id);
            if (soundDevices.isEmpty()) {
                Sound soundDevice = VirtualizationConfigurationQemu.this.vmConfig.addSoundDevice();
                soundDevice.setModel(soundDeviceModel);
            } else {
                for (Sound soundDevice : soundDevices) {
                    soundDevice.setModel(soundDeviceModel);
                }
            }
        }

        @Override
        public boolean isActive() {
            ArrayList<Sound> soundDevices = VirtualizationConfigurationQemu.this.vmConfig.getSoundDevices();
            if (soundDevices.isEmpty()) {
                return Util.isEmptyString(this.id);
            }
            Sound.Model soundDeviceModel = soundDevices.get(0).getModel();
            return soundDeviceModel != null && soundDeviceModel.toString().equals(this.id);
        }
    }

    class QemuNicModel
    extends VirtOptionValue {
        private final int cardIndex;

        public QemuNicModel(int cardIndex, Interface.Model model, String displayName) {
            super(model.toString(), displayName);
            this.cardIndex = cardIndex;
        }

        @Override
        public void apply() {
            ArrayList<Interface> networkDevices = VirtualizationConfigurationQemu.this.vmConfig.getInterfaceDevices();
            Interface networkDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(networkDevices, this.cardIndex);
            if (networkDevice != null) {
                networkDevice.setModel(Interface.Model.fromString(this.id));
            }
        }

        @Override
        public boolean isActive() {
            ArrayList<Interface> networkDevices = VirtualizationConfigurationQemu.this.vmConfig.getInterfaceDevices();
            Interface networkDevice = VirtualizationConfigurationQemuUtils.getArrayIndex(networkDevices, this.cardIndex);
            if (networkDevice == null) {
                return Util.isEmptyString(this.id);
            }
            Interface.Model networkDeviceModel = networkDevice.getModel();
            if (networkDeviceModel == null) {
                return Util.isEmptyString(this.id);
            }
            return networkDeviceModel.toString().equals(this.id);
        }
    }

    class QemuGfxType
    extends VirtOptionValue {
        public QemuGfxType(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            ArrayList<Graphics> graphicDevices = VirtualizationConfigurationQemu.this.vmConfig.getGraphicDevices();
            ArrayList<Video> videoDevices = VirtualizationConfigurationQemu.this.vmConfig.getVideoDevices();
            boolean accelerationEnabled = this.id.equals("true");
            boolean acceleratedGraphicsAvailable = false;
            if (graphicDevices.isEmpty()) {
                GraphicsSpice graphicSpiceDevice = VirtualizationConfigurationQemu.this.vmConfig.addGraphicsSpiceDevice();
                graphicSpiceDevice.setOpenGl(true);
                acceleratedGraphicsAvailable = true;
            } else {
                for (Graphics graphicDevice : graphicDevices) {
                    if (!(graphicDevice instanceof GraphicsSpice)) continue;
                    ((GraphicsSpice)GraphicsSpice.class.cast(graphicDevice)).setOpenGl(true);
                    acceleratedGraphicsAvailable = true;
                }
            }
            if (acceleratedGraphicsAvailable) {
                if (videoDevices.isEmpty()) {
                    Video videoDevice = VirtualizationConfigurationQemu.this.vmConfig.addVideoDevice();
                    videoDevice.setModel(Video.Model.VIRTIO);
                    videoDevice.set2DAcceleration(true);
                    videoDevice.set3DAcceleration(true);
                } else {
                    for (Video videoDevice : videoDevices) {
                        if (videoDevice.getModel() != Video.Model.VIRTIO) continue;
                        videoDevice.set2DAcceleration(accelerationEnabled);
                        videoDevice.set3DAcceleration(accelerationEnabled);
                    }
                }
            }
        }

        @Override
        public boolean isActive() {
            ArrayList<Graphics> graphicsDevices = VirtualizationConfigurationQemu.this.vmConfig.getGraphicDevices();
            ArrayList<Video> videoDevices = VirtualizationConfigurationQemu.this.vmConfig.getVideoDevices();
            boolean acceleratedGraphicsAvailable = false;
            boolean acceleratedVideoDevAvailable = false;
            for (Graphics graphicDevice : graphicsDevices) {
                if (!(graphicDevice instanceof GraphicsSpice)) continue;
                acceleratedGraphicsAvailable = true;
                break;
            }
            for (Video videoDevice : videoDevices) {
                if (videoDevice.getModel() != Video.Model.VIRTIO) continue;
                acceleratedVideoDevAvailable = true;
                break;
            }
            if (acceleratedGraphicsAvailable && acceleratedVideoDevAvailable) {
                return this.id.equals("true");
            }
            return this.id.equals("false");
        }
    }

    class QemuGfxModel
    extends VirtOptionValue {
        public QemuGfxModel(Video.Model model, String displayName) {
            super(model.toString(), displayName);
        }

        @Override
        public void apply() {
            ArrayList<Video> videoDevices = VirtualizationConfigurationQemu.this.vmConfig.getVideoDevices();
            if (videoDevices.isEmpty()) {
                Video videoDevice = VirtualizationConfigurationQemu.this.vmConfig.addVideoDevice();
                videoDevice.setModel(Video.Model.fromString(this.getId()));
                videoDevice.set2DAcceleration(false);
                videoDevice.set3DAcceleration(false);
            } else {
                for (Video videoDevice : videoDevices) {
                    videoDevice.removeXmlElement("model");
                    videoDevice.setModel(Video.Model.fromString(this.getId()));
                }
            }
        }

        @Override
        public boolean isActive() {
            ArrayList<Video> videoDevices = VirtualizationConfigurationQemu.this.vmConfig.getVideoDevices();
            boolean isActive = true;
            for (Video videoDevice : videoDevices) {
                if (videoDevice.getModel().toString().equals(this.getId())) continue;
                isActive = false;
                break;
            }
            return isActive;
        }
    }
}

