/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.domain.device.Disk;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;

public class VirtualizationConfigurationQemuUtils {
    private static final String OS_MACHINE_NAME_VERSION_SEPARATOR = "-";

    public static VirtualizationConfiguration.DriveBusType convertBusType(Disk.BusType busType) {
        VirtualizationConfiguration.DriveBusType type = null;
        if (busType == null) {
            return null;
        }
        switch (busType) {
            case IDE: {
                type = VirtualizationConfiguration.DriveBusType.IDE;
                break;
            }
            case SATA: {
                type = VirtualizationConfiguration.DriveBusType.SATA;
                break;
            }
            case SCSI: {
                type = VirtualizationConfiguration.DriveBusType.SCSI;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    public static Disk.BusType convertBusType(VirtualizationConfiguration.DriveBusType busType) {
        Disk.BusType type = null;
        switch (busType) {
            case IDE: {
                type = Disk.BusType.IDE;
                break;
            }
            case NVME: {
                type = null;
                break;
            }
            case SATA: {
                type = Disk.BusType.SATA;
                break;
            }
            case SCSI: {
                type = Disk.BusType.SCSI;
            }
        }
        return type;
    }

    public static <T> T getArrayIndex(ArrayList<T> array, int index) {
        T ret;
        try {
            ret = array.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            ret = null;
        }
        return ret;
    }

    private static String createAlphabeticalDeviceName(String devicePrefix, int deviceNumber) {
        if (deviceNumber < 0 || deviceNumber >= 25) {
            String errorMsg = "Device number is out of range to be able to create a valid device name.";
            throw new IllegalArgumentException(errorMsg);
        }
        return devicePrefix + Character.valueOf((char)(97 + deviceNumber)).toString();
    }

    public static String createDeviceName(Domain config, Disk.BusType type) throws IllegalArgumentException {
        String devicePrefix;
        switch (type) {
            case FDC: {
                devicePrefix = "fd";
                break;
            }
            case IDE: {
                devicePrefix = "hd";
                break;
            }
            case SATA: {
                devicePrefix = "sd";
                break;
            }
            case VIRTIO: {
                devicePrefix = "vd";
                break;
            }
            default: {
                return null;
            }
        }
        Predicate<Disk> bySpecifiedBusType = d -> d.getBusType() == type;
        int deviceNumber = Long.valueOf(config.getDiskDevices().stream().filter(bySpecifiedBusType).count()).intValue();
        return VirtualizationConfigurationQemuUtils.createAlphabeticalDeviceName(devicePrefix, deviceNumber);
    }

    private static OsMachineNameAndVersion parseOsMachineNameAndVersion(String osMachine) {
        Version osMachineVersion;
        String osMachineName;
        if (osMachine == null || osMachine.isEmpty()) {
            osMachineName = null;
            osMachineVersion = null;
        } else {
            Pattern osMachineNameAndVersionPattern = Pattern.compile("^([a-z0-9\\-]+)-([0-9]+).([0-9]+)$");
            Matcher osMachineNameAndVersionMatcher = osMachineNameAndVersionPattern.matcher(osMachine);
            boolean matches = osMachineNameAndVersionMatcher.find();
            if (matches) {
                osMachineName = osMachineNameAndVersionMatcher.group(1);
                String osMachineMajorString = osMachineNameAndVersionMatcher.group(2);
                String osMachineMinorString = osMachineNameAndVersionMatcher.group(3);
                short osMachineMajor = Short.valueOf(osMachineMajorString);
                short osMachineMinor = Short.valueOf(osMachineMinorString);
                osMachineVersion = new Version(osMachineMajor, osMachineMinor);
            } else {
                osMachineName = null;
                osMachineVersion = null;
            }
        }
        return new OsMachineNameAndVersion(osMachineName, osMachineVersion);
    }

    public static String getOsMachineName(String osMachine) {
        OsMachineNameAndVersion machineNameAndVersion = VirtualizationConfigurationQemuUtils.parseOsMachineNameAndVersion(osMachine);
        return machineNameAndVersion.getOsMachineName();
    }

    public static Version getOsMachineVersion(String osMachine) {
        OsMachineNameAndVersion machineNameAndVersion = VirtualizationConfigurationQemuUtils.parseOsMachineNameAndVersion(osMachine);
        return machineNameAndVersion.getOsMachineVersion();
    }

    public static String getOsMachine(String osMachineName, String osMachineVersion) {
        return osMachineName + OS_MACHINE_NAME_VERSION_SEPARATOR + osMachineVersion;
    }

    public static String getOsMachineVersion(Version version) {
        return String.format("%d.%d", version.getMajor(), version.getMinor());
    }

    public static int getOsArchSize(String osArch) {
        int archSize;
        if (osArch == null || osArch.isEmpty()) {
            archSize = 0;
        } else {
            switch (osArch) {
                case "alpha": {
                    archSize = 64;
                    break;
                }
                case "armv6l": {
                    archSize = 32;
                    break;
                }
                case "armv7l": {
                    archSize = 32;
                    break;
                }
                case "aarch64": {
                    archSize = 64;
                    break;
                }
                case "cris": {
                    archSize = 32;
                    break;
                }
                case "i686": {
                    archSize = 32;
                    break;
                }
                case "m68k": {
                    archSize = 32;
                    break;
                }
                case "microblaze": {
                    archSize = 32;
                    break;
                }
                case "microblazeel": {
                    archSize = 32;
                    break;
                }
                case "mips": {
                    archSize = 32;
                    break;
                }
                case "mipsel": {
                    archSize = 32;
                    break;
                }
                case "mips64": {
                    archSize = 64;
                    break;
                }
                case "mips64el": {
                    archSize = 64;
                    break;
                }
                case "ppc": {
                    archSize = 32;
                    break;
                }
                case "ppc64": {
                    archSize = 64;
                    break;
                }
                case "ppc64le": {
                    archSize = 64;
                    break;
                }
                case "riscv32": {
                    archSize = 32;
                    break;
                }
                case "riscv64": {
                    archSize = 64;
                    break;
                }
                case "s390x": {
                    archSize = 64;
                    break;
                }
                case "sh4": {
                    archSize = 32;
                    break;
                }
                case "sh4eb": {
                    archSize = 64;
                    break;
                }
                case "sparc": {
                    archSize = 32;
                    break;
                }
                case "sparc64": {
                    archSize = 64;
                    break;
                }
                case "x86_64": {
                    archSize = 64;
                    break;
                }
                case "xtensa": {
                    archSize = 32;
                    break;
                }
                case "xtensaeb": {
                    archSize = 32;
                    break;
                }
                default: {
                    archSize = 0;
                }
            }
        }
        return archSize;
    }

    static class OsMachineNameAndVersion {
        private final String osMachineName;
        private final Version osMachineVersion;

        public OsMachineNameAndVersion(String osMachineName, Version osMachineVersion) {
            this.osMachineName = osMachineName;
            this.osMachineVersion = osMachineVersion;
        }

        public String getOsMachineName() {
            return this.osMachineName;
        }

        public Version getOsMachineVersion() {
            return this.osMachineVersion;
        }
    }
}

