/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.util.Util;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationUtils;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVirtualboxFileFormat;
import org.openslx.virtualization.hardware.ConfigurationGroups;
import org.openslx.virtualization.hardware.VirtOptionValue;
import org.openslx.virtualization.virtualizer.VirtualizerVirtualBox;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualizationConfigurationVirtualBox
extends VirtualizationConfiguration {
    public static final String FILE_NAME_EXTENSION = "vbox";
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfigurationVirtualBox.class);
    private final VirtualizationConfigurationVirtualboxFileFormat config;

    public VirtualizationConfigurationVirtualBox(List<OperatingSystem> osList, File file) throws IOException, VirtualizationConfigurationException {
        super(new VirtualizerVirtualBox(), osList);
        this.config = new VirtualizationConfigurationVirtualboxFileFormat(file);
        this.init();
    }

    public VirtualizationConfigurationVirtualBox(List<OperatingSystem> osList, byte[] vmContent, int length) throws IOException, VirtualizationConfigurationException {
        super(new VirtualizerVirtualBox(), osList);
        this.config = new VirtualizationConfigurationVirtualboxFileFormat(vmContent, length);
        this.init();
    }

    private void init() {
        this.displayName = this.config.getDisplayName();
        this.setOs(this.config.getOsName());
        this.isMachineSnapshot = this.config.isMachineSnapshot();
        for (VirtualizationConfiguration.HardDisk hardDisk : this.config.getHdds()) {
            this.hdds.add(hardDisk);
        }
    }

    private void disableEnhancedNetworkAdapters() {
        NodeList disableAdapters = this.config.findNodes("/VirtualBox/Machine/Hardware/Network/Adapter[not(@slot='0')]");
        if (disableAdapters != null) {
            for (int i = 0; i < disableAdapters.getLength(); ++i) {
                Element disableAdapter = (Element)disableAdapters.item(i);
                disableAdapter.setAttribute("enabled", "false");
            }
        }
    }

    private void removeEnhancedNetworkAdapters() {
        NodeList removeAdapters = this.config.findNodes("/VirtualBox/Machine/Hardware/Network/Adapter[not(@slot='0')]");
        if (removeAdapters != null) {
            for (int i = 0; i < removeAdapters.getLength(); ++i) {
                Node removeAdapter = removeAdapters.item(i);
                removeAdapter.getParentNode().removeChild(removeAdapter);
            }
        }
    }

    @Override
    public void transformEditable() throws VirtualizationConfigurationException {
        this.disableEnhancedNetworkAdapters();
    }

    @Override
    public void transformPrivacy() throws VirtualizationConfigurationException {
        this.config.addPlaceHolders();
    }

    @Override
    public byte[] getConfigurationAsByteArray() {
        return this.config.toString(true).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean addEmptyHddTemplate() {
        return this.addHddTemplate("[dummy]", "[dummy]", "[dummy]");
    }

    @Override
    public boolean addHddTemplate(String diskImage, String hddMode, String redoDir) {
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "location", diskImage, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        this.config.changeAttribute("/VirtualBox/Machine", "snapshotFolder", redoDir, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        return true;
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        String diskImagePath = diskImage.getName();
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "location", diskImagePath, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        UUID newhdduuid = UUID.randomUUID();
        String vboxUUid = "{" + newhdduuid.toString() + "}";
        this.config.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "uuid", vboxUUid, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        this.config.changeAttribute(this.config.storageControllersPath() + "/StorageController/AttachedDevice/Image", "uuid", vboxUUid, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(newhdduuid.getMostSignificantBits());
        buffer.putLong(newhdduuid.getLeastSignificantBits());
        byte[] oldOrder = buffer.array();
        byte[] bytesToWrite = Arrays.copyOf(oldOrder, oldOrder.length);
        int[] offsets = new int[]{3, 2, 1, 0, 5, 4, 7, 6};
        for (int index = 0; index < 8; ++index) {
            bytesToWrite[index] = oldOrder[offsets[index]];
        }
        try (RandomAccessFile file = new RandomAccessFile(diskImage, "rw");){
            file.seek(392L);
            file.write(bytesToWrite, 0, 16);
        }
        catch (Exception e) {
            LOGGER.warn("could not patch new uuid in the vdi", (Throwable)e);
        }
        UUID newMachineUuid = UUID.randomUUID();
        if (newMachineUuid.equals(newhdduuid)) {
            LOGGER.warn("The new Machine UUID is the same as the new HDD UUID; tying again...this vm might not start");
            newMachineUuid = UUID.randomUUID();
        }
        String machineUUid = "{" + newMachineUuid.toString() + "}";
        return this.config.changeAttribute("/VirtualBox/Machine", "uuid", machineUUid, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
    }

    @Override
    public boolean addDefaultNat() {
        boolean status;
        Node adapterSlot0 = this.config.findNodes("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']").item(0);
        if (adapterSlot0 != null) {
            NodeList adapterSlot0SettingNodes = adapterSlot0.getChildNodes();
            while (adapterSlot0.getChildNodes().getLength() > 0) {
                adapterSlot0.removeChild(adapterSlot0SettingNodes.item(0));
            }
            if (this.config.addNewNode("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']", "NAT") == null) {
                LOGGER.error("Failed to set network adapter to NAT.");
                status = false;
            } else {
                status = this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']", "MACAddress", "080027B86D12", VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
            }
        } else {
            status = false;
        }
        return status;
    }

    @Override
    public void setOs(String vendorOsId) {
        this.config.changeAttribute("/VirtualBox/Machine", "OSType", vendorOsId, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
        OperatingSystem os = VirtualizationConfigurationUtils.getOsOfVirtualizerFromList(this.osList, "virtualbox", vendorOsId);
        this.setOs(os);
    }

    @Override
    public boolean addDisplayName(String name) {
        return this.config.changeAttribute("/VirtualBox/Machine", "name", name, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
    }

    @Override
    public boolean addRam(int mem) {
        return this.config.changeAttribute("/VirtualBox/Machine/Hardware/Memory", "RAMSize", Integer.toString(mem), VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
        Element floppyDevice;
        Element floppyController = null;
        NodeList matches = this.config.findNodes(this.config.storageControllersPath() + "/StorageController[@name='Floppy']");
        if (matches == null || matches.getLength() == 0) {
            floppyController = this.config.addNewNode(this.config.storageControllersPath(), "StorageController");
            if (floppyController == null) {
                LOGGER.error("Failed to add <Image> to floppy device.");
                return;
            }
            floppyController.setAttribute("name", "Floppy");
            floppyController.setAttribute("type", "I82078");
            floppyController.setAttribute("PortCount", "1");
            floppyController.setAttribute("useHostIOCache", "true");
            floppyController.setAttribute("Bootable", "false");
        }
        if (matches.getLength() > 1) {
            LOGGER.error("Multiple floppy controllers detected, this should never happen! ");
            return;
        }
        if (floppyController == null) {
            floppyController = (Element)matches.item(0);
        }
        if ((floppyDevice = this.config.addNewNode(floppyController, "AttachedDevice")) == null) {
            LOGGER.error("Failed to add <Image> to floppy device.");
            return;
        }
        floppyDevice.setAttribute("type", "Floppy");
        floppyDevice.setAttribute("hotpluggable", "false");
        floppyDevice.setAttribute("port", "0");
        floppyDevice.setAttribute("device", Integer.toString(index));
        if (image != null) {
            Element floppyImage = this.config.addNewNode(floppyDevice, "Image");
            if (floppyImage == null) {
                LOGGER.error("Failed to add <Image> to floppy device.");
                return;
            }
            floppyImage.setAttribute("uuid", "[dummy]");
            Element floppyImages = this.config.addNewNode("/VirtualBox/Machine/MediaRegistry", "FloppyImages");
            if (floppyImages == null) {
                LOGGER.error("Failed to add <FloppyImages> to media registry.");
                return;
            }
            Element floppyImageReg = this.config.addNewNode("/VirtualBox/Machine/MediaRegistry/FloppyImages", "Image");
            if (floppyImageReg == null) {
                LOGGER.error("Failed to add <Image> to floppy images in the media registry.");
                return;
            }
            floppyImageReg.setAttribute("uuid", "[dummy]");
            floppyImageReg.setAttribute("location", "[dummy]");
        }
    }

    @Override
    public boolean addCdrom(String image) {
        return false;
    }

    @Override
    public boolean addCpuCoreCount(int nrOfCores) {
        return this.config.changeAttribute("/VirtualBox/Machine/Hardware/CPU", "count", Integer.toString(nrOfCores), VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
    }

    @Override
    public void setVirtualizerVersion(Version type) {
    }

    public Version getConfigurationVersion() {
        return this.config.getVersion();
    }

    @Override
    public Version getVirtualizerVersion() {
        return null;
    }

    @Override
    public void registerVirtualHW() {
        ArrayList<VirtOptionValue> list = new ArrayList<VirtOptionValue>();
        list.add(new VBoxSoundCardModel("AC97", "None"));
        list.add(new VBoxSoundCardModel("SB16", "Sound Blaster 16"));
        list.add(new VBoxSoundCardModel("HDA", "Intel Integrated HD Audio"));
        list.add(new VBoxSoundCardModel("AC97", "Intel ICH Audio Codec 97"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.SOUND_CARD_MODEL, list));
        list = new ArrayList();
        list.add(new VBoxAccel3D("true", "3D"));
        list.add(new VBoxAccel3D("false", "2D"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.GFX_TYPE, list));
        list = new ArrayList();
        list.add(new VBoxNicModel(0, "", "No Network Card"));
        list.add(new VBoxNicModel(0, "Am79C970A", "PCnet-PCI II"));
        list.add(new VBoxNicModel(0, "Am79C973", "PCnet-FAST III"));
        list.add(new VBoxNicModel(0, "82540EM", "Intel PRO/1000 MT Desktop"));
        list.add(new VBoxNicModel(0, "82543GC", "Intel PRO/1000 T Server"));
        list.add(new VBoxNicModel(0, "82545EM", "Intel PRO/1000 MT Server"));
        list.add(new VBoxNicModel(0, "virtio", "Paravirtualized Network"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.NIC_MODEL, list));
        list = new ArrayList();
        list.add(new VBoxUsbSpeed(null, "None"));
        list.add(new VBoxUsbSpeed("OHCI", "USB 1.1"));
        list.add(new VBoxUsbSpeed("EHCI", "USB 2.0"));
        list.add(new VBoxUsbSpeed("XHCI", "USB 3.0"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.USB_SPEED, list));
    }

    @Override
    public boolean addEthernet(VirtualizationConfiguration.EtherType type) {
        Element hostOnlyInterfaceNode = this.config.addNewNode("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']", "HostOnlyInterface");
        if (hostOnlyInterfaceNode == null) {
            LOGGER.error("Failed to create node for HostOnlyInterface.");
            return false;
        }
        return this.config.addAttributeToNode(hostOnlyInterfaceNode, "name", EthernetType.valueOf((String)type.name()).vnet);
    }

    @Override
    public void transformNonPersistent() throws VirtualizationConfigurationException {
        this.config.setExtraData("GUI/LastCloseAction", "PowerOff");
        this.config.setExtraData("GUI/RestrictedRuntimeHelpMenuActions", "All");
        this.config.setExtraData("GUI/RestrictedRuntimeMachineMenuActions", "TakeSnapshot,Pause,SaveState");
        this.config.setExtraData("GUI/RestrictedRuntimeMenus", "Help");
        this.config.setExtraData("GUI/PreventSnapshotOperations", "true");
        this.config.setExtraData("GUI/PreventApplicationUpdate", "true");
        this.config.setExtraData("GUI/RestrictedCloseActions", "SaveState,PowerOffRestoringSnapshot,Detach");
        this.removeEnhancedNetworkAdapters();
    }

    @Override
    public String getFileNameExtension() {
        return FILE_NAME_EXTENSION;
    }

    @Override
    public void validate() throws VirtualizationConfigurationException {
        this.config.validate();
    }

    @Override
    public void disableUsb() {
        new VBoxUsbSpeed(null, "None").apply();
    }

    class VBoxUsbSpeed
    extends VirtOptionValue {
        public VBoxUsbSpeed(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVirtualBox.this.config.removeNodes("/VirtualBox/Machine/Hardware", "USB");
            if (Util.isEmptyString(this.id)) {
                Element node = VirtualizationConfigurationVirtualBox.this.config.createNodeRecursive("/VirtualBox/OpenSLX/USB");
                if (node != null) {
                    node.setAttribute("disabled", "true");
                }
                return;
            }
            Element node = VirtualizationConfigurationVirtualBox.this.config.createNodeRecursive("/VirtualBox/Machine/Hardware/USB/Controllers/Controller");
            node.setAttribute("type", this.id);
            node.setAttribute("name", this.id);
            if (this.id.equals("EHCI")) {
                node = VirtualizationConfigurationVirtualBox.this.config.addNewNode("/VirtualBox/Machine/Hardware/USB/Controllers", "Controller");
                node.setAttribute("type", "OHCI");
                node.setAttribute("name", "OHCI");
            }
        }

        @Override
        public boolean isActive() {
            NodeList nodes = VirtualizationConfigurationVirtualBox.this.config.findNodes("/VirtualBox/Machine/Hardware/USB/Controllers/Controller/@type");
            LOGGER.info("Found USB attribute nodes:" + nodes.getLength());
            boolean ohci = false;
            boolean ehci = false;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 2) {
                    LOGGER.info("Not ATTRIBUTE type (" + nodes.item(i).getClass().getSimpleName() + ")");
                    continue;
                }
                String type = ((Attr)nodes.item(i)).getValue();
                LOGGER.info("Found USB node with type " + type);
                if (type.equals("EHCI")) {
                    ehci = true;
                    continue;
                }
                if (type.equals("OHCI")) {
                    ohci = true;
                    continue;
                }
                if (!type.equals(this.id)) continue;
                return true;
            }
            if (ehci && "EHCI".equals(this.id)) {
                return true;
            }
            if (ohci && !ehci && "OHCI".equals(this.id)) {
                return true;
            }
            if (VirtualizationConfigurationVirtualBox.this.config.findNodes("/VirtualBox/OpenSLX/USB/@disabled").getLength() > 0) {
                return Util.isEmptyString(this.id);
            }
            return false;
        }
    }

    class VBoxNicModel
    extends VirtOptionValue {
        private final int cardIndex;

        public VBoxNicModel(int cardIndex, String id, String displayName) {
            super(id, displayName);
            this.cardIndex = cardIndex;
        }

        @Override
        public void apply() {
            String index = Integer.toString(this.cardIndex);
            String dev = this.id;
            boolean present = true;
            if ("".equals(this.id)) {
                dev = "Am79C970A";
                present = false;
            }
            VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='" + index + "']", "enabled", Boolean.toString(present), VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
            VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/Network/Adapter[@slot='" + index + "']", "type", dev, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
        }

        @Override
        public boolean isActive() {
            Element x = (Element)VirtualizationConfigurationVirtualBox.this.config.findNodes("/VirtualBox/Machine/Hardware/Network/Adapter").item(0);
            if (!x.hasAttribute("enabled") || x.hasAttribute("enabled") && x.getAttribute("enabled").equalsIgnoreCase("false")) {
                return Util.isEmptyString(this.id);
            }
            if (!x.hasAttribute("type")) {
                return "Am79C973".equals(this.id);
            }
            return x.getAttribute("type").equals(this.id);
        }
    }

    class VBoxAccel3D
    extends VirtOptionValue {
        public VBoxAccel3D(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/Display", "accelerate3D", this.id, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.EXACTLY_ONE);
        }

        @Override
        public boolean isActive() {
            Element x = (Element)VirtualizationConfigurationVirtualBox.this.config.findNodes("/VirtualBox/Machine/Hardware/Display").item(0);
            String val = "false";
            if (x.hasAttribute("accelerate3D")) {
                val = x.getAttribute("accelerate3D");
            }
            return val.equalsIgnoreCase(this.id);
        }
    }

    class VBoxSoundCardModel
    extends VirtOptionValue {
        public VBoxSoundCardModel(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            if (Util.isEmptyString(this.id)) {
                VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/AudioAdapter", "enabled", "false", VirtualizationConfigurationVirtualboxFileFormat.MatchMode.MULTIPLE);
                return;
            }
            VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/AudioAdapter", "enabled", "true", VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
            VirtualizationConfigurationVirtualBox.this.config.changeAttribute("/VirtualBox/Machine/Hardware/AudioAdapter", "controller", this.id, VirtualizationConfigurationVirtualboxFileFormat.MatchMode.FIRST_ONLY);
        }

        @Override
        public boolean isActive() {
            Element x = (Element)VirtualizationConfigurationVirtualBox.this.config.findNodes("/VirtualBox/Machine/Hardware/AudioAdapter").item(0);
            if (!x.hasAttribute("enabled") || x.hasAttribute("enabled") && x.getAttribute("enabled").equals("false")) {
                return Util.isEmptyString(this.id);
            }
            String val = "AC97";
            if (x.hasAttribute("controller")) {
                val = x.getAttribute("controller");
            }
            return val.equals(this.id);
        }
    }

    public static enum EthernetType {
        NAT("vboxnet1"),
        BRIDGED("vboxnet0"),
        HOST_ONLY("vboxnet2");

        public final String vnet;

        private EthernetType(String vnet) {
            this.vnet = vnet;
        }
    }
}

