/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.util.Util;
import org.openslx.virtualization.configuration.KeyValuePair;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;

public class VirtualizationConfigurationVmwareFileFormat {
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfigurationVmwareFileFormat.class);
    private Map<String, ConfigEntry> entries = new TreeMap<String, ConfigEntry>(String.CASE_INSENSITIVE_ORDER);
    private static final Pattern settingMatcher1 = Pattern.compile("^\\s*(#?[a-z0-9\\.\\:_]+)\\s*=\\s*\"(.*)\"\\s*$", 2);
    private static final Pattern settingMatcher2 = Pattern.compile("^\\s*(#?[a-z0-9\\.\\:_]+)\\s*=\\s*([^\"]*)\\s*$", 2);

    public VirtualizationConfigurationVmwareFileFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualizationConfigurationVmwareFileFormat(File file) throws IOException, VirtualizationConfigurationException {
        int todo = (int)Math.min(100000L, file.length());
        int offset = 0;
        byte[] data = new byte[todo];
        FileInputStream fr = null;
        try {
            int ret;
            fr = new FileInputStream(file);
            while (todo > 0 && (ret = fr.read(data, offset, todo)) > 0) {
                todo -= ret;
                offset += ret;
            }
        }
        catch (Throwable throwable) {
            Util.safeClose(fr);
            throw throwable;
        }
        Util.safeClose(fr);
        this.init(data, offset);
    }

    public VirtualizationConfigurationVmwareFileFormat(InputStream is) throws IOException, VirtualizationConfigurationException {
        int ret;
        int todo = Math.max(4000, Math.min(100000, is.available()));
        int offset = 0;
        byte[] data = new byte[todo];
        while (todo > 0 && (ret = is.read(data, offset, todo)) > 0) {
            todo -= ret;
            offset += ret;
        }
        this.init(data, offset);
    }

    public VirtualizationConfigurationVmwareFileFormat(byte[] vmxContent, int length) throws VirtualizationConfigurationException {
        this.init(vmxContent, length);
    }

    private void init(byte[] vmxContent, int length) throws VirtualizationConfigurationException {
        try {
            String line;
            boolean isValid = false;
            BufferedReader reader = VirtualizationConfigurationVmwareFileFormat.getVmxReader(vmxContent, length);
            while ((line = reader.readLine()) != null) {
                KeyValuePair entry = VirtualizationConfigurationVmwareFileFormat.parse(line);
                if (entry == null) continue;
                if (entry.key.equals("virtualHW.version") || entry.key.equals("ddb.virtualHWVersion") || entry.key.equals("virtualhw.version")) {
                    isValid = true;
                }
                this.set(entry.key, this.unescape(entry.value));
            }
            if (!isValid) {
                throw new VirtualizationConfigurationException("Not in VMX format.");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Exception when loading vmx from byte array (how!?)", (Throwable)e);
        }
    }

    public static BufferedReader getVmxReader(byte[] vmxContent, int length) throws IOException {
        Charset cs = VirtualizationConfigurationVmwareFileFormat.getCharset(vmxContent, length);
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(vmxContent, 0, length), cs));
    }

    public static Charset getCharset(byte[] vmxContent, int length) {
        String csName = VirtualizationConfigurationVmwareFileFormat.detectCharset(new ByteArrayInputStream(vmxContent, 0, length));
        if (csName == null) {
            return null;
        }
        Charset cs = null;
        try {
            cs = Charset.forName(csName);
        }
        catch (Exception e) {
            LOGGER.warn("Could not instantiate charset " + csName, (Throwable)e);
        }
        if (cs == null) {
            cs = StandardCharsets.ISO_8859_1;
        }
        return cs;
    }

    private String unescape(String value) {
        String ret = value;
        if (ret.contains("|22")) {
            ret = ret.replace("|22", "\"");
        }
        if (ret.contains("|7C")) {
            ret = ret.replace("|7C", "|");
        }
        return ret;
    }

    private static String detectCharset(InputStream is) {
        boolean isVmware = false;
        try {
            String line;
            BufferedReader csDetectReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.ISO_8859_1));
            while ((line = csDetectReader.readLine()) != null) {
                KeyValuePair entry = VirtualizationConfigurationVmwareFileFormat.parse(line);
                if (entry == null) continue;
                if (entry.key.equals(".encoding") || entry.key.equals("encoding")) {
                    return entry.value;
                }
                if (!entry.key.equals("virtualHW.version") && !entry.key.equals("memsize") && !entry.key.equals("displayName")) continue;
                isVmware = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not detect charset, fallback to latin1", (Throwable)e);
        }
        if (!isVmware) {
            return null;
        }
        return "ISO-8859-1";
    }

    public Set<Map.Entry<String, ConfigEntry>> entrySet() {
        return this.entries.entrySet();
    }

    private static KeyValuePair parse(String line) {
        Matcher matcher = settingMatcher1.matcher(line);
        if (!matcher.matches()) {
            matcher = settingMatcher2.matcher(line);
        }
        if (!matcher.matches()) {
            return null;
        }
        return new KeyValuePair(matcher.group(1), matcher.group(2));
    }

    public ConfigEntry set(String key, String value, boolean replace) {
        if (!replace && this.entries.containsKey(key)) {
            return null;
        }
        ConfigEntry ce = new ConfigEntry(value);
        this.entries.put(key, ce);
        return ce;
    }

    public ConfigEntry set(String key, String value) {
        return this.set(key, value, true);
    }

    public ConfigEntry set(KeyValuePair entry) {
        return this.set(entry.key, entry.value);
    }

    public void remove(String key) {
        this.entries.remove(key);
    }

    public String get(String key) {
        ConfigEntry ce = this.entries.get(key);
        if (ce == null) {
            return null;
        }
        return ce.value;
    }

    public String toString() {
        this.set(".encoding", "UTF-8");
        StringBuilder sb = new StringBuilder(300);
        for (Map.Entry<String, ConfigEntry> entry : this.entries.entrySet()) {
            ConfigEntry value = entry.getValue();
            sb.append(entry.getKey());
            sb.append(" = \"");
            sb.append(value.getEscaped());
            sb.append("\"\n");
        }
        return sb.toString();
    }

    public static class ConfigEntry {
        private String value;

        public ConfigEntry(String value) {
            this.value = value;
        }

        public String getEscaped() {
            String ret = this.value;
            if (ret.contains("|")) {
                ret = ret.replace("|", "|7C");
            }
            if (ret.contains("\"")) {
                ret = ret.replace("\"", "|22");
            }
            return ret;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

