/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.container;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.util.TarArchiveUtil;
import org.openslx.util.Util;
import org.openslx.virtualization.configuration.container.ContainerImageContext;
import org.openslx.virtualization.configuration.container.ContainerMeta;

public class ContainerDefinition {
    protected static final Logger LOGGER = LogManager.getLogger(ContainerDefinition.class);
    protected static final String CONTAINER_FILE = "dockerfile";
    protected static final String CONTAINER_META_FILE = "container_meta.json";
    public String containerRecipe = "";
    public ContainerMeta containerMeta;

    public ContainerDefinition() {
        this.containerMeta = new ContainerMeta();
    }

    public ContainerDefinition(ContainerDefinition containerDef) {
        this.containerRecipe = String.valueOf(containerDef.getContainerRecipe());
        this.containerMeta = new ContainerMeta(containerDef.getContainerMeta());
    }

    public static ContainerDefinition fromByteArray(byte[] rawTarData) {
        ContainerDefinition containerDef = new ContainerDefinition();
        try {
            TarArchiveUtil.TarArchiveReader tarReader = new TarArchiveUtil.TarArchiveReader(new ByteArrayInputStream(rawTarData), true, true);
            while (tarReader.hasNextEntry()) {
                if (tarReader.getEntryName().equals(CONTAINER_FILE)) {
                    containerDef.setContainerRecipe(tarReader.readCurrentEntry());
                }
                if (!tarReader.getEntryName().equals(CONTAINER_META_FILE)) continue;
                containerDef.setContainerMeta(tarReader.readCurrentEntry());
            }
            tarReader.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not create a ContainerDefinition Object for rawTarData", (Throwable)e);
        }
        return containerDef;
    }

    public String getContainerRecipe() {
        return this.containerRecipe;
    }

    public void setContainerRecipe(String containerRecipe) {
        this.containerRecipe = containerRecipe;
    }

    public void setContainerRecipe(File containerRecipeFile) {
        this.containerRecipe = this.readContainerRecipe(containerRecipeFile);
    }

    public void setContainerRecipe(byte[] rawContainerRecipe) {
        this.containerRecipe = new String(rawContainerRecipe, StandardCharsets.UTF_8);
    }

    public ContainerMeta getContainerMeta() {
        return this.containerMeta;
    }

    public void setContainerMeta(byte[] containerMeta) {
        Gson gson = new GsonBuilder().create();
        this.containerMeta = (ContainerMeta)gson.fromJson(new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(containerMeta), StandardCharsets.UTF_8)), (Type)((Object)ContainerMeta.class));
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer containerDef = null;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TarArchiveUtil.TarArchiveWriter tarWriter = new TarArchiveUtil.TarArchiveWriter(baos);
            tarWriter.writeFile(CONTAINER_META_FILE, gson.toJson(this.containerMeta));
            tarWriter.writeFile(CONTAINER_FILE, this.containerRecipe);
            Util.safeClose(tarWriter);
            containerDef = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (IOException e) {
            LOGGER.warn("Could not create a tar file", (Throwable)e);
        }
        return containerDef;
    }

    private String readContainerRecipe(File file) {
        String recipe = null;
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream rawFile = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((count = bis.read(data)) != -1) {
                rawFile.write(data, 0, count);
            }
            String rawRecipe = new String(rawFile.toByteArray(), StandardCharsets.UTF_8);
            recipe = rawRecipe.replaceAll("\\r\\n", "\n");
            bis.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not read Container Recipe", (Throwable)e);
        }
        return recipe;
    }

    public void saveLocal(File destDir) {
        this.writeFile(destDir, this.containerRecipe, CONTAINER_FILE);
    }

    private void writeFile(File destDir, String fileContent, String filename) {
        File output = new File(destDir, filename);
        try {
            FileWriter fw = new FileWriter(output);
            fw.write(fileContent);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("Could not write File", (Throwable)e);
        }
    }

    public ContainerImageContext getContainerImageContext() {
        return ContainerImageContext.fromInt(this.containerMeta.getContainerImageContext());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerDefinition that = (ContainerDefinition)o;
        return this.containerRecipe.equals(that.containerRecipe) && this.containerMeta.equals(that.containerMeta);
    }

    public int hashCode() {
        return Objects.hash(this.containerRecipe, this.containerMeta);
    }
}

