/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.function.Predicate;
import org.openslx.bwlp.thrift.iface.Virtualizer;
import org.openslx.util.Util;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageQcow2;
import org.openslx.virtualization.disk.DiskImageVdi;
import org.openslx.virtualization.disk.DiskImageVmdk;

public abstract class DiskImage
implements Closeable {
    private RandomAccessFile diskImage = null;

    protected DiskImage(RandomAccessFile diskImage) {
        this.diskImage = diskImage;
    }

    protected RandomAccessFile getDiskImage() {
        return this.diskImage;
    }

    public abstract boolean isStandalone() throws DiskImageException;

    public abstract boolean isCompressed() throws DiskImageException;

    public abstract boolean isSnapshot() throws DiskImageException;

    public abstract Version getVersion() throws DiskImageException;

    public abstract String getDescription() throws DiskImageException;

    public abstract ImageFormat getFormat();

    public static DiskImage newInstance(File diskImagePath) throws FileNotFoundException, IOException, DiskImageException {
        RandomAccessFile fileHandle = new RandomAccessFile(diskImagePath, "r");
        try {
            if (DiskImageQcow2.probe(fileHandle)) {
                return new DiskImageQcow2(fileHandle);
            }
            if (DiskImageVdi.probe(fileHandle)) {
                return new DiskImageVdi(fileHandle);
            }
            if (DiskImageVmdk.probe(fileHandle)) {
                return new DiskImageVmdk(fileHandle);
            }
        }
        catch (Exception e) {
            Util.safeClose(fileHandle);
            throw e;
        }
        Util.safeClose(fileHandle);
        String errorMsg = "File '" + diskImagePath.getAbsolutePath() + "' is not a valid disk image!";
        throw new DiskImageException(errorMsg);
    }

    @Override
    public void close() throws IOException {
        Util.safeClose(this.diskImage);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static enum ImageFormat {
        NONE("none"),
        QCOW2("qcow2"),
        VDI("vdi"),
        VMDK("vmdk");

        public final String extension;

        private ImageFormat(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean isSupportedbyVirtualizer(List<ImageFormat> supportedImageFormats) {
            Predicate<ImageFormat> matchDiskFormat = supportedImageFormat -> supportedImageFormat.toString().equalsIgnoreCase(this.toString());
            return supportedImageFormats.stream().anyMatch(matchDiskFormat);
        }

        public static ImageFormat defaultForVirtualizer(Virtualizer virt) {
            if (virt == null) {
                return null;
            }
            return ImageFormat.defaultForVirtualizer(virt.virtId);
        }

        public static ImageFormat defaultForVirtualizer(String virtId) {
            ImageFormat imgFormat = null;
            if ("docker".equals(virtId)) {
                imgFormat = NONE;
            } else if ("qemukvm".equals(virtId)) {
                imgFormat = QCOW2;
            } else if ("virtualbox".equals(virtId)) {
                imgFormat = VDI;
            } else if ("vmware".equals(virtId)) {
                imgFormat = VMDK;
            }
            return imgFormat;
        }

        public String toString() {
            return this.getExtension();
        }
    }
}

