/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.RandomAccessFile;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageUtils;

public class DiskImageQcow2
extends DiskImage {
    private static final int QCOW2_MAGIC = 1363560955;

    DiskImageQcow2(RandomAccessFile diskImage) {
        super(diskImage);
    }

    public static boolean probe(RandomAccessFile diskImage) throws DiskImageException {
        int diskImageMagic = DiskImageUtils.readInt(diskImage, 0L);
        boolean isQcow2ImageFormat = diskImageMagic == 1363560955;
        return isQcow2ImageFormat;
    }

    @Override
    public boolean isStandalone() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        long qcowBackingFileOffset = DiskImageUtils.readLong(diskFile, 8L);
        boolean qcowStandalone = qcowBackingFileOffset == 0L;
        return qcowStandalone;
    }

    @Override
    public boolean isCompressed() throws DiskImageException {
        long qcowIncompatibleFeatures;
        RandomAccessFile diskFile = this.getDiskImage();
        boolean qcowCompressed = false;
        boolean qcowUseExtendedL2 = this.getVersion().getMajor() >= Short.valueOf("3") ? ((qcowIncompatibleFeatures = DiskImageUtils.readLong(diskFile, 72L)) & 0x10L) >>> 4 == 1L : false;
        int qcowL1TableSize = DiskImageUtils.readInt(diskFile, 36L);
        if (qcowL1TableSize > 0) {
            int qcowClusterBits = DiskImageUtils.readInt(diskFile, 20L);
            int qcowClusterSize = 1 << qcowClusterBits;
            int qcowL1TableEntrySize = 8;
            int qcowL2TableEntrySize = qcowUseExtendedL2 ? 16 : 8;
            int qcowL2TableSize = qcowClusterSize / qcowL2TableEntrySize;
            long qcowL1TableOffset = DiskImageUtils.readLong(diskFile, 40L);
            for (long i = 0L; i < (long)qcowL1TableSize; ++i) {
                long qcowL1TableEntryOffset = qcowL1TableOffset + i * 8L;
                long qcowL1TableEntry = DiskImageUtils.readLong(diskFile, qcowL1TableEntryOffset);
                long qcowL2TableOffset = qcowL1TableEntry & 0xFFFFFFFFFFFE00L;
                if (qcowL2TableOffset == 0L) continue;
                for (long j = 0L; j < (long)qcowL2TableSize; ++j) {
                    boolean qcowClusterCompressed;
                    long qcowL2TableEntryOffset = qcowL2TableOffset + j * (long)qcowL2TableEntrySize;
                    long qcowL2TableEntry = DiskImageUtils.readLong(diskFile, qcowL2TableEntryOffset);
                    boolean bl = qcowClusterCompressed = (qcowL2TableEntry & 0x4000000000000000L) >>> 62 == 1L;
                    if (!qcowClusterCompressed) continue;
                    qcowCompressed = true;
                    break;
                }
                if (!qcowCompressed) {
                    continue;
                }
                break;
            }
        } else {
            qcowCompressed = false;
        }
        return qcowCompressed;
    }

    @Override
    public boolean isSnapshot() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        int qcowNumSnapshots = DiskImageUtils.readInt(diskFile, 56L);
        boolean qcowSnapshot = qcowNumSnapshots == 0;
        return qcowSnapshot;
    }

    @Override
    public Version getVersion() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        int qcowVersion = DiskImageUtils.readInt(diskFile, 4L);
        if (qcowVersion < 2 || qcowVersion > 3) {
            String errorMsg = "Invalid QCOW2 version in header found!";
            throw new DiskImageException("Invalid QCOW2 version in header found!");
        }
        return new Version(Integer.valueOf(qcowVersion).shortValue());
    }

    @Override
    public String getDescription() throws DiskImageException {
        return null;
    }

    @Override
    public DiskImage.ImageFormat getFormat() {
        return DiskImage.ImageFormat.QCOW2;
    }
}

