/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.openslx.virtualization.disk.DiskImageException;

public class DiskImageUtils {
    public static long getImageSize(RandomAccessFile diskImage) throws DiskImageException {
        long imageSize;
        try {
            imageSize = diskImage.length();
        }
        catch (IOException e) {
            throw new DiskImageException(e.getLocalizedMessage());
        }
        return imageSize;
    }

    public static short readShort(RandomAccessFile diskImage, long offset) throws DiskImageException {
        long imageSize = DiskImageUtils.getImageSize(diskImage);
        short value = 0;
        if (imageSize >= offset + 2L) {
            try {
                diskImage.seek(offset);
                value = diskImage.readShort();
            }
            catch (IOException e) {
                throw new DiskImageException(e.getLocalizedMessage());
            }
        }
        return value;
    }

    public static int readInt(RandomAccessFile diskImage, long offset) throws DiskImageException {
        long imageSize = DiskImageUtils.getImageSize(diskImage);
        int value = 0;
        if (imageSize >= offset + 4L) {
            try {
                diskImage.seek(offset);
                value = diskImage.readInt();
            }
            catch (IOException e) {
                throw new DiskImageException(e.getLocalizedMessage());
            }
        }
        return value;
    }

    public static long readLong(RandomAccessFile diskImage, long offset) throws DiskImageException {
        long imageSize = DiskImageUtils.getImageSize(diskImage);
        long value = 0L;
        if (imageSize >= offset + 8L) {
            try {
                diskImage.seek(offset);
                value = diskImage.readLong();
            }
            catch (IOException e) {
                throw new DiskImageException(e.getLocalizedMessage());
            }
        }
        return value;
    }

    public static byte[] readBytesAsArray(RandomAccessFile diskImage, long offset, int numBytes) throws DiskImageException {
        long imageSize = DiskImageUtils.getImageSize(diskImage);
        byte[] values = new byte[]{};
        if (imageSize >= offset + (long)numBytes) {
            try {
                diskImage.seek(offset);
                values = new byte[numBytes];
                diskImage.readFully(values);
            }
            catch (IOException e) {
                throw new DiskImageException(e.getLocalizedMessage());
            }
        }
        return values;
    }
}

