/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageUtils;

public class DiskImageVdi
extends DiskImage {
    private static final int VDI_MAGIC = 2131811006;
    private static final byte[] ZERO_UUID = new byte[16];

    DiskImageVdi(RandomAccessFile diskImage) {
        super(diskImage);
    }

    public static boolean probe(RandomAccessFile diskImage) throws DiskImageException {
        int diskImageMagic = DiskImageUtils.readInt(diskImage, 64L);
        boolean isVdiImageFormat = diskImageMagic == 2131811006;
        return isVdiImageFormat;
    }

    @Override
    public boolean isStandalone() throws DiskImageException {
        return true;
    }

    @Override
    public boolean isCompressed() throws DiskImageException {
        return false;
    }

    @Override
    public boolean isSnapshot() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        byte[] parentUuid = DiskImageUtils.readBytesAsArray(diskFile, 440L, 16);
        return !Arrays.equals(ZERO_UUID, parentUuid);
    }

    @Override
    public Version getVersion() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        short vdiVersionMajor = Short.reverseBytes(DiskImageUtils.readShort(diskFile, 68L));
        short vdiVersionMinor = Short.reverseBytes(DiskImageUtils.readShort(diskFile, 70L));
        return new Version(vdiVersionMajor, vdiVersionMinor);
    }

    @Override
    public String getDescription() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        byte[] data = DiskImageUtils.readBytesAsArray(diskFile, 84L, 256);
        return new String(data, StandardCharsets.UTF_8);
    }

    @Override
    public DiskImage.ImageFormat getFormat() {
        return DiskImage.ImageFormat.VDI;
    }
}

