/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import org.openslx.util.Util;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVmwareFileFormat;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageUtils;

public class DiskImageVmdk
extends DiskImage {
    private static final int VMDK_MAGIC = 1262767446;
    private static final int VMDK_SECTOR_SIZE = 512;
    private static final int VMDK_DEFAULT_HW_VERSION = 10;
    private final VirtualizationConfigurationVmwareFileFormat vmdkConfig = this.parseVmdkConfig();

    DiskImageVmdk(RandomAccessFile diskImage) throws DiskImageException {
        super(diskImage);
    }

    public static boolean probe(RandomAccessFile diskImage) throws DiskImageException {
        int diskImageMagic = DiskImageUtils.readInt(diskImage, 0L);
        boolean isVmdkImageFormat = diskImageMagic == 1262767446;
        return isVmdkImageFormat;
    }

    private String getCreationType() {
        VirtualizationConfigurationVmwareFileFormat vmdkConfig = this.getVmdkConfig();
        String vmdkCreationType = vmdkConfig == null ? null : this.vmdkConfig.get("createType");
        return vmdkCreationType;
    }

    protected VirtualizationConfigurationVmwareFileFormat parseVmdkConfig() throws DiskImageException {
        VirtualizationConfigurationVmwareFileFormat vmdkConfig;
        RandomAccessFile diskFile = this.getDiskImage();
        long vmdkDescriptorSectorOffset = Long.reverseBytes(DiskImageUtils.readLong(diskFile, 28L));
        long vmdkDescriptorSectorSize = Long.reverseBytes(DiskImageUtils.readLong(diskFile, 36L));
        if (vmdkDescriptorSectorOffset > 0L) {
            long vmdkDescriptorOffset = vmdkDescriptorSectorOffset * 512L;
            long vmdkDescriptorSizeMax = vmdkDescriptorSectorSize * 512L;
            String descriptorStr = new String(DiskImageUtils.readBytesAsArray(diskFile, vmdkDescriptorOffset, Long.valueOf(vmdkDescriptorSizeMax).intValue()), StandardCharsets.US_ASCII);
            int vmdkDescriptorSize = descriptorStr.indexOf(0);
            if ((long)vmdkDescriptorSize > vmdkDescriptorSizeMax || vmdkDescriptorSize < 0) {
                String errorMsg = "Embedded descriptor size in VMDK disk image is invalid!";
                throw new DiskImageException("Embedded descriptor size in VMDK disk image is invalid!");
            }
            String configStr = descriptorStr.substring(0, vmdkDescriptorSize);
            try {
                vmdkConfig = new VirtualizationConfigurationVmwareFileFormat(configStr.getBytes(), vmdkDescriptorSize);
            }
            catch (VirtualizationConfigurationException e) {
                throw new DiskImageException(e.getLocalizedMessage());
            }
        } else {
            vmdkConfig = null;
        }
        return vmdkConfig;
    }

    protected VirtualizationConfigurationVmwareFileFormat getVmdkConfig() {
        return this.vmdkConfig;
    }

    public Version getHwVersion() throws DiskImageException {
        Version hwVersion;
        VirtualizationConfigurationVmwareFileFormat vmdkConfig = this.getVmdkConfig();
        if (vmdkConfig != null) {
            String hwVersionStr = vmdkConfig.get("ddb.virtualHWVersion");
            int hwVersionMajor = Util.parseInt(hwVersionStr, 10);
            hwVersion = new Version(Integer.valueOf(hwVersionMajor).shortValue());
        } else {
            int hwVersionMajor = 10;
            hwVersion = new Version(Integer.valueOf(10).shortValue());
        }
        return hwVersion;
    }

    @Override
    public boolean isStandalone() throws DiskImageException {
        String vmdkCreationType = this.getCreationType();
        boolean vmdkStandalone = vmdkCreationType != null ? (this.isSnapshot() ? false : vmdkCreationType.equalsIgnoreCase("streamOptimized") || vmdkCreationType.equalsIgnoreCase("monolithicSparse")) : false;
        return vmdkStandalone;
    }

    @Override
    public boolean isCompressed() throws DiskImageException {
        String vmdkCreationType = this.getCreationType();
        boolean vmdkCompressed = vmdkCreationType != null && vmdkCreationType.equalsIgnoreCase("streamOptimized");
        return vmdkCompressed;
    }

    @Override
    public boolean isSnapshot() throws DiskImageException {
        String parentCid;
        VirtualizationConfigurationVmwareFileFormat vmdkConfig = this.getVmdkConfig();
        boolean vmdkSnapshot = vmdkConfig == null ? false : (parentCid = vmdkConfig.get("parentCID")) != null && !parentCid.equalsIgnoreCase("ffffffff");
        return vmdkSnapshot;
    }

    @Override
    public Version getVersion() throws DiskImageException {
        RandomAccessFile diskFile = this.getDiskImage();
        int vmdkVersion = Integer.reverseBytes(DiskImageUtils.readInt(diskFile, 4L));
        return new Version(Integer.valueOf(vmdkVersion).shortValue());
    }

    @Override
    public String getDescription() throws DiskImageException {
        return null;
    }

    @Override
    public DiskImage.ImageFormat getFormat() {
        return DiskImage.ImageFormat.VMDK;
    }
}

